<!doctype html>
<html lang="<?php echo e(str_replace('_','-',app()->getLocale())); ?>">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
  <title><?php echo $__env->yieldContent('title','Auto Rice Mill'); ?></title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>

  <style>
    :root{
      --brand-left:#2D82F3; --brand-mid:#2A6FDF; --brand-right:#1E4596;

      --brand-txt:#ffffff;
      --sidebar-w:180px;

      --page-bg:#ffffff;
      --card:#fff; --border:#e5e7eb;

      --text:#111827; --muted:#6b7280; --active:#2563eb;

      /* menu/submenu heights */
      --topbar-h:56px;
      --item-h:36px;
      --subitem-h:32px;

      --btn-size:20px; --radius:8px;
    }

    *{box-sizing:border-box}
    html,body{height:100%;margin:0}
    body{background:var(--page-bg);color:var(--text);font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;overflow:hidden}

    /* ===== TOPBAR ===== */
    .topbar{
      position:fixed; inset:0 0 auto 0; z-index:1000;
      height:var(--topbar-h);
      background-image:linear-gradient(90deg,var(--brand-left) 0%,var(--brand-mid) 40%,var(--brand-right) 100%);
      color:var(--brand-txt);
      display:flex; align-items:center; justify-content:space-between;
      padding:0 10px 0 0; border-bottom:1px solid rgba(255,255,255,.18);
    }
    .app{position:fixed; inset:var(--topbar-h) 0 0 0; display:flex; overflow:hidden; min-height:0}

    .brand-side{display:flex;align-items:center;gap:8px;min-width:0}
    .brand-box{flex:0 0 var(--sidebar-w); max-width:var(--sidebar-w); padding-left:0; display:flex; align-items:center; gap:8px; min-width:0; overflow:hidden}
    body.sidebar-collapsed .brand-box{flex-basis:64px;max-width:64px;justify-content:center}
    .brand-title{font-weight:800;font-size:16px;line-height:1;color:#fff;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}
    body.sidebar-collapsed .brand-title{display:none!important}
    .online-dot{width:8px;height:8px;border-radius:50%;background:#22c55e;display:inline-block;box-shadow:0 0 0 0 rgba(34,197,94,.7);animation:pulse 1.5s infinite}
    @keyframes pulse{0%{box-shadow:0 0 0 0 rgba(34,197,94,.7)}70%{box-shadow:0 0 0 8px rgba(34,197,94,0)}100%{box-shadow:0 0 0 0 rgba(34,197,94,0)}}

    .mini-pill{display:flex;align-items:center;gap:6px;padding:6px 10px}
    .pill-btn{width:26px;height:26px;border-radius:50%;display:flex;align-items:center;justify-content:center;color:#fff;border:1px solid rgba(255,255,255,.8);background:transparent;cursor:pointer;transition:background .12s ease}
    .pill-btn:hover{background:rgba(255,255,255,.14)}

    .quick{display:flex;align-items:center;gap:8px}
    .quick .btn{width:30px;height:30px;border-radius:6px;border:0;cursor:pointer;display:inline-flex;align-items:center;justify-content:center;color:#fff;background:rgba(255,255,255,.10);box-shadow:inset 0 0 0 2px rgba(255,255,255,.55);transition:background .12s ease}
    .quick .btn:hover{background:rgba(255,255,255,.20)}
    .quick .gap{width:12px}
    .quick .btn.--green{background:#16a34a}.quick .btn.--teal{background:#0ea5a4}.quick .btn.--blue{background:#2563eb}.quick .btn.--orange{background:#f59e0b}.quick .btn.--red{background:#ef4444}

    .toolbar-right{display:flex;align-items:center;gap:8px}
    .date-chip{min-width:110px;height:var(--btn-size);display:inline-flex;align-items:center;justify-content:center;color:#fff;background:#10b981;border:2px solid rgba(255,255,255,.75);border-radius:var(--radius);font-weight:800;padding:0 10px}
    .icon-btn{width:var(--btn-size);height:var(--btn-size);border-radius:var(--radius);display:flex;align-items:center;justify-content:center;color:#fff;background:#10b981;border:2px solid rgba(255,255,255,.75);cursor:pointer}
    .icon-btn.alt{background:#22c55e}
    .bell{position:relative}.bell .dot{position:absolute;right:-6px;top:-6px;background:#ef4444;color:#fff;font-size:10px;line-height:1;padding:2px 5px;border-radius:999px}

    .dropdown{position:relative}
    .user{display:flex;align-items:center;gap:8px;background:rgba(255,255,255,.14);padding:6px 10px;border-radius:999px;cursor:pointer}
    .user img{width:26px;height:26px;border-radius:50%;background:#fff}
    .user .lines{display:flex;flex-direction:column;line-height:1.05}
    .user .lines small{font-size:11px;color:#eaf6ff}
    .user .lines strong{font-size:12px;color:#fff}
    .dropdown-menu{position:absolute;right:0;top:42px;background:#fff;color:var(--text);border:1px solid var(--border);border-radius:8px;box-shadow:0 8px 24px rgba(0,0,0,.10);min-width:200px;display:none;z-index:40;padding:6px 0}
    .dropdown.open .dropdown-menu{display:block}
    .dropdown-menu a{display:flex;gap:10px;align-items:center;padding:10px 12px;color:var(--text);text-decoration:none}
    .dropdown-menu a:hover{background:#f7f7fb;color:#1d4ed8}

    /* ===== SIDEBAR ===== */
    .sidebar{
      width:var(--sidebar-w);
      background:linear-gradient(180deg,#262c40 0%, #1f2537 60%, #191e2e 100%);
      color:#fff;
      border-right:1px solid rgba(255,255,255,.05);
      height:100%; overflow-y:auto; overscroll-behavior:contain; -webkit-overflow-scrolling:touch;
      scrollbar-width:thin; scrollbar-color:#3b4160 transparent; padding-left:0;
    }
    .sidebar::-webkit-scrollbar{width:8px}
    .sidebar::-webkit-scrollbar-thumb{background:#3b4160;border-radius:8px}

    /* collapsed */
    body.sidebar-collapsed .sidebar{width:64px}
    body.sidebar-collapsed .arm-link > span,
    body.sidebar-collapsed .arm-chev,
    body.sidebar-collapsed .arm-sub{display:none!important}
    body.sidebar-collapsed .arm-link{color:transparent!important; justify-content:center}
    body.sidebar-collapsed .arm-link .arm-ico,
    body.sidebar-collapsed .arm-link .arm-ico i{color:#fff!important}

    .arm-sidebar{padding:0}
    .arm-menu,.arm-menu ul{list-style:none;margin:0;padding:0}
    .arm-item{position:relative}

    .arm-link{
      display:flex; align-items:center; gap:10px; width:100%;
      padding:6px 10px 6px 8px; height:var(--item-h);
      border-radius:8px; text-decoration:none; border:0; background:transparent;
      color:#fff; cursor:pointer; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; min-width:0;
      font-size:13px;
    }
    .arm-ico{width:20px;text-align:center;color:#fff;flex:0 0 20px}

    .sidebar .arm-link,
    .sidebar .arm-link *:not(.badge){
      color:#fff!important;
      opacity:1!important;
      fill:#fff!important;
      stroke:#fff!important;
    }

    .arm-chev{display:none}

    .arm-item.has-children > .arm-link::after{
      content:"\f107"; /* fa-chevron-down */
      font-family:"Font Awesome 6 Free"; font-weight:900;
      margin-left:auto; width:14px; text-align:center; opacity:.85;
      transition:transform .2s ease, opacity .2s ease;
    }
    .arm-item.is-open > .arm-link::after{ transform:rotate(180deg) }

    /* Submenu */
    .arm-sub{display:none;margin:0;padding:0;border:0}
    .arm-item.has-children.is-open > .arm-sub{display:block;margin:0;padding:0;background:none;border:0}

    .arm-sublink{
      display:flex;align-items:center;gap:8px;width:100%;
      padding:5px 10px 5px 20px; height:var(--subitem-h);
      border-radius:6px;color:#fff;text-decoration:none;background:transparent;border:0;cursor:pointer;
      white-space:nowrap;overflow:hidden;text-overflow:ellipsis;
      font-size:12px;
    }
    /* tiny chevron baseline (we override below for big arrow) */
    .arm-sublink::before{
      content:"\f105"; font-family:"Font Awesome 6 Free"; font-weight:900;
      width:10px; margin-right:6px; color:#c8cde0; display:inline-block; text-align:center;
    }

    .arm-item.is-active > .arm-link{background:transparent;color:#fff!important;box-shadow:none}
    .arm-item.is-active > .arm-link .arm-ico{color:#fff!important}

    /* ===== CONTENT ===== */
    .content{flex:1; min-width:0; min-height:0; display:flex; flex-direction:column; overflow-y:auto; overscroll-behavior:contain; -webkit-overflow-scrolling:touch; background:#fff}
    .container{padding:16px;flex:1; background:#fff}
    .footer{background:#fff; border-top:1px solid var(--border); padding:10px 16px; font-size:13px; color:#6b7280; display:flex; align-items:center; justify-content:space-between; gap:12px}
    .footer b{color:#374151}

    /* ===== HOVER DISABLED FOR SIDEBAR ONLY ===== */
    .sidebar .arm-link,
    .sidebar .arm-sublink{transition:none!important}
    .sidebar .arm-link:hover,
    .sidebar .arm-sublink:hover{
      background:transparent!important;
      color:inherit!important;
      text-decoration:none!important;
    }
    .sidebar .arm-link:hover i,
    .sidebar .arm-link:hover .fa,
    .sidebar .arm-link:hover svg,
    .sidebar .arm-link:hover span,
    .sidebar .arm-sublink:hover i,
    .sidebar .arm-sublink:hover .fa,
    .sidebar .arm-sublink:hover svg,
    .sidebar .arm-sublink:hover span{
      color:inherit!important;
      fill:currentColor!important;
      stroke:currentColor!important;
      opacity:1!important;
      filter:none!important;
    }

    /* ===== OVERRIDE: big right arrow in submenu leaf items ===== */
    :root{
      --sub-arrow-size: 16px;      /* 16–20 */
      --sub-arrow-left: 12px;      /* horizontal offset */
      --sub-arrow-color:#cfd4e6;   /* soft gray */
    }
    .arm-sublink{ position:relative; padding-left:28px !important; }
    .arm-sublink::before{
      content:"\27A1";             /* ➡ */
      position:absolute;
      left:var(--sub-arrow-left);
      top:50%;
      transform:translateY(-50%);
      font-size:var(--sub-arrow-size);
      line-height:1;
      color:var(--sub-arrow-color);
      font-weight:900;
      font-family:"Segoe UI Symbol", system-ui, -apple-system, "Segoe UI", Arial, sans-serif;
      opacity:.95;
    }

    /* ===== CLEAR DIFFERENCE: single vs dropdown ===== */

    /* Top-level parent look: left blue rail + bigger blue chevron */
    .arm-item.has-children > .arm-link {
      position: relative;
      background: rgba(255,255,255,0.03);
    }
    .arm-item.has-children > .arm-link::before{
      content: "";
      position: absolute;
      left: 0;
      top: 50%;
      transform: translateY(-50%);
      width: 3px;
      height: 60%;
      border-radius: 2px;
      background: #5aa0ff;
      opacity: .9;
    }
    .arm-item.has-children > .arm-link::after{
      font-size: 13px;
      color: #8fb1ff;
      opacity: 1;
    }
    /* Singles: no chevron */
    .arm-item:not(.has-children) > .arm-link::after{ content: ""; }

    /* Submenu separators for readability */
    .arm-sub > li + li { border-top: 1px dashed rgba(255,255,255,.06); }

    /* Submenu parent (has children): remove big ➡; show small caret on right; bold */
    .arm-item.has-children > .arm-sublink{
      position: relative;
      padding-left: 16px !important;
      font-weight: 600;
      background: rgba(255,255,255,.02);
    }
    .arm-item.has-children > .arm-sublink::before{ content: ""; }
    .arm-item.has-children > .arm-sublink::after{
      content:"\f107";
      font-family:"Font Awesome 6 Free"; font-weight:900;
      position:absolute; right:8px; top:50%; transform:translateY(-50%);
      color:#9fb8ff; opacity:.95; font-size:12px;
    }
    .sidebar .arm-item.has-children > .arm-link:hover,
    .sidebar .arm-item.has-children > .arm-sublink:hover{
      background: rgba(255,255,255,.06) !important;
    }
  </style>

  <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
  <header class="topbar">
    <div class="brand-side">
      <div class="brand-box" title="Auto Rice Mill">
        <div class="brand-title">মেসার্স অটো রাইস মিল</div>
        <span class="online-dot" title="Online"></span>
      </div>

      <div class="mini-pill">
        <button id="sidebarToggle" class="pill-btn" title="Toggle sidebar">
          <i class="fa-solid fa-bars"></i>
        </button>
      </div>
    </div>

    <div class="quick">
      <div class="btn --blue"   title="Order"><i class="fa fa-shopping-bag fa-sm"></i></div>
      <div class="btn --green"  title="Purchase"><i class="fa-solid fa-cart-shopping"></i></div>
      <div class="btn --orange" title="Due Collection"><i class="fa-solid fa-plus"></i></div>
      <div class="gap"></div>
      <div class="btn --teal"   title="Raw Purchases"><i class="fa fa-credit-card fa-sm"></i></div>
      <div class="btn --blue"   title="Finish Purchases"><i class="fa fa-industry fa-sm"></i></div>
      <div class="btn --red"    title="Supplier Payment"><i class="fa fa-minus fa-sm"></i></div>
      <div class="gap"></div>
      <div class="btn --green"  title="Payment Voucher"><i class="fa-solid fa-wallet fa-sm"></i></div>
      <div class="btn --orange" title="Receive Voucher"><i class="fa-solid fa-sack-dollar fa-sm"></i></div>
    </div>

    <div class="toolbar-right">
      <div class="date-chip" id="todayChip"><?php echo e(now()->format('d-m-Y')); ?></div>
      <button class="icon-btn" id="btnRefresh" title="Refresh / Clear cache">
        <i class="fa-solid fa-rotate"></i>
      </button>

      <div class="icon-btn alt bell" title="Notifications">
        <i class="fa-regular fa-bell"></i>
        <span class="dot">5</span>
      </div>

      <div class="dropdown" id="profileDropdown">
        <div class="user">
          <img src="https://i.pravatar.cc/40?img=1" alt="avatar">
          <span class="lines">
            <small>Welcome,</small>
            <strong><?php echo e(\Illuminate\Support\Str::limit(auth()->user()->name ?? 'System Admin', 18)); ?></strong>
          </span>
          <i class="fa-solid fa-caret-down"></i>
        </div>
        <div class="dropdown-menu">
          <?php if(Route::has('password.change')): ?>
            <a href="<?php echo e(route('password.change')); ?>"><i class="fa-solid fa-user-lock"></i> Change Password</a>
          <?php endif; ?>
          <form action="<?php echo e(route('logout')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <a href="#" onclick="this.closest('form').submit();return false;">
              <i class="fa-solid fa-power-off"></i> Logout
            </a>
          </form>
        </div>
      </div>
    </div>
  </header>

  <div class="app">
    <aside class="sidebar"><?php echo $__env->make('layouts.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></aside>

    <main class="content">
      <div class="container"><?php echo $__env->yieldContent('content'); ?></div>
      <footer class="footer">
        <div>Developed By: <b>Core4 Billings Technologies Ltd</b></div>
        <div><b>Software Version 3.0</b></div>
      </footer>
    </main>
  </div>

  <script>
    (function(){
      // Profile dropdown
      const d = document.getElementById('profileDropdown');
      d?.querySelector('.user')?.addEventListener('click', ()=> d.classList.toggle('open'));
      document.addEventListener('click', (e)=>{ if(d && !d.contains(e.target)) d.classList.remove('open'); });
      document.addEventListener('keydown', (e)=>{ if(e.key === 'Escape') d?.classList.remove('open'); });

      // Sidebar collapse
      const body = document.body;
      const KEY  = 'arm.sidebar.collapsed';
      if(localStorage.getItem(KEY) === '1') body.classList.add('sidebar-collapsed');
      document.getElementById('sidebarToggle')?.addEventListener('click', ()=>{
        body.classList.toggle('sidebar-collapsed');
        localStorage.setItem(KEY, body.classList.contains('sidebar-collapsed') ? '1' : '0');
      });

      // Sidebar accordion + only one open at a time
      const side = document.querySelector('.sidebar');
      side?.addEventListener('click', (e)=>{
        const btn = e.target.closest('.arm-link, .arm-sublink, a');
        if(!btn) return;

        if(btn.tagName === 'A' && (!btn.getAttribute('href') || btn.getAttribute('href') === '#')) e.preventDefault();

        const li = btn.closest('li');
        if(li && li.classList.contains('has-children')){
          e.preventDefault();
          if(body.classList.contains('sidebar-collapsed')) return;

          const parent = li.parentElement;
          parent?.querySelectorAll(':scope > li.has-children.is-open').forEach(sib=>{
            if(sib !== li) sib.classList.remove('is-open');
          });
          li.classList.toggle('is-open');
        }
      }, false);

      // Titles for collapsed items
      const setTitles = ()=>{
        document.querySelectorAll('.arm-link').forEach(a=>{
          const labelNode = Array.from(a.childNodes).find(n => n.nodeType===Node.TEXT_NODE || (n.nodeType===Node.ELEMENT_NODE && !n.classList?.contains('arm-ico') && !n.classList?.contains('arm-chev')));
          const label = (labelNode?.textContent || a.textContent || '').trim();
          if(label) a.setAttribute('title', label);
        });
      };
      setTitles();

      // Refresh
      const refreshBtn = document.getElementById('btnRefresh');
      refreshBtn?.addEventListener('click', async () => {
        refreshBtn.disabled = true; refreshBtn.style.opacity = .7;
        try{
          const url = "<?php echo e(Route::has('system.refresh') ? route('system.refresh') : ''); ?>";
          if(url){
            await fetch(url, { method:'POST', headers:{'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content }});
          }
        }catch(e){}
        location.reload(true);
      });
    })();
  </script>

  <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\rice-mill\resources\views/layouts/app.blade.php ENDPATH**/ ?>