<?php

use Illuminate\Support\Facades\Route;

/**
 * Controllers (all live directly in app/Http/Controllers)
 */

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\CustomersController;
use App\Http\Controllers\SuppliersController;
use App\Http\Controllers\PartyTypesController;
use App\Http\Controllers\CustomerCsvController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\BagTypeController;
use App\Http\Controllers\BagExchangeController;
use App\Http\Controllers\WarehouseTypeController;
use App\Http\Controllers\WarehouseController;
use App\Http\Controllers\DayarController;
use App\Http\Controllers\MillController;
use App\Http\Controllers\AreaController;
use App\Http\Controllers\RawMaterialController;
use App\Http\Controllers\FinishProductController;
use App\Http\Controllers\FinishBagController;
use App\Http\Controllers\RawMaterialPurchaseController;
use App\Http\Controllers\FinishProductPurchaseController;
use App\Http\Controllers\FinishBagPurchaseController;
use App\Http\Controllers\RawBagPurchaseController;
use App\Http\Controllers\RawMaterialTransferController;
use App\Http\Controllers\FinishProductTransferController;
use App\Http\Controllers\RawProductAdjustmentController;
use App\Http\Controllers\FinishProductAdjustmentController;
use App\Http\Controllers\FinishBagAdjustmentController;
use App\Http\Controllers\RawBagAdjustmentController;
use App\Http\Controllers\RawBagOpeningController;
use App\Http\Controllers\GSAdjustmentController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\SalesDeliveryController;

/*
|--------------------------------------------------------------------------
| Guest Routes — Login
|--------------------------------------------------------------------------
*/
Route::middleware('guest')->group(function () {
    Route::get('/login',  [LoginController::class, 'create'])->name('login');
    Route::post('/login', [LoginController::class, 'store']);
});



/*
|--------------------------------------------------------------------------
| Authenticated Routes
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {

    /** Logout */
    Route::post('/logout', [LoginController::class, 'destroy'])->name('logout');

    /** -------- Change Password -------- */
    Route::get('/password/change', [PasswordController::class, 'edit'])->name('password.change');
    Route::put('/password/change', [PasswordController::class, 'update'])->name('password.update');

    /** -------- Users (CRUD + extras) -------- */
    Route::resource('users', UserController::class);
    Route::patch('/users/{user}/toggle', [UserController::class,'toggle'])->name('users.toggle');
    Route::post('/users/{user}/reset-password', [UserController::class,'resetPassword'])->name('users.reset.password');

    /** -------- Roles & Permissions -------- */
    Route::resource('roles', RoleController::class)->except(['show'])->names('roles');
    Route::resource('permissions', PermissionController::class)->except(['show'])->names('permissions');

    /** -------- Own profile -------- */
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');

    /** -------- Settings -------- */
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/business',  [SettingsController::class,'business'])->name('business');
        Route::put('/business',  [SettingsController::class,'businessSave'])->name('business.save');

        Route::get('/invoice',   [SettingsController::class,'invoice'])->name('invoice');
        Route::put('/invoice',   [SettingsController::class,'invoiceSave'])->name('invoice.save');

        Route::get('/printers',  [SettingsController::class,'printers'])->name('printers');
        Route::put('/printers',  [SettingsController::class,'printersSave'])->name('printers.save');

        Route::get('/payments',  [SettingsController::class,'payments'])->name('payments');
        Route::put('/payments',  [SettingsController::class,'paymentsSave'])->name('payments.save');

        Route::get('/currencies',[SettingsController::class,'currencies'])->name('currencies');
        Route::put('/currencies',[SettingsController::class,'currenciesSave'])->name('currencies.save');

        // View-only
        Route::view('/taxes', 'settings.taxes')->name('taxes');
    });

    /** ---------------- Home ---------------- */
    Route::view('/', 'home')->name('home');

    /*
    |--------------------------------------------------------------------------
    | Party (controller-backed; no closures)
    |--------------------------------------------------------------------------
    */
    // Customers resource
    Route::resource('customers', CustomersController::class)->except(['show'])->names('customers');

    // Suppliers resource
    Route::resource('suppliers', SuppliersController::class)->except(['show'])->names('suppliers');
    Route::match(['get', 'post'], 'suppliers/csv', [SuppliersController::class, 'csv'])->name('suppliers.csv');
    Route::post('suppliers/{supplier}/toggle', [SuppliersController::class, 'toggle'])->name('suppliers.toggle');
    Route::get('/suppliers/export', [SuppliersController::class, 'export'])->name('suppliers.export');

    // Party types resource
    Route::resource('party-types', PartyTypesController::class)->except(['show'])->names('party_types');

    // Customers CSV workflow
    Route::get('/customers/csv', [CustomerCsvController::class, 'index'])
        ->name('party.customers.csv');

    Route::get('/customers/csv/upload', [CustomerCsvController::class, 'uploadForm'])
        ->name('party.customers.csv.upload');
    Route::post('/customers/csv/upload', [CustomerCsvController::class, 'uploadStore'])
        ->name('party.customers.csv.upload.store');

    Route::get('/customers/csv/sample', [CustomerCsvController::class, 'downloadSample'])
        ->name('party.customers.csv.sample');

    Route::post('/customers/csv/import50', [CustomerCsvController::class, 'importFirst50'])
        ->name('party.customers.csv.import50');

    Route::post('/customers/csv/row/{key}', [CustomerCsvController::class, 'update'])
        ->name('party.customers.csv.update');
    Route::delete('/customers/csv/row/{key}', [CustomerCsvController::class, 'destroy'])
        ->name('party.customers.csv.destroy');
    Route::delete('/customers/csv/delete-all', [CustomerCsvController::class, 'destroyAll'])
        ->name('party.customers.csv.deleteAll');


/*
|--------------------------------------------------------------------------
| Employee (lists + create views + POST stores)
|--------------------------------------------------------------------------
*/
Route::prefix('employee')->name('employee.')->group(function () {
    Route::get('/',        [EmployeeController::class, 'index'])->name('index');
    Route::get('/create',  [EmployeeController::class, 'create'])->name('create');
    Route::post('/',       [EmployeeController::class, 'store'])->name('store');
    Route::get('/designations',         [EmployeeController::class, 'designationsIndex'])->name('designations');
    Route::get('/designations/create',  fn () => view('employee.designations.create'))->name('designations.create');
    Route::post('/designations',        [EmployeeController::class, 'designationStore'])->name('designations.store');
    Route::get('/departments',          [EmployeeController::class, 'departmentsIndex'])->name('departments');
    Route::get('/departments/create',   fn () => view('employee.departments.create'))->name('departments.create');
    Route::post('/departments',         [EmployeeController::class, 'departmentStore'])->name('departments.store');
});


    /*
    |--------------------------------------------------------------------------
    | Products (masters) — view-only
    |--------------------------------------------------------------------------
    */
    Route::prefix('products')->name('products.')->group(function () {
    // ===== Units =====
    Route::get('units',             [UnitController::class, 'index'])->name('units.index');
    Route::get('units/create',      [UnitController::class, 'create'])->name('units.create');
    Route::post('units',            [UnitController::class, 'store'])->name('units.store');
    Route::get('units/{unit}/edit', [UnitController::class, 'edit'])->name('units.edit');
    Route::put('units/{unit}',      [UnitController::class, 'update'])->name('units.update');
    Route::delete('units/{unit}',   [UnitController::class, 'destroy'])->name('units.destroy');

    // ===== Categories =====
    Route::get('categories',                 [CategoryController::class, 'index'])->name('categories.index');
    Route::get('categories/create',          [CategoryController::class, 'create'])->name('categories.create');
    Route::post('categories',                [CategoryController::class, 'store'])->name('categories.store');
    Route::get('categories/{category}/edit', [CategoryController::class, 'edit'])->name('categories.edit');
    Route::put('categories/{category}',      [CategoryController::class, 'update'])->name('categories.update');
    Route::delete('categories/{category}',   [CategoryController::class, 'destroy'])->name('categories.destroy');

    // ===== Bag Types =====
    Route::get('bag-types',          [BagTypeController::class,'index'])->name('bag-types.index');
    Route::get('bag-types/create',   [BagTypeController::class,'create'])->name('bag-types.create');
    Route::post('bag-types',         [BagTypeController::class,'store'])->name('bag-types.store');
    Route::get('bag-types/{bag}/edit',[BagTypeController::class,'edit'])->name('bag-types.edit');
    Route::put('bag-types/{bag}',    [BagTypeController::class,'update'])->name('bag-types.update');
    Route::delete('bag-types/{bag}', [BagTypeController::class,'destroy'])->name('bag-types.destroy');

    // ===== Warehouse Types =====
    Route::get('warehouse-types',       [WarehouseTypeController::class, 'index'])->name('warehouse-types.index');
    Route::get('warehouse-types/create', [WarehouseTypeController::class, 'create'])->name('warehouse-types.create');
    Route::post('warehouse-types',      [WarehouseTypeController::class, 'store'])->name('warehouse-types.store');
    Route::get('warehouse-types/{warehouseType}/edit', [WarehouseTypeController::class, 'edit'])->name('warehouse-types.edit');
    Route::put('warehouse-types/{warehouseType}', [WarehouseTypeController::class, 'update'])->name('warehouse-types.update');
    Route::delete('warehouse-types/{warehouseType}', [WarehouseTypeController::class, 'destroy'])->name('warehouse-types.destroy');



    // ===== Warehouses =====
    Route::get   ('warehouses',                 [WarehouseController::class, 'index'])->name('warehouses.index');
    Route::get   ('warehouses/create',          [WarehouseController::class, 'create'])->name('warehouses.create');
    Route::post  ('warehouses',                 [WarehouseController::class, 'store'])->name('warehouses.store');
    Route::get   ('warehouses/{warehouse}/edit',[WarehouseController::class, 'edit'])->name('warehouses.edit');
    Route::put   ('warehouses/{warehouse}',     [WarehouseController::class, 'update'])->name('warehouses.update');
    Route::delete('warehouses/{warehouse}',     [WarehouseController::class, 'destroy'])->name('warehouses.destroy');


    // ===== Dayars =====
    Route::get   ('dayars',               [DayarController::class, 'index'])->name('dayars.index');
    Route::get   ('dayars/create',        [DayarController::class, 'create'])->name('dayars.create');
    Route::post  ('dayars',               [DayarController::class, 'store'])->name('dayars.store');
    Route::get   ('dayars/{dayar}/edit',  [DayarController::class, 'edit'])->name('dayars.edit');
    Route::put   ('dayars/{dayar}',       [DayarController::class, 'update'])->name('dayars.update');
    Route::delete('dayars/{dayar}',       [DayarController::class, 'destroy'])->name('dayars.destroy');

    // ===== Mills =====
    Route::get   ('mills',               [MillController::class, 'index'])->name('mills.index');
    Route::get   ('mills/create',        [MillController::class, 'create'])->name('mills.create');
    Route::post  ('mills',               [MillController::class, 'store'])->name('mills.store');
    Route::get   ('mills/{mill}/edit',   [MillController::class, 'edit'])->name('mills.edit');
    Route::put   ('mills/{mill}',        [MillController::class, 'update'])->name('mills.update');
    Route::delete('mills/{mill}',        [MillController::class, 'destroy'])->name('mills.destroy');

    // ===== Areas =====
    Route::get   ('areas',              [AreaController::class, 'index'])->name('areas.index');
    Route::get   ('areas/create',       [AreaController::class, 'create'])->name('areas.create');
    Route::post  ('areas',              [AreaController::class, 'store'])->name('areas.store');
    Route::get   ('areas/{area}/edit',  [AreaController::class, 'edit'])->name('areas.edit');
    Route::put   ('areas/{area}',       [AreaController::class, 'update'])->name('areas.update');
    Route::delete('areas/{area}',       [AreaController::class, 'destroy'])->name('areas.destroy');

    // ===== Raw Materials =====
   Route::get('raw-materials',                 [RawMaterialController::class, 'index'])->name('raw-materials.index');
   Route::get('raw-materials/create',          [RawMaterialController::class, 'create'])->name('raw-materials.create');
   Route::post('raw-materials',                [RawMaterialController::class, 'store'])->name('raw-materials.store');
   Route::get('raw-materials/{product}/edit',  [RawMaterialController::class, 'edit'])->name('raw-materials.edit');
   Route::put('raw-materials/{product}',       [RawMaterialController::class, 'update'])->name('raw-materials.update');
   Route::delete('raw-materials/{product}',    [RawMaterialController::class, 'destroy'])->name('raw-materials.destroy');

    // ===== Finish Products =====
    Route::get('finish-products',        [FinishProductController::class, 'index'])->name('finish-products.index');
    Route::get('finish-products/create', [FinishProductController::class, 'create'])->name('finish-products.create');
    Route::post('finish-products',       [FinishProductController::class, 'store'])->name('finish-products.store');
    Route::get   ('finish-products/{product}/edit', [FinishProductController::class, 'edit'])->name('finish-products.edit');
    Route::put   ('finish-products/{product}',      [FinishProductController::class, 'update'])->name('finish-products.update');
    Route::delete('finish-products/{product}',      [FinishProductController::class, 'destroy'])->name('finish-products.destroy');

    // ===== Finish Bags =====
    Route::get('finish-bags',                [FinishBagController::class, 'index'])->name('finish-bags.index');
    Route::get('finish-bags/create',         [FinishBagController::class, 'create'])->name('finish-bags.create');
    Route::post('finish-bags',               [FinishBagController::class, 'store'])->name('finish-bags.store');
    Route::get('finish-bags/{bag}/edit',     [FinishBagController::class, 'edit'])->name('finish-bags.edit');
    Route::put('finish-bags/{bag}',          [FinishBagController::class, 'update'])->name('finish-bags.update');
    Route::delete('finish-bags/{bag}',       [FinishBagController::class, 'destroy'])->name('finish-bags.destroy');

});

    /*
    |--------------------------------------------------------------------------
    | Purchase (4 buckets) — view-only with prefixes
    |--------------------------------------------------------------------------
    */
    Route::prefix('purchase')->name('purchase.')->group(function () {

    // RAW MATERIAL
    Route::prefix('raw-material')->name('raw_material.')->group(function () {
        Route::get('/',[RawMaterialPurchaseController::class, 'index'])->name('index');
        Route::get('/create',[RawMaterialPurchaseController::class, 'create'])->name('create');
        Route::post('/',[RawMaterialPurchaseController::class, 'store'])->name('store');
        Route::get('/{raw_material}/edit', [RawMaterialPurchaseController::class, 'edit'])->name('edit');
        Route::put('/{raw_material}',      [RawMaterialPurchaseController::class, 'update'])->name('update');
        Route::delete('/{raw_material}',   [RawMaterialPurchaseController::class, 'destroy'])->name('destroy');
        Route::get('/{raw_material}/print',[RawMaterialPurchaseController::class, 'print'])->name('print');
    });

    // FINISH PRODUCT
    Route::prefix('finish-product')->name('finish_product.')->group(function () {
        Route::get('/',                        [FinishProductPurchaseController::class, 'index'])->name('index');
        Route::get('/create',                  [FinishProductPurchaseController::class, 'create'])->name('create');
        Route::post('/',                       [FinishProductPurchaseController::class, 'store'])->name('store');
        Route::get('/{finish_product}/edit',   [FinishProductPurchaseController::class, 'edit'])->name('edit');
        Route::put('/{finish_product}',        [FinishProductPurchaseController::class, 'update'])->name('update');
        Route::delete('/{finish_product}',     [FinishProductPurchaseController::class, 'destroy'])->name('destroy');
        Route::get('/{finish_product}/print',  [FinishProductPurchaseController::class, 'print'])->name('print');
    });

    // FINISH BAG
    Route::prefix('finish-bag')->name('finish_bag.')->group(function () {
        Route::get('/',                   [FinishBagPurchaseController::class, 'index'])->name('index');
        Route::get('/create',             [FinishBagPurchaseController::class, 'create'])->name('create');
        Route::post('/',                  [FinishBagPurchaseController::class, 'store'])->name('store');
        Route::get('/{finish_bag}/edit',  [FinishBagPurchaseController::class, 'edit'])->name('edit');
        Route::put('/{finish_bag}',       [FinishBagPurchaseController::class, 'update'])->name('update');
        Route::delete('/{finish_bag}',    [FinishBagPurchaseController::class, 'destroy'])->name('destroy');
        Route::get('/{finish_bag}/print', [FinishBagPurchaseController::class, 'print'])->name('print');
    });

    // RAW BAG
    Route::prefix('raw-bag')->name('raw_bag.')->group(function () {
        Route::get('/',                [RawBagPurchaseController::class, 'index'])->name('index');
        Route::get('/create',          [RawBagPurchaseController::class, 'create'])->name('create');
        Route::post('/',               [RawBagPurchaseController::class, 'store'])->name('store');
        Route::get('/{raw_bag}/edit',  [RawBagPurchaseController::class, 'edit'])->name('edit');
        Route::put('/{raw_bag}',       [RawBagPurchaseController::class, 'update'])->name('update');
        Route::delete('/{raw_bag}',    [RawBagPurchaseController::class, 'destroy'])->name('destroy');
        Route::get('/{raw_bag}/print', [RawBagPurchaseController::class, 'print'])->name('print');
    });
});

    /*
    |--------------------------------------------------------------------------
    | Bag Exchange
    |--------------------------------------------------------------------------
    */
    Route::prefix('bag-exchange')->name('bag_exchange.')->group(function () {
    Route::get('/',                 [BagExchangeController::class, 'index'])->name('index');
    Route::get('/create',           [BagExchangeController::class, 'create'])->name('create');
    Route::post('/',                [BagExchangeController::class, 'store'])->name('store');
    Route::get('/{bagExchange}',    [BagExchangeController::class, 'show'])->name('show');
    Route::get('/{bagExchange}/edit',[BagExchangeController::class,'edit'])->name('edit');
    Route::put('/{bagExchange}',    [BagExchangeController::class, 'update'])->name('update');
    Route::delete('/{bagExchange}', [BagExchangeController::class, 'destroy'])->name('destroy');
});


/*
|--------------------------------------------------------------------------
| Stock Transfer Routes
|--------------------------------------------------------------------------
*/

// Raw Material Transfer Routes
    Route::prefix('transfer/raw-material')->name('stock-transfers.')->group(function () {
    Route::get('/',[RawMaterialTransferController::class, 'index'])->name('index');
    Route::get('/create',[RawMaterialTransferController::class, 'create'])->name('create');
    Route::post('/',[RawMaterialTransferController::class, 'store'])->name('store');
    Route::get('/{transfer}/edit',[RawMaterialTransferController::class, 'edit'])->name('edit');
    Route::put('/{transfer}',[RawMaterialTransferController::class, 'update'])->name('update');
    Route::delete('/{transfer}',[RawMaterialTransferController::class, 'destroy'])->name('destroy');
    });

// Finish Product Transfer Routes
    Route::prefix('transfer/finish-product')->name('transfer.finish-product.')->group(function () {
    Route::get('/',[FinishProductTransferController::class, 'index'])->name('index');
    Route::get('/create',[FinishProductTransferController::class, 'create'])->name('create');
    Route::post('/store',[FinishProductTransferController::class, 'store'])->name('store');
    Route::get('/{id}/edit',[FinishProductTransferController::class, 'edit'])->name('edit');
    Route::put('/{id}',[FinishProductTransferController::class, 'update'])->name('update');
    Route::delete('/{id}',[FinishProductTransferController::class, 'destroy'])->name('destroy');
});

/*
|--------------------------------------------------------------------------
| Adjustment Routes
|--------------------------------------------------------------------------
*/

Route::prefix('adjustment')->name('adjustment.')->group(function () {

    // Raw Product
    Route::prefix('raw-product')->name('raw_product.')->group(function () {
        Route::get('/',          [RawProductAdjustmentController::class, 'index'])->name('index');
        Route::get('/create',    [RawProductAdjustmentController::class, 'create'])->name('create');
        Route::post('/',         [RawProductAdjustmentController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [RawProductAdjustmentController::class, 'edit'])->name('edit');
        Route::put('/{id}',      [RawProductAdjustmentController::class, 'update'])->name('update');
        Route::delete('/{id}',   [RawProductAdjustmentController::class, 'destroy'])->name('destroy');
    });

    // Finish Product
    Route::prefix('finish-product')->name('finish_product.')->group(function () {
        Route::get('/',          [FinishProductAdjustmentController::class, 'index'])->name('index');
        Route::get('/create',    [FinishProductAdjustmentController::class, 'create'])->name('create');
        Route::post('/',         [FinishProductAdjustmentController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [FinishProductAdjustmentController::class, 'edit'])->name('edit');
        Route::put('/{id}',      [FinishProductAdjustmentController::class, 'update'])->name('update');
        Route::delete('/{id}',   [FinishProductAdjustmentController::class, 'destroy'])->name('destroy');
    });

    // Finish Bag
    Route::prefix('finish-bag')->name('finish_bag.')->group(function () {
        Route::get('/',          [FinishBagAdjustmentController::class, 'index'])->name('index');
        Route::get('/create',    [FinishBagAdjustmentController::class, 'create'])->name('create');
        Route::post('/',         [FinishBagAdjustmentController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [FinishBagAdjustmentController::class, 'edit'])->name('edit');
        Route::put('/{id}',      [FinishBagAdjustmentController::class, 'update'])->name('update');
        Route::delete('/{id}',   [FinishBagAdjustmentController::class, 'destroy'])->name('destroy');
    });

    // Raw Bag
    Route::prefix('raw-bag')->name('raw_bag.')->group(function () {
        Route::get('/',          [RawBagAdjustmentController::class, 'index'])->name('index');
        Route::get('/create',    [RawBagAdjustmentController::class, 'create'])->name('create');
        Route::post('/',         [RawBagAdjustmentController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [RawBagAdjustmentController::class, 'edit'])->name('edit');
        Route::put('/{id}',      [RawBagAdjustmentController::class, 'update'])->name('update');
        Route::delete('/{id}',   [RawBagAdjustmentController::class, 'destroy'])->name('destroy');
    });

    // Raw Bag Opening
    Route::prefix('raw-bag-opening')->name('raw_bag_opening.')->group(function () {
        Route::get('/',          [RawBagOpeningController::class, 'index'])->name('index');
        Route::get('/create',    [RawBagOpeningController::class, 'create'])->name('create');
        Route::post('/',         [RawBagOpeningController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [RawBagOpeningController::class, 'edit'])->name('edit');
        Route::put('/{id}',      [RawBagOpeningController::class, 'update'])->name('update');
        Route::delete('/{id}',   [RawBagOpeningController::class, 'destroy'])->name('destroy');
    });

    // ✅ GS Adjustment
    Route::prefix('gs')->name('new_gs.')->group(function () {
        Route::get('/',          [GSAdjustmentController::class, 'index'])->name('index');
        Route::get('/create',    [GSAdjustmentController::class, 'create'])->name('create');
        Route::post('/',         [GSAdjustmentController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [GSAdjustmentController::class, 'edit'])->name('edit');
        Route::put('/{id}',      [GSAdjustmentController::class, 'update'])->name('update');
        Route::delete('/{id}',   [GSAdjustmentController::class, 'destroy'])->name('destroy');
    });

});


    /*
    |--------------------------------------------------------------------------
    | Order — view-only
    |--------------------------------------------------------------------------
    */
    Route::prefix('order')->name('order.')->group(function () {
    Route::get('/',           [OrderController::class, 'index'])->name('index');
    Route::get('/create',     [OrderController::class, 'create'])->name('create');
    Route::post('/',          [OrderController::class, 'store'])->name('store');
    Route::get('/{id}/edit',  [OrderController::class, 'edit'])->name('edit');
    Route::put('/{id}',       [OrderController::class, 'update'])->name('update');
    Route::delete('/{id}',    [OrderController::class, 'destroy'])->name('destroy');
});

    /*
    |--------------------------------------------------------------------------
    | Order Delivery — view-only
    |--------------------------------------------------------------------------
    */
    Route::view('/order-delivery',        'order_delivery.index')->name('order_delivery.index');
    Route::view('/order-delivery/create', 'order_delivery.create')->name('order_delivery.create');

   /*
|--------------------------------------------------------------------------
| Sales
|--------------------------------------------------------------------------
*/
Route::prefix('sales')->name('sales.')->group(function () {
    Route::get('/',            [SaleController::class, 'index'])->name('index');
    Route::get('/create',      [SaleController::class, 'create'])->name('create');
    Route::post('/',           [SaleController::class, 'store'])->name('store');
    Route::get('/{sale}',      [SaleController::class, 'show'])->name('show');
    Route::get('/{sale}/edit', [SaleController::class, 'edit'])->name('edit');
    Route::put('/{sale}',      [SaleController::class, 'update'])->name('update');
    Route::delete('/{sale}',   [SaleController::class, 'destroy'])->name('destroy');
});

    /*
|----------------------------------------------------------------------
| Sales Delivery
|----------------------------------------------------------------------
*/
Route::prefix('sales-delivery')->name('sales_delivery.')->group(function () {
    Route::get('/',                 [SalesDeliveryController::class, 'index'])->name('index');
    Route::get('/create',           [SalesDeliveryController::class, 'create'])->name('create');
    Route::post('/',                [SalesDeliveryController::class, 'store'])->name('store');
    Route::get('/{salesDelivery}',  [SalesDeliveryController::class, 'show'])->name('show');
    Route::get('/{salesDelivery}/edit', [SalesDeliveryController::class, 'edit'])->name('edit');
    Route::put('/{salesDelivery}',  [SalesDeliveryController::class, 'update'])->name('update');
    Route::delete('/{salesDelivery}',[SalesDeliveryController::class, 'destroy'])->name('destroy');

    // (Optional) helper endpoint to populate "Sale Id" by company
    Route::get('/sales-by-company/{company}', [SalesDeliveryController::class, 'salesByCompany'])
        ->name('sales_by_company');
});

    /*
    |--------------------------------------------------------------------------
    | Issue Raw Material — view-only
    |--------------------------------------------------------------------------
    */
    Route::view('/issue-raw-material',        'issue_rm.index')->name('issue_rm.index');
    Route::view('/issue-raw-material/create', 'issue_rm.create')->name('issue_rm.create');

    /*
    |--------------------------------------------------------------------------
    | Production — view-only
    |--------------------------------------------------------------------------
    */
    Route::view('/production',        'production.index')->name('production.index');
    Route::view('/production/create', 'production.create')->name('production.create');

    /*
    |--------------------------------------------------------------------------
    | Return (5 buckets) — view-only
    |--------------------------------------------------------------------------
    */
    Route::prefix('return')->name('return.')->group(function () {
        Route::prefix('raw-purchase')->name('raw_purchase.')->group(function () {
            Route::view('/',       'return.raw_purchase.index')->name('index');
            Route::view('/create', 'return.raw_purchase.create')->name('create');
        });
        Route::prefix('finish-purchase')->name('finish_purchase.')->group(function () {
            Route::view('/',       'return.finish_purchase.index')->name('index');
            Route::view('/create', 'return.finish_purchase.create')->name('create');
        });
        Route::prefix('sales')->name('sales.')->group(function () {
            Route::view('/',       'return.sales.index')->name('index');
            Route::view('/create', 'return.sales.create')->name('create');
        });
        Route::prefix('order')->name('order.')->group(function () {
            Route::view('/',       'return.order.index')->name('index');
            Route::view('/create', 'return.order.create')->name('create');
        });
        Route::prefix('bag')->name('bag.')->group(function () {
            Route::view('/',       'return.bag.index')->name('index');
            Route::view('/create', 'return.bag.create')->name('create');
        });
    });

    /*
    |--------------------------------------------------------------------------
    | Labour — view-only
    |--------------------------------------------------------------------------
    */
    Route::view('/labour',        'labour.index')->name('labour.index');
    Route::view('/labour/create', 'labour.create')->name('labour.create');

    /*
    |--------------------------------------------------------------------------
    | Payment & Due — view-only
    |--------------------------------------------------------------------------
    */
    Route::prefix('payment')->name('payment.')->group(function () {
        Route::view('/collect-due',     'payment.collect_due')->name('collect_due');
        Route::view('/collection-list', 'payment.collection_list')->name('collection_list');

        Route::prefix('supplier')->name('supplier.')->group(function () {
            Route::view('/',       'payment.supplier.index')->name('index');
            Route::view('/create', 'payment.supplier.create')->name('create');
        });
    });

    /*
    |--------------------------------------------------------------------------
    | Reports — view-only
    |--------------------------------------------------------------------------
    */
    Route::prefix('reports')->name('reports.')->group(function () {
        // Raw Material
        Route::view('/raw-material/stock-in-hand', 'reports.raw_material.stock_in_hand')->name('raw_material.stock_in_hand');
        Route::view('/raw-material/ledger',        'reports.raw_material.ledger')->name('raw_material.ledger');
        Route::view('/raw-material/mal-khotiyan',  'reports.raw_material.mal_khotiyan')->name('raw_material.mal_khotiyan');

        // Finish Product
        Route::view('/finish-product/production-stock', 'reports.finish_product.production_stock')->name('finish_product.production_stock');
        Route::view('/finish-product/production-ledger','reports.finish_product.production_ledger')->name('finish_product.production_ledger');
        Route::view('/finish-product/purchase-stock',   'reports.finish_product.purchase_stock')->name('finish_product.purchase_stock');
        Route::view('/finish-product/purchase-ledger',  'reports.finish_product.purchase_ledger')->name('finish_product.purchase_ledger');

        // Finish Bag
        Route::view('/finish-bag/stock-in-hand', 'reports.finish_bag.stock_in_hand')->name('finish_bag.stock_in_hand');
        Route::view('/finish-bag/ledger',        'reports.finish_bag.ledger')->name('finish_bag.ledger');

        // Raw Bag
        Route::view('/raw-bag/supplier-in-hand',   'reports.raw_bag.supplier_in_hand')->name('raw_bag.supplier_in_hand');
        Route::view('/raw-bag/supplier-bag-ledger','reports.raw_bag.supplier_bag_ledger')->name('raw_bag.supplier_bag_ledger');
        Route::view('/raw-bag/empty-bag-stock',    'reports.raw_bag.empty_bag_stock')->name('raw_bag.empty_bag_stock');
        Route::view('/raw-bag/ledger',             'reports.raw_bag.ledger')->name('raw_bag.ledger');

        // Sales
        Route::view('/sales/finish-product',     'reports.sales.finish_product')->name('sales.finish_product');
        Route::view('/sales/production-product', 'reports.sales.production_product')->name('sales.production_product');
        Route::view('/sales/monthly',            'reports.sales.monthly_sale')->name('sales.monthly_sale');

        // Order
        Route::view('/order/finish-product',     'reports.order.finish_product')->name('order.finish_product');
        Route::view('/order/production-product', 'reports.order.production_product')->name('order.production_product');
        Route::view('/order/monthly',            'reports.order.monthly_order')->name('order.monthly_order');

        // Purchase
        Route::view('/purchase/raw-product',     'reports.purchase.raw_product')->name('purchase.raw_product');
        Route::view('/purchase/finish-product',  'reports.purchase.finish_product')->name('purchase.finish_product');
        Route::view('/purchase/finish-bag',      'reports.purchase.finish_bag')->name('purchase.finish_bag');
        Route::view('/purchase/raw-bag',         'reports.purchase.raw_bag')->name('purchase.raw_bag');

        // Damage
        Route::view('/damage/raw-product',       'reports.damage.raw_product')->name('damage.raw_product');
        Route::view('/damage/finish-product',    'reports.damage.finish_product')->name('damage.finish_product');
        Route::view('/damage/raw-bag',           'reports.damage.raw_bag')->name('damage.raw_bag');
        Route::view('/damage/finish-bag',        'reports.damage.finish_bag')->name('damage.finish_bag');

        // Singles
        Route::view('/customer-ledger',          'reports.customer_ledger')->name('customer_ledger');
        Route::view('/supplier-ledger',          'reports.supplier_ledger')->name('supplier_ledger');
        Route::view('/supplier-report',          'reports.supplier_report')->name('supplier_report');
        Route::view('/customer-performance',     'reports.customer_performance')->name('customer_performance');
        Route::view('/executive-performance',    'reports.executive_performance')->name('executive_performance');
        Route::view('/production-cost',          'reports.production_cost')->name('production_cost');
        Route::view('/labour-cost',              'reports.labour_cost')->name('labour_cost');
        Route::view('/order-return',             'reports.order_return')->name('order_return');
        Route::view('/sale-return',              'reports.sale_return')->name('sale_return');
        Route::view('/dayar',                    'reports.dayar')->name('dayar');
        Route::view('/mill',                     'reports.mill')->name('mill');
        Route::view('/daily',                    'reports.daily')->name('daily');
        Route::view('/day-book',                 'reports.day_book')->name('day_book');
        Route::view('/cash-book',                'reports.cash_book')->name('cash_book');
    });

    /** ---------------- Account ---------------- */
    Route::view('/account/mapping', 'account.mapping')->name('account.mapping');
    Route::view('/account/summary', 'account.summary')->name('account.summary');
});

/*
|--------------------------------------------------------------------------
| Optional auth scaffolding routes (Breeze/Jetstream/ui)
|--------------------------------------------------------------------------
*/
if (file_exists(__DIR__ . '/auth.php')) {
    require __DIR__ . '/auth.php';
}

/** System refresh (clear caches) */
Route::post('/system/refresh', function () {
    \Artisan::call('optimize:clear');
    \Artisan::call('config:clear');
    \Artisan::call('route:clear');
    \Artisan::call('view:clear');
    \Artisan::call('cache:clear');
    return response()->noContent();
})->name('system.refresh')->middleware('auth');
