{{-- resources/views/users/show.blade.php --}}
@extends('layouts.app')
@section('title','User Details')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111;--primary:#1d4ed8}
  .wrap{max-width:900px;margin:0 auto}
  .panel{background:var(--card);border:1px solid var(--border);border-radius:10px}
  .panel-h{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
  .panel-b{padding:16px}
  .title{font-size:18px;font-weight:800}
  .muted{color:var(--muted)}
  .grid{display:grid;grid-template-columns:1fr 1fr;gap:14px}
  @media (max-width:768px){ .grid{grid-template-columns:1fr} }
  .item{background:#fafafa;border:1px solid var(--border);border-radius:8px;padding:12px}
  .item h6{margin:0 0 4px;font-size:12px;letter-spacing:.3px;color:#374151;text-transform:uppercase}
  .item .val{font-weight:700;color:var(--text)}
  .badge{display:inline-block;border-radius:999px;font-size:12px;padding:4px 8px;background:#eef2ff;color:#1d4ed8}
  .badge.gray{background:#f3f4f6;color:#374151}
  .actions{display:flex;gap:8px;justify-content:flex-end;margin-top:16px}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:var(--primary);color:#fff}
  .btn-ghost{background:#f3f4f6}
</style>
@endpush

@section('content')
@php
  $fmt = fn($dt) => $dt ? \Illuminate\Support\Carbon::parse($dt)->format('Y-m-d H:i') : '—';
  $roles = method_exists($user,'roles') ? $user->roles->pluck('name')->toArray() : [];
@endphp

<div class="wrap">
  <div class="panel">
    <div class="panel-h">
      <div class="title"><i class="fa-regular fa-id-card"></i> User Details</div>
      <div class="muted">ID: #{{ $user->id }}</div>
    </div>

    <div class="panel-b">
      <div class="grid">
        <div class="item">
          <h6>Name</h6>
          <div class="val">{{ $user->name }}</div>
        </div>
        <div class="item">
          <h6>Email</h6>
          <div class="val">{{ $user->email }}</div>
        </div>
        <div class="item">
          <h6>Status</h6>
          <div class="val">
            @if((bool)$user->status) <span class="badge">Active</span>
            @else <span class="badge gray">Inactive</span>
            @endif
          </div>
        </div>
        <div class="item">
          <h6>Company ID</h6>
          <div class="val">{{ $user->company_id ?? '—' }}</div>
        </div>
        <div class="item">
          <h6>Branch ID</h6>
          <div class="val">{{ $user->branch_id ?? '—' }}</div>
        </div>
        <div class="item">
          <h6>Employee Full ID</h6>
          <div class="val">{{ $user->employee_full_id ?? '—' }}</div>
        </div>
        <div class="item">
          <h6>Created At</h6>
          <div class="val">{{ $fmt($user->created_at) }}</div>
        </div>
        <div class="item">
          <h6>Updated At</h6>
          <div class="val">{{ $fmt($user->updated_at) }}</div>
        </div>
        <div class="item" style="grid-column:1/-1">
          <h6>Roles</h6>
          <div class="val">
            @if(count($roles))
              @foreach($roles as $r)
                <span class="badge" style="margin-right:6px">{{ $r }}</span>
              @endforeach
            @else
              <span class="badge gray">—</span>
            @endif
          </div>
        </div>
      </div>

      <div class="actions">
        @if(Route::has('users.index'))
          <a class="btn btn-ghost" href="{{ route('users.index') }}"><i class="fa-solid fa-circle-arrow-left"></i> Back</a>
        @endif
        @if(Route::has('users.edit'))
          <a class="btn btn-primary" href="{{ route('users.edit',$user) }}"><i class="fa-regular fa-pen-to-square"></i> Edit User</a>
        @endif
      </div>
    </div>
  </div>
</div>
@endsection
