@extends('layouts.app')
@section('title','User List')

@push('styles')
<style>
  /* ----- Outer rounded frame ----- */
  .ul-frame{
    border:1px solid #dfe5ec;
    border-radius:12px;
    padding:12px 12px 16px;
    background:#fff;
  }

  /* ========== TOP TITLE BAR (Add User ডান প্রান্তে) ========== */
  .titlebar{
    display:flex; align-items:center; justify-content:space-between;
    margin:2px 0 14px 0;              /* ← টাইটেলের নিচে একটু বেশি গ্যাপ */
  }
  .titlebar .ttl{
    display:flex; align-items:center; gap:10px; font-size:22px; font-weight:700; color:#2d3a4b;
  }
  .btn-add{
    height:34px; border-radius:3px; border:1px solid #5297ce;
    background:#5aa0d8; color:#fff; padding:.45rem .85rem; display:inline-flex; gap:6px; align-items:center;
  }
  .btn-add i{font-size:13px}

  /* ========== FILTER ROW (Search ডান প্রান্তে) ========== */
  .ul-bar{ display:flex; }
  .ul-bar form.filters{
    flex:1 1 auto; display:flex; align-items:center; gap:12px; width:100%;
    margin:0 0 12px 0;
  }
  .f-input{
    height:34px; padding:.375rem .5rem; font-size:14px;
    border:1px solid #d9dee3; border-radius:3px; box-shadow: inset 0 1px 1px rgba(0,0,0,.02);
    background:#fff; color:#111827; outline:0;
  }
  .f-name  { width:240px; }
  .f-status{ flex:1 1 auto; }
  .search-group{ margin-left:auto; display:flex; align-items:center; gap:8px; }
  .btn-legacy{
    height:34px; border-radius:3px; border:1px solid transparent;
    font-size:14px; line-height:1; display:inline-flex; align-items:center; gap:6px;
    padding:.45rem .85rem; cursor:pointer;
  }
  .btn-search{ background:#69a95e; border-color:#5e9954; color:#fff; }
  .btn-search i{ font-size:13px; }
  .btn-reset{ width:34px; justify-content:center; padding:0;
              background:#e9eef3; border:1px solid #d9e2ea; color:#3f4a59; }

  /* ========== TABLE: header/bg/borders ========== */
  .ul-table{
    width:100%;
    background:#fff;
    border:1px solid #dfe5ec;
    border-radius:3px;
    border-collapse:separate;
    border-spacing:0;
  }
  .ul-table thead th{
    background:#f7f9fc; color:#5b6776; font-weight:600; font-size:14px;
    border-bottom:1px solid #dfe5ec; padding:.6rem .75rem;
    text-align:center;
    border-right:1px solid #dfe5ec;
  }
  .ul-table thead th:last-child{ border-right:none; }

  .ul-table td{
    font-size:14px; padding:.6rem .75rem;
    border-top:1px solid #a1a5aa;
    text-align:center;
    border-right:1px solid #e9edf3;
    vertical-align:middle;
  }
  .ul-table td:last-child{ border-right:none; }

  .col-sl{ width:68px; }
  .col-action{ width:160px; }

  /* ========== ACTION ICONS ========== */
  .act{
    width:28px; height:28px; display:inline-flex; align-items:center; justify-content:center;
    border-radius:3px; color:#fff; margin-right:6px; border:0;
  }
  .act-key { background:#3c424a; }
  .act-edit{ background:#3da35a; }
  .act-del { background:#d9534f; }
  .act i{ font-size:13px; }
</style>
@endpush

@section('content')
<div class="container-fluid ul-frame"><!-- ← rounded frame wrapper -->

  {{-- ===== Title + Add User ===== --}}
  <div class="titlebar">
    <div class="ttl"><i class="fa fa-bars"></i> User List</div>
    <a href="{{ Route::has('users.create') ? route('users.create') : '#' }}" class="btn-add">
      <i class="fa fa-plus"></i> Add User
    </a>
  </div>

  {{-- ===== Filters ===== --}}
  <div class="ul-bar">
    <form method="GET" action="{{ route('users.index') }}" class="filters">
      <input type="text" name="name" value="{{ request('name') }}" class="f-input f-name" placeholder="Name">
      <select name="status" class="f-input f-status">
        <option value="">-Select Status-</option>
        <option value="active"   @selected(request('status')=='active')>Active</option>
        <option value="inactive" @selected(request('status')=='inactive')>Inactive</option>
      </select>

      <div class="search-group">
        <button type="submit" class="btn-legacy btn-search">
          <i class="fa fa-search"></i> Search
        </button>
        <a href="{{ route('users.index') }}" class="btn-legacy btn-reset" title="Refresh">
          <i class="fa fa-refresh"></i>
        </a>
      </div>
    </form>
  </div>

  {{-- ===== Table ===== --}}
  <div class="table-responsive">
    <table class="table ul-table mb-0">
      <thead>
        <tr>
          <th class="col-sl">Sl</th>
          <th>Name</th>
          <th>Email</th>
          <th>Mobile</th>
          <th>Created At</th>
          <th class="col-action">Action</th>
        </tr>
      </thead>
      <tbody>
      @forelse($users as $i => $user)
        <tr>
          <td>{{ ($users->firstItem() ?? 1) + $i }}</td>
          <td>{{ $user->name }}</td>
          <td>{{ $user->email }}</td>
          <td>{{ $user->mobile ?? '-' }}</td>
          <td>{{ optional($user->created_at)->format('F d, Y h:i A') }}</td>
          <td>
            @php
              $permHref = '#';
              if (Route::has('users.permissions'))    $permHref = route('users.permissions',$user->id);
              elseif (Route::has('permissions.index')) $permHref = route('permissions.index',['user'=>$user->id]);
            @endphp
            <a href="{{ $permHref }}" class="act act-key"  title="Permissions"><i class="fa fa-key"></i></a>
            @if (Route::has('users.edit'))
              <a href="{{ route('users.edit',$user->id) }}" class="act act-edit" title="Edit"><i class="fa fa-external-link"></i></a>
            @endif
            @if (Route::has('users.destroy'))
              <form action="{{ route('users.destroy',$user->id) }}" method="POST" style="display:inline">
                @csrf @method('DELETE')
                <button type="submit" class="act act-del" title="Delete"
                        onclick="return confirm('Delete this user?');">
                  <i class="fa fa-trash"></i>
                </button>
              </form>
            @endif
          </td>
        </tr>
      @empty
        <tr><td colspan="6" class="text-center text-muted py-4">No users found.</td></tr>
      @endforelse
      </tbody>
    </table>
  </div>

  @if(method_exists($users,'links'))
    <div class="mt-3">{{ $users->appends(request()->query())->links() }}</div>
  @endif
</div>
@endsection
