@extends('layouts.app')
@section('title', 'Edit User')

@push('styles')
<style>
  /* --- শুধুমাত্র এই পেজের জন্য লাইটওয়েট স্টাইল --- */
  .settings-card{max-width:720px;margin:20px auto;background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 10px 30px rgba(0,0,0,.06)}
  .settings-card .head{padding:18px 20px 8px}
  .settings-card .head h1{margin:0;font-weight:800;font-size:22px;color:#111827}
  .settings-card form{padding:0 20px 18px}

  .form-group{margin-bottom:14px}
  .label{display:block;margin-bottom:6px;font-weight:700;color:#374151}
  .input{width:100%;padding:10px 12px;border:1px solid #d1d5db;border-radius:8px;background:#fff;color:#111}
  .input:focus{outline:none;border-color:#2563eb;box-shadow:0 0 0 3px rgba(37,99,235,.15)}

  .form-row{display:flex;gap:16px;flex-wrap:wrap}
  .form-col{flex:1 1 260px}

  .help{font-size:12px;color:#6b7280;margin-top:6px}
  .error{font-size:12px;color:#dc2626;margin-top:6px}

  .alert{border-radius:8px;padding:10px 12px;margin:0 20px 12px}
  .alert-success{background:#ecfdf5;color:#065f46;border:1px solid #a7f3d0}
  .alert-danger{background:#fef2f2;color:#991b1b;border:1px solid #fecaca}

  .actions{display:flex;gap:10px;margin-top:6px}
  .btn{cursor:pointer;border:0;border-radius:8px;padding:10px 14px;font-weight:700}
  .btn-primary{background:#2563eb;color:#fff}
  .btn-primary:hover{background:#1d4ed8}
  .btn-secondary{background:#eef2f7;color:#111}
  .btn-secondary:hover{background:#e5e7eb}
</style>
@endpush

@section('content')

  @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
  @endif

  @if ($errors->any())
    <div class="alert alert-danger">
      <strong>There were some problems with your input.</strong>
    </div>
  @endif

  <div class="settings-card">
    <div class="head">
      <h1>Edit User</h1>
    </div>

    <form method="POST" action="{{ route('users.update', $user) }}">
      @csrf
      @method('PUT')

      {{-- Name --}}
      <div class="form-group">
        <label for="name" class="label">Name</label>
        <input id="name" name="name" type="text"
               class="input @error('name') is-invalid @enderror"
               value="{{ old('name', $user->name) }}" required>
        @error('name') <div class="error">{{ $message }}</div> @enderror
      </div>

      {{-- Email --}}
      <div class="form-group">
        <label for="email" class="label">Email</label>
        <input id="email" name="email" type="email"
               class="input @error('email') is-invalid @enderror"
               value="{{ old('email', $user->email) }}" required>
        @error('email') <div class="error">{{ $message }}</div> @enderror
      </div>

      {{-- Passwords (two columns) --}}
      <div class="form-row">
        <div class="form-group form-col">
          <label for="password" class="label">New Password</label>
          <input id="password" name="password" type="password" class="input" placeholder="Leave blank to keep current">
          <div class="help">Keep empty if you don't want to change password.</div>
        </div>

        <div class="form-group form-col">
          <label for="password_confirmation" class="label">Confirm Password</label>
          <input id="password_confirmation" name="password_confirmation" type="password" class="input">
        </div>
      </div>
      @error('password') <div class="error">{{ $message }}</div> @enderror

      <div class="actions">
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ url()->previous() }}" class="btn btn-secondary">Cancel</a>
      </div>
    </form>
  </div>
@endsection

