@extends('layouts.app')
@section('title','Add New User')

@push('styles')
<style>
  /* ===== frame ===== */
  .ux-card{
    background:#fff;border:1px solid #dfe5ec;border-radius:3px;
    margin:16px auto;max-width:1250px; /* wide like your ref */
  }
  .ux-card-hd{
    display:flex;align-items:center;justify-content:space-between;
    padding:10px 16px;border-bottom:1px solid #e6ecf3;
    background:linear-gradient(#fbfcfe,#f3f6fb);
  }
  .ux-title{font-weight:600;color:#2f3949}
  .ux-title i{margin-right:6px}

  .ux-link{color:#3178c6;font-weight:600;text-decoration:none}
  .ux-link i{margin-right:6px}
  .ux-link:hover{color:#225e9a;text-decoration:underline}

  /* ===== body / rows like a form table ===== */
  .ux-body{padding:24px 18px}
  .ux-row{display:flex;align-items:center;margin-bottom:22px}
  .ux-lbl{
    width:250px; /* keeps the left labels fixed like the ref */
    color:#273140;font-weight:600
  }
  .ux-lbl .req{color:#b44b2b;font-weight:700}
  .ux-ctl{
    flex:1;max-width:980px;position:relative
  }

  /* inputs exactly like the screenshot */
  .ux-input{
    height:36px;width:100%;border:1px solid #cdd9e8;border-radius:2px;
    padding:6px 12px;font-size:14px;box-shadow:inset 0 1px 1px rgba(0,0,0,.03)
  }

  /* the small cyan circular icon buttons on the right */
  .ux-addon{
    position:absolute;top:3px;right:3px;height:30px;width:38px;
    display:flex;align-items:center;justify-content:center;border-radius:4px;
    background:#eaf7f6;border:1px solid #cee8e5
  }
  .ux-addon .cy{
    display:inline-flex;align-items:center;justify-content:center;
    height:22px;width:22px;border-radius:50%;
    background:#1fb6a6;color:#fff;font-size:12px
  }
  .ux-eye{
    margin-left:6px;background:#f3f6fb;border:1px solid #dfe5ec;width:32px
  }
  .ux-eye i{color:#495468}

  /* footer buttons */
  .ux-actions{display:flex;justify-content:flex-end;gap:8px;margin-top:10px}
  .btn-close{
    background:#d35a4a;border-color:#c65346;color:#fff
  }
  .btn-save{
    background:#2d80c8;border-color:#2a77bb;color:#fff
  }

  /* compact buttons to match size */
  .btn-slim{padding:6px 14px;border-radius:2px}
  .btn-slim i{margin-right:6px}
</style>
@endpush

@section('content')
<div class="ux-card">

  {{-- Header --}}
  <div class="ux-card-hd">
    <div class="ux-title">
      <i class="fa fa-plus"></i> Add New User
    </div>
    <a href="{{ route('users.index') }}" class="ux-link">
      <i class="fa fa-list-alt"></i> User List
    </a>
  </div>

  {{-- Body --}}
  <div class="ux-body">
    <form action="{{ route('users.store') }}" method="POST" autocomplete="off">
      @csrf

      {{-- Name --}}
      <div class="ux-row">
        <div class="ux-lbl">Name <span class="req">*</span> :</div>
        <div class="ux-ctl">
          <input type="text" name="name" class="ux-input" placeholder="User Name" value="{{ old('name') }}">
        </div>
      </div>

      {{-- Email --}}
      <div class="ux-row">
        <div class="ux-lbl">Email <span class="req">*</span> :</div>
        <div class="ux-ctl">
          <input type="email" name="email" class="ux-input" value="{{ old('email') }}">
          <div class="ux-addon" title="Verify / check">
            <span class="cy"><i class="fa fa-wave-square"></i></span>
          </div>
        </div>
      </div>

      {{-- Password --}}
      <div class="ux-row">
        <div class="ux-lbl">Password <span class="req">*</span> :</div>
        <div class="ux-ctl">
          <input id="pwd" type="password" name="password" class="ux-input">
          <div class="ux-addon">
            <span class="cy" title="Generate"><i class="fa fa-random"></i></span>
          </div>
          <button type="button" class="ux-addon ux-eye" data-target="#pwd" title="Show/Hide">
            <i class="fa fa-eye"></i>
          </button>
        </div>
      </div>

      {{-- Confirm Password --}}
      <div class="ux-row">
        <div class="ux-lbl">Confirm Password <span class="req">*</span> :</div>
        <div class="ux-ctl">
          <input id="pwd2" type="password" name="password_confirmation" class="ux-input">
          <div class="ux-addon">
            <span class="cy" title="Generate"><i class="fa fa-random"></i></span>
          </div>
          <button type="button" class="ux-addon ux-eye" data-target="#pwd2" title="Show/Hide">
            <i class="fa fa-eye"></i>
          </button>
        </div>
      </div>

      {{-- Actions --}}
      <div class="ux-actions">
        <a href="{{ route('users.index') }}" class="btn btn-slim btn-close">
          <i class="fa fa-close"></i> Close
        </a>
        <button type="submit" class="btn btn-slim btn-save">
          <i class="fa fa-save"></i> Save
        </button>
      </div>
    </form>
  </div>
</div>
@endsection

@push('scripts')
<script>
  // eye toggle (matches the small eye buttons on the right)
  document.querySelectorAll('.ux-eye').forEach(btn=>{
    btn.addEventListener('click',()=>{
      const target = document.querySelector(btn.getAttribute('data-target'));
      if(!target) return;
      target.type = target.type === 'password' ? 'text' : 'password';
      const i = btn.querySelector('i');
      i.classList.toggle('fa-eye');
      i.classList.toggle('fa-eye-slash');
    });
  });
</script>
@endpush
