@extends('layouts.app')

@section('content')
<div class="container-fluid">

  {{-- Page header --}}
  <div class="rx-head d-flex justify-content-between align-items-center">
    <div class="d-flex align-items-center gap-2">
      <i class="fas fa-list rx-head-ico"></i>
      <h4 class="mb-0 rx-head-title">stock Transfer List</h4>
    </div>

    <a href="{{ route('stock-transfers.create') }}" class="rx-add-btn">
      <i class="fas fa-plus me-1"></i> Add Fising stock Transfer
    </a>
  </div>

  {{-- Table --}}
  <div class="table-responsive">
    <table class="table rx-table mb-3">
      <thead>
        <tr>
          <th class="text-start" style="width:70px">SL</th>
          <th style="width:160px">Invoice No</th>
          <th>From Warehouse</th>
          <th>To Warehouse</th>
          <th style="width:140px">Date</th>
          <th style="width:110px">Total Kg</th>
          <th style="width:110px">Total Mon</th>
          <th style="width:110px">Total Bag</th>
          <th style="width:130px">Transfer Cost</th>
          <th style="width:120px">Action</th>
        </tr>
      </thead>

      <tbody>
        @forelse($transfers as $idx => $t)
          <tr>
            <td>{{ ($transfers->currentPage() - 1) * $transfers->perPage() + $idx + 1 }}</td>
            <td>{{ $t->invoice_no ?? '—' }}</td>
            <td>{{ optional($t->fromWarehouse)->name ?? '—' }}</td>
            <td>{{ optional($t->toWarehouse)->name ?? '—' }}</td>
            <td>{{ optional($t->date)->format('Y-m-d') ?? \Illuminate\Support\Carbon::parse($t->date)->format('Y-m-d') }}</td>
            <td>{{ number_format($t->grand_total_kg ?? 0, 2) }}</td>
            <td>{{ number_format($t->total_mon ?? 0, 3) }}</td>
            <td>{{ number_format($t->total_bag ?? 0, 2) }}</td>
            <td>{{ number_format($t->transfer_cost ?? 0, 2) }}</td>
            <td>
              <div class="btn-group btn-group-sm" role="group">
                <a href="{{ route('stock-transfers.edit', $t->id) }}" class="btn btn-outline-primary">
                  <i class="fas fa-edit"></i>
                </a>
                <form action="{{ route('stock-transfers.destroy', $t->id) }}" method="POST" onsubmit="return confirm('Delete this transfer?')">
                  @csrf @method('DELETE')
                  <button type="submit" class="btn btn-outline-danger">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                </form>
              </div>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="10" class="text-center rx-nodata">No data found!</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>

  {{-- Pagination --}}
  @if(method_exists($transfers, 'links'))
    <div class="d-flex justify-content-end">
      {{ $transfers->links() }}
    </div>
  @endif

</div>
@endsection

@push('styles')
<style>
/* Header */
.rx-head{ padding:10px 6px 14px 6px; }
.rx-head-ico{ color:#2f7cc1; font-size:18px; }
.rx-head-title{ color:#2e5d87; font-weight:600; }
.rx-add-btn{
  display:inline-flex; align-items:center;
  background:#5aa5e3; border:1px solid #4d97d5; color:#fff; text-decoration:none;
  padding:7px 12px; border-radius:3px; font-weight:600;
}
.rx-add-btn:hover{ filter:brightness(0.98); color:#fff; }

/* Table */
.rx-table{ width:100%; border:1px solid #dfe5ec; }
.rx-table thead th{
  background:#d9e7ff;  /* light blue like screenshot */
  color:#3b6aa7; font-weight:700; border-bottom:1px solid #d0d9e6;
  padding:10px 12px; white-space:nowrap;
}
.rx-table tbody td{
  border-top:1px solid #eef2f6; color:#5d6b7a; vertical-align:middle;
  padding:9px 12px;
}

/* No data row */
.rx-nodata{ color:#b64c49; font-weight:700; background:#f7f9fc; }

/* Compact action buttons outline style to match look */
.btn-outline-primary{ border-color:#b9d6f8; color:#2b6fb1; }
.btn-outline-primary:hover{ background:#e8f1fe; color:#2b6fb1; }
.btn-outline-danger{ border-color:#f1c1c1; color:#c94b49; }
.btn-outline-danger:hover{ background:#fdeeee; color:#c94b49; }
</style>
@endpush

