@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-cog sx-head-ico"></i>
        <span class="sx-head-title">Create Finish Product Transfer</span>
      </div>
      <a href="{{ route('transfer.finish-product.index') }}" class="sx-head-link">
        <i class="fas fa-list"></i><span>Finish Product Transfer List</span>
      </a>
    </div>

    <div class="sx-body">
      <form action="{{ route('transfer.finish-product.store') }}" method="POST" id="finishTransferForm" autocomplete="off">
        @csrf

        {{-- TOP FORM (2×2 grid) --}}
        <div class="sx-grid">
          <div class="sx-row">
            <div class="sx-labelcell">From Warehouse</div>
            <div class="sx-inputcell">
              <select name="from_warehouse" class="sx-input" required>
                <option value="">-Select Warehouse-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}">{{ $w->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="sx-row">
            <div class="sx-labelcell">To Warehouse</div>
            <div class="sx-inputcell">
              <select name="to_warehouse" class="sx-input" required>
                <option value="">-Select Warehouse-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}">{{ $w->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="sx-row">
            <div class="sx-labelcell">Date</div>
            <div class="sx-inputcell">
              <div class="sx-dategrp">
                <input type="date" name="date" value="{{ date('Y-m-d') }}" class="sx-input sx-date" required>
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
              </div>
            </div>
          </div>

          <div class="sx-row">
            <div class="sx-labelcell">Transfer Cost</div>
            <div class="sx-inputcell">
              <input type="number" step="0.01" name="transfer_cost" class="sx-input" placeholder="Transfer Cost">
            </div>
          </div>
        </div>

        <div class="sx-section">Stock Transfer</div>

        {{-- TABLE --}}
        <div class="table-responsive">
          <table class="table sx-table" id="transferTable">
            {{-- Column widths (Product flexes; no Action column) --}}
            <colgroup>
              <col class="col-sl">
              <col class="col-pro">
              <col class="col-kg">
              <col class="col-bag">
              <col class="col-total">
              <col class="col-mon">
            </colgroup>

            <thead>
              <tr>
                <th class="text-center">SL</th>
                <th>Product*</th>
                <th>Kg</th>
                <th>Bag</th>
                <th>Total Kg</th>
                <th>Mon</th>
              </tr>
            </thead>

            <tbody id="transferItems">
              <tr class="sx-trow">
                <td class="text-center">1</td>
                <td>
                  <div class="sx-progrp">
                    <select name="items[0][product_id]" class="sx-input" required>
                      <option value="">-select product-</option>
                      @foreach($products as $p)
                        <option value="{{ $p->id }}">{{ $p->name ?? ('#'.$p->id) }}</option>
                      @endforeach
                    </select>
                    <button type="button" class="sx-info" title="Product info"><i class="fas fa-info"></i></button>
                  </div>
                </td>
                <td><input type="number" step="0.01" name="items[0][kg]"  class="sx-input kg-input"  placeholder="KG"></td>
                <td><input type="number" step="1"    name="items[0][bag]" class="sx-input bag-input" placeholder="Bag"></td>
                <td><input type="number" step="0.01" name="items[0][total_kg]" class="sx-input sx-read total-kg" placeholder="0.00" readonly></td>
                <td class="sx-moncell">
                  <input type="number" step="0.001" name="items[0][mon]" class="sx-input" placeholder="0.000">
                  <button type="button" class="sx-minus remove-row" title="Remove"><i class="fas fa-minus"></i></button>
                </td>
              </tr>
            </tbody>

            <tfoot>
              <tr>
                <td colspan="2" class="text-end sx-total-lbl">Total:</td>
                <td><input type="text" class="sx-input sx-read" id="totalKg" value="0" readonly></td>
                <td><input type="text" class="sx-input sx-read" id="totalBag" value="0.00" readonly></td>
                <td><input type="text" class="sx-input sx-read" id="grandTotalKg" value="0.000" readonly></td>
                <td class="sx-moncell sx-moncell-foot">
                  <button type="button" class="sx-plus" id="addRow" title="Add"><i class="fas fa-plus"></i></button>
                </td>
              </tr>
            </tfoot>
          </table>
        </div>

        <div class="sx-savewrap">
          <button type="submit" class="sx-save"><i class="fas fa-save"></i> Save</button>
        </div>
      </form>
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7; --sx-blue-500:#3a6ea5;
  --sx-gray-050:#eaeff4; --sx-gray-080:#eef2f6; --sx-gray-100:#f6f8fb; --sx-gray-120:#eff3f7;
  --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec; --sx-gray-300:#cfd8e3;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
body, .sx-wrap { font-family:"Helvetica Neue",Arial,sans-serif; font-size:14px; color:var(--sx-text); }

/* Card & header */
.sx-wrap{border:1px solid var(--sx-gray-250)!important;border-radius:3px;background:#fff;}
.sx-head{display:flex;align-items:center;justify-content:space-between;background:var(--sx-blue-100);border-bottom:1px solid var(--sx-gray-250);padding:10px 12px;}
.sx-head-left{display:flex;align-items:center;gap:8px;}
.sx-head-ico{color:#6aa3c6;font-size:16px;}
.sx-head-title{color:var(--sx-title);font-weight:600;font-size:16px;}
.sx-head-link{display:inline-flex;align-items:center;gap:8px;background:var(--sx-blue-200);border:1px solid var(--sx-blue-300);color:#2f6fa8;text-decoration:none;border-radius:3px;padding:6px 10px;font-weight:600;}
.sx-body{padding:16px;}

/* Top 2x2 form grid */
.sx-grid{display:grid;grid-template-columns:1fr 1fr;gap:12px 24px;margin-bottom:6px;}
.sx-row{display:grid;grid-template-columns:160px 1fr;align-items:center;}
.sx-labelcell{background:#f2f5f9;border:1px solid #e3e9ef;color:#5d6b7a;font-weight:600;border-radius:3px;padding:8px 12px;}
.sx-input{width:100%;height:36px;line-height:36px;padding:4px 10px;border:1px solid var(--sx-gray-300);border-radius:3px;box-shadow:none;background:#fff;}
.sx-input::placeholder{ color:#b9c3cf; }
.sx-input:focus{ outline:0;border-color:#bcc7d6; }
.sx-dategrp{display:flex;}
.sx-date{border-right:0!important;}
.sx-date::-webkit-calendar-picker-indicator{ display:none; }
.sx-datebtn{display:inline-flex;align-items:center;justify-content:center;width:36px;height:36px;background:#e6ebf1;border:1px solid var(--sx-gray-300);border-left:0;color:#6d7e90;border-radius:0 3px 3px 0;}

/* Section title */
.sx-section{font-size:22px;color:var(--sx-blue-500);font-weight:600;margin:14px 0 10px;}

/* Table */
.sx-table{width:100%; border:1px solid var(--sx-gray-250); margin:0; table-layout:fixed;}
.sx-table thead th{background:var(--sx-gray-100);color:var(--sx-text);font-weight:600;padding:8px 10px;border-bottom:1px solid var(--sx-gray-200);border-right:1px solid var(--sx-gray-220);white-space:nowrap;}
.sx-table tbody td{padding:6px 8px;vertical-align:middle;border-right:1px solid var(--sx-gray-220);}
.sx-table tfoot td{background:var(--sx-gray-120);border-top:1px solid var(--sx-gray-200);padding:6px 8px;}
.table>:not(caption)>*>*{box-shadow:none!important;}
.sx-total-lbl{font-weight:700;}

/* Column widths (Product flex) */
.col-sl   { width:60px; }
.col-kg   { width:130px; }
.col-bag  { width:150px; }
.col-total{ width:160px; }
.col-mon  { width:180px; }
.col-pro  { width:auto; }

/* Product cell */
.sx-progrp{display:flex;width:100%;}
.sx-progrp .sx-input{border-right:0;border-radius:3px 0 0 3px;flex:1 1 auto;min-width:0;}
.sx-info{width:36px;height:36px;display:inline-flex;align-items:center;justify-content:center;border:1px solid #b7d1f6;border-left:0;background:#e0ecff;color:#2e78c7;border-radius:0 3px 3px 0;}

/* Mon cell (input + minus on right) */
.sx-moncell{ position:relative; display:flex; align-items:center; gap:8px; }
.sx-moncell .sx-input{ flex:1 1 auto; }
.sx-moncell .sx-minus{ margin-left:auto; } /* right align minus */

/* Footer Mon cell — RIGHT align plus */
.sx-moncell-foot{ justify-content:flex-end; }

/* Readonly and buttons */
.sx-read{background:var(--sx-gray-050)!important;}
.sx-minus{width:38px;height:28px;background:#d9534f;color:#fff;border:1px solid #c9443f;border-radius:3px;padding:0;}
.sx-plus{width:38px;height:28px;background:#f0ad4e;color:#fff;border:1px solid #e39a30;border-radius:3px;padding:0;}
.sx-savewrap{display:flex;justify-content:flex-end;margin-top:8px;}
.sx-save{display:inline-flex;align-items:center;gap:8px;background:#5fb36b;color:#fff;border:1px solid #479b52;padding:7px 16px;border-radius:3px;font-weight:700;}

/* Responsive: stack top form on small screens only */
@media (max-width: 991.98px){ .sx-grid{ grid-template-columns:1fr; } }
</style>
@endpush

@push('scripts')
<script>
(function($){
  let rowCount = 1;

  function renumber(){
    $('#transferItems .sx-trow').each(function(i){
      $(this).find('td:first').text(i+1);
    });
  }
  function calcRow($row){
    const kg  = parseFloat($row.find('.kg-input').val())  || 0;
    const bag = parseFloat($row.find('.bag-input').val()) || 0;
    $row.find('.total-kg').val((kg * bag).toFixed(2));
  }
  function calcTotals(){
    let tKg=0, tBag=0, tGrand=0;
    $('#transferItems .sx-trow').each(function(){
      tKg   += parseFloat($(this).find('.kg-input').val())   || 0;
      tBag  += parseFloat($(this).find('.bag-input').val())  || 0;
      tGrand+= parseFloat($(this).find('.total-kg').val())   || 0;
    });
    $('#totalKg').val(tKg.toFixed(0));
    $('#totalBag').val(tBag.toFixed(2));
    $('#grandTotalKg').val(tGrand.toFixed(3));
  }

  // Add row
  $('#addRow').on('click', function(){
    const i = rowCount;
    const tpl = `
      <tr class="sx-trow">
        <td class="text-center">${i+1}</td>
        <td>
          <div class="sx-progrp">
            <select name="items[${i}][product_id]" class="sx-input" required>
              <option value="">-select product-</option>
              @foreach($products as $p)
                <option value="{{ $p->id }}">{{ $p->name ?? ('#'.$p->id) }}</option>
              @endforeach
            </select>
            <button type="button" class="sx-info" title="Product info"><i class="fas fa-info"></i></button>
          </div>
        </td>
        <td><input type="number" step="0.01" name="items[${i}][kg]"  class="sx-input kg-input"  placeholder="KG"></td>
        <td><input type="number" step="1"    name="items[${i}][bag]" class="sx-input bag-input" placeholder="Bag"></td>
        <td><input type="number" step="0.01" name="items[${i}][total_kg]" class="sx-input sx-read total-kg" placeholder="0.00" readonly></td>
        <td class="sx-moncell">
          <input type="number" step="0.001" name="items[${i}][mon]" class="sx-input" placeholder="0.000">
          <button type="button" class="sx-minus remove-row" title="Remove"><i class="fas fa-minus"></i></button>
        </td>
      </tr>`;
    $('#transferItems').append(tpl);
    rowCount++; renumber();
  });

  // Remove row
  $(document).on('click', '.remove-row', function(){
    if ($('#transferItems .sx-trow').length <= 1) return alert('At least one item is required');
    $(this).closest('tr').remove(); renumber(); calcTotals();
  });

  // Live totals
  $(document).on('input', '.kg-input, .bag-input', function(){
    const $row = $(this).closest('tr');
    calcRow($row); calcTotals();
  });
})(jQuery);
</script>
@endpush
