﻿@extends('layouts.app')
@section('title','Suppliers List')

@push('styles')
<style>
  .supc *{box-sizing:border-box;font-size:14px}
  .supc .page-head{
    display:flex;align-items:center;justify-content:space-between;margin:0 0 10px
  }
  .supc .title{display:flex;align-items:center;gap:8px;font-weight:800;color:#1e3a5f;font-size:22px}
  .supc .btnbar{display:flex;gap:8px}
  .supc .btnbar a{height:34px;display:inline-flex;align-items:center;gap:6px;padding:0 12px;border-radius:3px;color:#fff;text-decoration:none;border:1px solid transparent}
  .supc .btn-csv{background:#1b76d4;border-color:#1668bb}
  .supc .btn-upload{background:#28a745;border-color:#218838}
  .supc .btn-add{background:#00a3ff;border-color:#0b8ad6}
  .supc .btnbar a i{font-size:13px}

  /* Filter strip (no “Action” label here) */
  .supc .filter{
    border:1px solid #d6e1ef;border-radius:3px;background:#f7f9fc;padding:10px;margin-bottom:10px
  }
  .supc .filter-row{
    display:grid;grid-template-columns: 360px 360px 420px 1fr;gap:10px;align-items:center
  }
  .supc .grp{display:flex;flex-direction:column}
  .supc .lbl{font-weight:700;color:#2b4f7b;margin:0 0 4px}
  .supc .ctl{height:34px;border:1px solid #cfd9e6;border-radius:3px;padding:.375rem .5rem;background:#fff;width:100%}
  .supc .actions{margin-left:auto;display:flex;gap:8px;justify-content:flex-end}
  .supc .btn-search{background:#5fa24f;border:1px solid #4a8c3e;color:#fff;height:34px;padding:0 12px;border-radius:3px}
  .supc .btn-refresh{height:34px;width:36px;border-radius:3px;background:#e9eef3;border:1px solid #d9e2ea;color:#3f4a59;display:flex;align-items:center;justify-content:center}

  /* Table clone */
  .supc .tblbox{border:1px solid #cdd9e8;border-radius:3px;overflow:hidden}
  .supc table{width:100%;border-collapse:separate;border-spacing:0}
  .supc thead th{
    background:linear-gradient(#f5f8ff,#e9eef7);color:#2c5b94;font-weight:800;
    padding:.60rem .75rem;border-bottom:1px solid #cdd9e8;border-right:1px solid #e3ecf7;white-space:nowrap
  }
  .supc tbody td{
    padding:.60rem .75rem;border-top:1px solid #e9edf3;border-right:1px solid #eef3f8;color:#1b2b45;vertical-align:middle
  }
  .mono{font-variant-numeric:tabular-nums}

  /* Status dot + action pills */
  .status-dot{width:18px;height:18px;border-radius:50%;display:inline-block;background:#28a745;border:2px solid #1c7b33}
  .status-dot.off{background:#aeb8c2;border-color:#8d97a3}
  .acts{display:inline-flex;gap:6px}
  .pill{width:30px;height:28px;border-radius:3px;border:0;color:#fff;display:inline-flex;align-items:center;justify-content:center}
  .pill.view{background:#409ad9}.pill.edit{background:#28a745}.pill.del{background:#dc3545}
  .pill i{font-size:13px}

  /* Optional fixed widths (feel free to keep or remove) */
  .w-sl{width:52px;text-align:center}
  .w-id{width:140px}
  .w-name{width:170px}
  .w-comp{width:260px}
  .w-mail{width:280px}
  .w-phone{width:140px}
  .w-addr{width:280px}
  .w-pty{width:100px}
  .w-due{width:110px;text-align:right}
  .w-cur{width:130px;text-align:right}
  .w-bag{width:90px;text-align:right}
  .w-rem{width:160px}
  .w-img{width:120px}
  .w-st{width:80px;text-align:center}
  .w-act{width:120px;text-align:center}

  .export{display:flex;gap:14px;padding:10px}
  .export img{width:28px;height:28px}
</style>
@endpush

@section('content')
<div class="container-fluid supc">

  {{-- Top buttons (right) --}}
  <div class="page-head">
    <div class="title"><i class="fa fa-bars"></i> Suppliers List</div>
    <div class="btnbar">
      <a class="btn-csv" href="{{ route('suppliers.csv') }}"><i class="fa fa-table"></i> CSV List</a>
      <a class="btn-upload" href="{{ route('suppliers.csv') }}"><i class="fa fa-upload"></i> Upload Suppliers CSV</a>
      <a class="btn-add" href="{{ route('suppliers.create') }}"><i class="fa fa-plus"></i> Add Supplier</a>
    </div>
  </div>

  {{-- Filter row (NO “Action” label here) --}}
  <form class="filter" method="GET" action="{{ route('suppliers.index') }}">
    <div class="filter-row">
      <div class="grp">
        <label class="lbl">Supplier</label>
        <select name="customer_id" class="ctl">
          <option value="">-Select Customer-</option>
          @foreach($customers ?? [] as $c)
            <option value="{{ $c->id }}" @selected(request('customer_id')==$c->id)>{{ $c->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="grp">
        <label class="lbl">Company Name</label>
        <input class="ctl" name="company" value="{{ request('company') }}" placeholder="Company Name">
      </div>
      <div class="grp">
        <label class="lbl">Phone Number</label>
        <input class="ctl" name="phone" value="{{ request('phone') }}" placeholder="Search by Phone number">
      </div>

      <div class="actions">
        <button class="btn-search" type="submit"><i class="fa fa-search"></i> Search</button>
        <a class="btn-refresh" href="{{ route('suppliers.index') }}" title="Refresh"><i class="fa fa-refresh"></i></a>
      </div>
    </div>
  </form>

  {{-- Table --}}
  <div class="tblbox table-responsive">
    <table class="table mb-0">
      <colgroup>
        <col class="w-sl"><col class="w-id"><col class="w-name"><col class="w-comp"><col class="w-mail">
        <col class="w-phone"><col class="w-addr"><col class="w-pty"><col class="w-due">
        <col class="w-cur"><col class="w-bag"><col class="w-rem"><col class="w-img"><col class="w-st"><col class="w-act">
      </colgroup>
      <thead>
        <tr>
          <th>SL</th>
          <th>Supplier ID</th>
          <th>Supplier Name</th>
          <th>Company Name</th>
          <th>Email</th>
          <th>Phone Personal</th>
          <th>Address</th>
          <th>Party Type</th>
          <th class="mono">Due Limit</th>
          <th class="mono">Current Balance</th>
          <th class="mono">Bag Opening</th>
          <th>Remarks</th>
          <th>Image</th>
          <th>Status</th>
          <th>Action</th>
        </tr>
      </thead>

      <tbody>
      @forelse($suppliers as $i => $s)
        @php
          $active = (int)($s->status ?? $s->is_active ?? 0);
        @endphp
        <tr>
          <td class="text-center">{{ ($suppliers->firstItem() ?? 1) + $i }}</td>
          <td>{{ $s->supplierid ?? $s->supplierId ?? $s->supplier_code ?? '-' }}</td>
          <td>{{ $s->name }}</td>
          <td>{{ $s->company_name }}</td>
          <td>{{ $s->email }}</td>
          <td>{{ $s->personal_phone }}</td>
          <td>{{ $s->address }}</td>
          <td>{{ $s->party_type ?? '-' }}</td>
          <td class="mono">{{ number_format($s->due_limit ?? 0,2) }}</td>
          <td class="mono">{{ number_format($s->current_balance ?? 0,2) }}</td>
          <td class="mono">{{ (int)($s->bag_opening ?? 0) }}</td>
          <td>{{ $s->remarks ?? '' }}</td>
          <td>Not available</td>

          {{-- Status toggle (form post) --}}
          <td class="text-center">
            <form method="POST" action="{{ route('suppliers.toggle',$s->id) }}" style="margin:0">
              @csrf
              <button type="submit" style="background:transparent;border:0;cursor:pointer" title="Toggle status">
                <span class="status-dot {{ $active ? '' : 'off' }}"></span>
              </button>
            </form>
          </td>

          {{-- Action buttons --}}
          <td class="text-center">
            <div class="acts">
              {{-- view (optional) --}}
              @if(Route::has('suppliers.show'))
              <a class="pill view" href="{{ route('suppliers.show',$s->id) }}" title="View"><i class="fa fa-eye"></i></a>
              @endif

              @if(Route::has('suppliers.edit'))
              <a class="pill edit" href="{{ route('suppliers.edit',$s->id) }}" title="Edit"><i class="fa fa-pencil"></i></a>
              @endif

              @if(Route::has('suppliers.destroy'))
              <form method="POST" action="{{ route('suppliers.destroy',$s->id) }}" style="display:inline">
                @csrf @method('DELETE')
                <button class="pill del" onclick="return confirm('Delete this supplier?')" title="Delete"><i class="fa fa-trash"></i></button>
              </form>
              @endif
            </div>
          </td>
        </tr>
      @empty
        <tr><td colspan="15" class="text-center text-muted py-3">No suppliers found.</td></tr>
      @endforelse
      </tbody>
    </table>
  </div>

  {{-- Export icons (download) --}}
  <div class="export">
    <a href="{{ route('suppliers.export',['format'=>'xlsx']) }}" title="Download Excel">
      <img src="https://img.icons8.com/color/48/microsoft-excel-2019--v1.png" alt="excel">
    </a>
    <a href="{{ route('suppliers.export',['format'=>'pdf']) }}" title="Download PDF">
      <img src="https://img.icons8.com/color/48/pdf.png" alt="pdf">
    </a>
  </div>

  @if(method_exists($suppliers,'links'))
    <div class="mt-2">{{ $suppliers->appends(request()->query())->links() }}</div>
  @endif
</div>
@endsection
