@extends('layouts.app')
@section('title','Edit Supplier')

@push('styles')
<style>
/* ঠিক create পেজের মতই স্টাইল (নাম আলাদা রাখলাম) */
.sup-edit *{ box-sizing:border-box; font-size:14px }
.sup-edit .panel{ border:1px solid #cdd9e8; border-radius:4px; background:#fff; }
.sup-edit .panel-hd{
  display:flex; align-items:center; justify-content:space-between;
  padding:10px 14px; border-bottom:1px solid #e5ebf3; background:#f7f7f7;
}
.sup-edit .title{ font-size:20px; font-weight:700; color:#2d3a4b; display:flex; gap:8px; align-items:center }
.sup-edit .link-list{ color:#1b6ec2; text-decoration:none; font-weight:600; }
.sup-edit .link-list i{ margin-right:6px }

.sup-edit .panel-bd{ padding:14px }
.sup-edit .grid{ display:grid; grid-template-columns:1fr 1fr; gap:12px 18px }
@media (max-width: 992px){ .sup-edit .grid{ grid-template-columns:1fr } }

/* row/inputs – create পেজের মতই */
.sup-edit .row{ display:grid; grid-template-columns:110px 1fr; align-items:center; gap:0 }
.sup-edit .lbl{
  background:#f7f7f9; border:1px solid #dfe5ec; border-right:none;
  padding:.45rem .6rem; color:#575e68; white-space:nowrap; border-radius:3px 0 0 3px;
}
.sup-edit .ctrl{
  border:1px solid #dfe5ec; border-left:none; border-radius:0 3px 3px 0;
  height:34px; padding:.375rem .5rem; width:100%; outline:0; background:#fff;
}
.sup-edit .ctrl[readonly]{ background:#f8fafc }
.sup-edit select.ctrl{ padding-right:34px }
.sup-edit .req::after{ content:" *"; color:#c0392b }

/* file input (label | filename | button) */
.sup-edit .file-wrap{ display:grid; grid-template-columns:110px 1fr 90px; align-items:center; gap:0 8px; }
.sup-edit .file-name{
  border:1px solid #dfe5ec; border-left:none; height:34px; display:flex; align-items:center;
  padding:0 .6rem; border-radius:0 3px 3px 0; overflow:hidden; white-space:nowrap; text-overflow:ellipsis; background:#fff;
}
.sup-edit .btn-file{
  height:34px; border:1px solid #5297ce; background:#5aa0d8; color:#fff;
  border-radius:3px; cursor:pointer; display:inline-flex; align-items:center; justify-content:center;
}
.sup-edit input[type="file"]{ display:none }

/* actions */
.sup-edit .actions{ display:flex; gap:10px; justify-content:flex-end; margin-top:10px }
.sup-edit .btn{ height:34px; border-radius:3px; display:inline-flex; align-items:center; gap:6px; padding:0 14px; border:1px solid transparent; cursor:pointer }
.sup-edit .btn-save{ background:#69a95e; border-color:#5f9956; color:#fff }
.sup-edit .btn-reset{ background:#e9eef3; border-color:#d9e2ea; color:#3f4a59 }

/* small helper */
.sup-edit .muted{ color:#7a8797; font-size:13px; margin-top:6px; text-align:left }
</style>
@endpush

@section('content')
<div class="container-fluid sup-edit">
  <div class="panel">
    <div class="panel-hd">
      <div class="title"><i class="fa fa-cog"></i> Edit Supplier</div>
      <a href="{{ route('suppliers.index') }}" class="link-list"><i class="fa fa-list"></i>Supplier List</a>
    </div>

    <div class="panel-bd">
      <form method="POST" action="{{ route('suppliers.update',$supplier->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div class="grid">
          {{-- Left column (create এর বাম পাশের ফিল্ডগুলো) --}}
          <div class="col">
            {{-- Supplier ID (read-only + hidden) --}}
            <div class="row">
              <div class="lbl">Supplier ID</div>
              <input type="text" class="ctrl" value="{{ $supplier->supplierid }}" readonly aria-readonly="true">
              <input type="hidden" name="supplierid" value="{{ $supplier->supplierid }}">
            </div>

            <div class="row">
              <div class="lbl req">Supplier</div>
              <input name="name" value="{{ old('name',$supplier->name) }}" class="ctrl" required>
            </div>

            <div class="row">
              <div class="lbl">B.Phone</div>
              <input name="bussiness_phone" value="{{ old('bussiness_phone',$supplier->bussiness_phone) }}" class="ctrl" placeholder="Enter The Business Phone Number">
            </div>

            <div class="row">
              <div class="lbl">Email</div>
              <input type="email" name="email" value="{{ old('email',$supplier->email) }}" class="ctrl" placeholder="Enter Email">
            </div>

            <div class="row">
              <div class="lbl">Remarks</div>
              <input name="remarks" value="{{ old('remarks',$supplier->remarks) }}" class="ctrl" placeholder="Enter Remarks">
            </div>

            <div class="row">
              <div class="lbl">Due Limit</div>
              <input name="due_limit" value="{{ old('due_limit',$supplier->due_limit) }}" class="ctrl" placeholder="Supplier Due Limit">
            </div>

            <div class="row">
              <div class="lbl">Party Type</div>
              <select name="party_type_id" class="ctrl">
                <option value="">-Party Type Name-</option>
                @foreach($partyTypes ?? [] as $pt)
                  <option value="{{ $pt->id }}" @selected(old('party_type_id',$supplier->party_type_id)==$pt->id)>{{ $pt->name }}</option>
                @endforeach
              </select>
            </div>

            {{-- Image --}}
            <div class="file-wrap">
              <div class="lbl">Image</div>
              <div id="fileLabel" class="file-name">No File …</div>
              <label class="btn-file">
                Choose
                <input type="file" name="image" id="imageInput" accept="image/*">
              </label>
            </div>
            <div class="muted">
              @if(!empty($supplier->image))
                Current: <a href="{{ $supplier->image_url ?? asset($supplier->image) }}" target="_blank">view</a>
              @else
                Image not available
              @endif
            </div>
          </div>

          {{-- Right column (create এর ডান পাশের ফিল্ডগুলো) --}}
          <div class="col">
            <div class="row">
              <div class="lbl">Company</div>
              <input name="company_name" value="{{ old('company_name',$supplier->company_name) }}" class="ctrl" placeholder="Enter Company Name">
            </div>

            <div class="row">
              <div class="lbl req">Phone</div>
              <input name="personal_phone" value="{{ old('personal_phone',$supplier->personal_phone) }}" class="ctrl" required>
            </div>

            <div class="row">
              <div class="lbl req">Address</div>
              <input name="address" value="{{ old('address',$supplier->address) }}" class="ctrl" required>
            </div>

            <div class="row">
              <div class="lbl">Balance</div>
              <input name="current_balance" value="{{ old('current_balance',$supplier->current_balance ?? 0) }}" class="ctrl" readonly>
            </div>

            <div class="row">
              <div class="lbl req">Bag Ware</div>
              <select name="bag_warehouse_id" class="ctrl" required>
                <option value="">-Select Bag Warehouse-</option>
                @foreach(($bagWares ?? $bagWarehouses ?? []) as $wh)
                  <option value="{{ $wh->id }}" @selected(old('bag_warehouse_id',$supplier->bag_warehouse_id)==$wh->id)>{{ $wh->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="row">
              <div class="lbl req">Bag Opening</div>
              <input name="bag_opening" value="{{ old('bag_opening',$supplier->bag_opening) }}" class="ctrl" placeholder="Enter the Bag Opening Quantity" required>
            </div>

            {{-- ✅ Status ঠিক Bag Opening-এর নিচে --}}
            <div class="row">
              <div class="lbl">Status</div>
              <select name="status" class="ctrl">
                <option value="1" @selected(old('status',$supplier->status ?? 1)==1)>Active</option>
                <option value="0" @selected(old('status',$supplier->status ?? 1)==0)>Inactive</option>
              </select>
            </div>
          </div>
        </div>

        {{-- Actions --}}
        <div class="actions">
          <button type="submit" class="btn btn-save"><i class="fa fa-save"></i> Update</button>
          <button type="reset" class="btn btn-reset"><i class="fa fa-refresh"></i> Reset</button>
        </div>
      </form>

      @if ($errors->any())
        <div class="alert alert-danger mt-2">
          <ul class="mb-0">
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
  // file name preview
  const inp = document.getElementById('imageInput');
  const lbl = document.getElementById('fileLabel');
  if (inp && lbl) {
    inp.addEventListener('change', function(){
      lbl.textContent = (this.files && this.files.length) ? this.files[0].name : 'No File …';
    });
  }
</script>
@endpush
