@extends('layouts.app')
@section('title','Upload Suppliers')

@push('styles')
<style>
  .upx *{ box-sizing:border-box; font-size:14px }
  .upx .head{
    display:flex; align-items:center; justify-content:space-between;
    margin:2px 0 12px 0;
  }
  .upx .title{
    display:flex; align-items:center; gap:8px;
    font-size:22px; font-weight:700; color:#2d3a4b;
  }
  .upx .btn{ height:34px; border-radius:3px;
            display:inline-flex; align-items:center; gap:6px;
            padding:.45rem .75rem; border:1px solid transparent; cursor:pointer }
  .upx .btn i{ font-size:13px }
  .upx .btn-green{ background:#28a745; color:#fff; border-color:#238f3b }
  .upx .btn-blue{  background:#3a86c9; color:#fff; border-color:#357dbb }

  .upx .zone-wrap{ margin-top:26px }
  .upx .label{ width:190px; text-align:right; padding-right:16px; color:#222; font-weight:600 }
  .upx .dropzone{
    width:100%; min-height:170px; border:2px dashed #bfcad9; border-radius:4px;
    background:#fff; display:flex; align-items:center; justify-content:center;
    flex-direction:column; color:#9aa3ad; text-align:center; padding:20px;
  }
  .upx .dz-icon{ font-size:38px; opacity:.45; margin-top:10px }
  .upx input[type=file]{ display:none }
  .upx .fake-input{ color:#9aa3ad }
  .upx .bottom-actions{ display:flex; justify-content:flex-end; margin-top:18px }
  .upx .btn-save{ background:#3da35a; color:#fff; border:1px solid #368f4f }
</style>
@endpush

@section('content')
<div class="container-fluid upx">

  {{-- Header --}}
  <div class="head">
    <div class="title"><i class="fa fa-bars"></i> Upload Suppliers</div>

    <div style="display:flex; gap:8px">
      {{-- List Supplier CSV -> same route --}}
      <a href="{{ route('suppliers.csv') }}" class="btn btn-green">
        <i class="fa fa-list"></i> List Supplier CSV
      </a>

      {{-- Download Sample -> same route with action=sample --}}
      <a href="{{ route('suppliers.csv', ['action'=>'sample']) }}" class="btn btn-blue">
        <i class="fa fa-download"></i> Download Sample
      </a>
    </div>
  </div>

  {{-- Dropzone style uploader (single route; action=upload_store) --}}
  <form method="POST"
        action="{{ route('suppliers.csv', ['action'=>'upload_store']) }}"
        enctype="multipart/form-data">
    @csrf

    <div class="zone-wrap">
      <div style="display:flex; align-items:flex-start; gap:14px">
        <div class="label">Upload CSV file</div>

        <label class="dropzone" for="csvFile">
          <div class="fake-input">
            <strong>Drop files here or click to choose</strong>
          </div>
          <i class="fa fa-cloud-upload dz-icon"></i>
          <input id="csvFile" type="file" name="file" accept=".csv">
        </label>
      </div>
    </div>

    <div class="bottom-actions">
      <button type="submit" class="btn btn-save">
        <i class="fa fa-check-circle"></i> Save Supplier
      </button>
    </div>
  </form>
</div>
@endsection

@push('scripts')
<script>
  // show selected file name inside the zone
  const input = document.getElementById('csvFile');
  const zone  = input.closest('.dropzone');

  input.addEventListener('change', () => {
    if (input.files && input.files[0]) {
      zone.querySelector('.fake-input').innerHTML =
        '<strong>' + input.files[0].name + '</strong>';
    }
  });

  // optional drag highlight (no complex drop handler; just UX)
  ['dragenter','dragover'].forEach(ev =>
    zone.addEventListener(ev, e => { e.preventDefault(); zone.style.borderColor = '#3a86c9'; })
  );
  ['dragleave','drop'].forEach(ev =>
    zone.addEventListener(ev, e => { e.preventDefault(); zone.style.borderColor = '#bfcad9'; })
  );
  zone.addEventListener('click', () => input.click());
</script>
@endpush
