@extends('layouts.app')
@section('title','CSV Supplier List')

@push('styles')
<style>
  .csvx *{ box-sizing:border-box; font-size:14px }
  .csvx .head{ display:flex; align-items:center; justify-content:space-between; margin:2px 0 12px 0 }
  .csvx .title{ display:flex; align-items:center; gap:8px; font-size:22px; font-weight:700; color:#2d3a4b }
  .csvx .btn{ height:34px; border-radius:3px; display:inline-flex; align-items:center; gap:6px;
              padding:.45rem .75rem; border:1px solid transparent; cursor:pointer }
  .csvx .btn i{ font-size:13px }
  .csvx .btn-upload{ background:#17a2b8; color:#fff; border-color:#148da0 }
  .csvx .btn-danger{ background:#dc3545; color:#fff; border-color:#c22c3a }
  .csvx .btn-primary{ background:#3a86c9; color:#fff; border-color:#357dbb }
  .csvx .toprow{ display:flex; align-items:center; justify-content:space-between; margin-bottom:10px }

  .csvx .tbl-box{ border:1px solid #cdd9e8 }
  .csvx table{ width:100%; border-collapse:separate; border-spacing:0 }
  .csvx thead th{ background:#f0f5ff; color:#2b3b4d; font-weight:700; padding:.60rem .75rem; border-bottom:1px solid #cdd9e8 }
  .csvx tbody td{ padding:.60rem .75rem; border-top:1px solid #e9edf3; vertical-align:middle }
  .csvx .col-sl{ width:54px; text-align:center }
  .csvx .col-status{ width:90px; text-align:center }
  .csvx .col-actions{ width:150px; text-align:center }
  .csvx .pill{ width:32px; height:28px; border-radius:3px; display:inline-flex; align-items:center; justify-content:center; color:#fff; margin-right:6px; border:0 }
  .csvx .pill-import{ background:#343a40 } .csvx .pill-edit{ background:#28a745 } .csvx .pill-del{ background:#dc3545 }
  .csvx .pill i{ font-size:13px }
  .csvx .mono{ font-variant-numeric: tabular-nums }
</style>
@endpush

@section('content')
<div class="container-fluid csvx">

  {{-- Header --}}
  <div class="head">
    <div class="title"><i class="fa fa-bars"></i> CSV Supplier List</div>

    {{-- Upload CSV -> same route with ?action=upload --}}
    <a href="{{ route('suppliers.csv', ['action'=>'upload']) }}" class="btn btn-upload">
      <i class="fa fa-upload"></i> Upload CSV
    </a>
  </div>

  {{-- Import first 50 + Delete All (same route, different actions) --}}
  <div class="toprow">
    <a href="{{ route('suppliers.csv', ['action'=>'import50']) }}" class="btn btn-primary">
      <i class="fa fa-check-circle"></i> Import First 50 Supplier
    </a>

    <a href="{{ route('suppliers.csv', ['action'=>'delete_all']) }}"
       class="btn btn-danger"
       onclick="return confirm('Delete ALL staged CSV rows?')">
      <i class="fa fa-trash"></i> Delete All
    </a>
  </div>

  {{-- Table --}}
  <div class="tbl-box table-responsive">
    <table class="table mb-0">
      <thead>
        <tr>
          <th class="col-sl">SL.</th>
          <th>Supplier Name</th>
          <th>Company Name</th>
          <th>Email</th>
          <th>Address</th>
          <th>Phone Personal</th>
          <th class="mono">Opening Balance</th>
          <th class="mono">Supplier Due Limit</th>
          <th>Remark</th>
          <th>Party Type</th>
          <th>Bag Warehouse</th>
          <th class="mono">Bag Opening</th>
          <th class="col-status">Status</th>
          <th class="col-actions">Action</th>
        </tr>
      </thead>
      <tbody>
      @forelse($rows ?? [] as $i => $r)
        <tr>
          <td class="text-center">{{ ($rows->firstItem() ?? 1) + $i }}</td>
          <td>{{ $r->supplier_name }}</td>
          <td>{{ $r->company_name }}</td>
          <td>{{ $r->email }}</td>
          <td>{{ $r->address }}</td>
          <td>{{ $r->phone_personal }}</td>
          <td class="mono">{{ number_format($r->opening_balance ?? 0,2) }}</td>
          <td class="mono">{{ number_format($r->due_limit ?? 0,2) }}</td>
          <td>{{ $r->remark }}</td>
          <td>{{ $r->party_type }}</td>
          <td>{{ $r->bag_warehouse }}</td>
          <td class="mono">{{ (int)($r->bag_opening ?? 0) }}</td>

          <td class="text-center">
            @if($r->is_valid ?? true)
              <span style="display:inline-block;background:#28a745;color:#fff;padding:.15rem .4rem;border-radius:3px">OK</span>
            @else
              <span style="display:inline-block;background:#dc3545;color:#fff;padding:.15rem .4rem;border-radius:3px">Error</span>
            @endif
          </td>

          <td class="text-center">
            {{-- All actions hit the same route with different params --}}
            <a class="pill pill-import" title="Import row"
               href="{{ route('suppliers.csv', ['action'=>'import_one','id'=>$r->id]) }}">
              <i class="fa fa-download"></i>
            </a>

            <a class="pill pill-edit" title="Edit"
               href="{{ route('suppliers.csv', ['action'=>'edit','id'=>$r->id]) }}">
              <i class="fa fa-pencil"></i>
            </a>

            <a class="pill pill-del" title="Delete"
               onclick="return confirm('Delete this staged row?')"
               href="{{ route('suppliers.csv', ['action'=>'delete','id'=>$r->id]) }}">
              <i class="fa fa-trash"></i>
            </a>
          </td>
        </tr>
      @empty
        <tr>
          <td colspan="14" class="text-center text-muted py-4">No staged CSV data found.</td>
        </tr>
      @endforelse
      </tbody>
    </table>
  </div>

  {{-- Pagination (if $rows is LengthAwarePaginator) --}}
  @if(isset($rows) && method_exists($rows,'links'))
    <div class="mt-2">{{ $rows->appends(request()->query())->links() }}</div>
  @endif

</div>
@endsection
