﻿@extends('layouts.app')
@section('title','Create Supplier')

@push('styles')
<style>
/* ====== scope everything under .sup-create so theme CSS can't fight ====== */
.sup-create *{ box-sizing:border-box; font-size:14px }
.sup-create .panel{ border:1px solid #cdd9e8; border-radius:4px; background:#fff; }
.sup-create .panel-hd{
  display:flex; align-items:center; justify-content:space-between;
  padding:10px 14px; border-bottom:1px solid #e5ebf3; background:#f7f7f7;
}
.sup-create .title{ font-size:20px; font-weight:700; color:#2d3a4b; display:flex; gap:8px; align-items:center }
.sup-create .link-list{ color:#1b6ec2; text-decoration:none; font-weight:600; }
.sup-create .link-list i{ margin-right:6px }

/* grid (2 columns equal width) */
.sup-create .panel-bd{ padding:14px }
.sup-create .grid{ display:grid; grid-template-columns: 1fr 1fr; gap:12px 18px; }
@media (max-width: 992px){ .sup-create .grid{ grid-template-columns: 1fr; } }

/* field row */
.sup-create .row{ display:grid; grid-template-columns:110px 1fr; align-items:center; gap:0; }
.sup-create .lbl{
  background:#f7f7f9; border:1px solid #dfe5ec; border-right:none;
  padding:.45rem .6rem; color:#575e68; white-space:nowrap; border-radius:3px 0 0 3px;
}
.sup-create .ctrl{
  border:1px solid #dfe5ec; border-left:none; border-radius:0 3px 3px 0;
  height:34px; padding:.375rem .5rem; width:100%; outline:0; background:#fff;
}
.sup-create select.ctrl{ padding-right:34px; }
.sup-create .ctrl[readonly]{ background:#f8fafc }
.sup-create .req::after{ content:" *"; color:#c0392b; }

/* file input (3 columns: label | filename | button) */
.sup-create .file-wrap{ display:grid; grid-template-columns:110px 1fr 90px; align-items:center; gap:0 8px; }
.sup-create .file-name{
  border:1px solid #dfe5ec; border-left:none; height:34px; display:flex; align-items:center;
  padding:0 .6rem; border-radius:0 3px 3px 0; overflow:hidden; white-space:nowrap; text-overflow:ellipsis; background:#fff;
}
.sup-create .btn-file{
  height:34px; border:1px solid #5297ce; background:#5aa0d8; color:#fff;
  border-radius:3px; cursor:pointer; display:inline-flex; align-items:center; justify-content:center;
}
.sup-create input[type="file"]{ display:none }

/* actions */
.sup-create .actions{ display:flex; gap:10px; justify-content:flex-end; margin-top:10px; }
.sup-create .btn{ height:34px; border-radius:3px; display:inline-flex; align-items:center; gap:6px; padding:0 14px; border:1px solid transparent; cursor:pointer; }
.sup-create .btn-save{ background:#69a95e; border-color:#5f9956; color:#fff }
.sup-create .btn-reset{ background:#e9eef3; border-color:#d9e2ea; color:#3f4a59 }
</style>
@endpush

@section('content')
<div class="container-fluid sup-create">
  <div class="panel">
    <div class="panel-hd">
      <div class="title"><i class="fa fa-cog"></i> Create Supplier</div>
      <a href="{{ route('suppliers.index') }}" class="link-list"><i class="fa fa-list"></i>Supplier List</a>
    </div>

    <div class="panel-bd">
      <form method="POST" action="{{ route('suppliers.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="grid">
          {{-- Left column --}}
          <div class="col">
            <div class="row">
              <div class="lbl req">Supplier</div>
              <input name="name" value="{{ old('name') }}" class="ctrl" placeholder="Enter The Supplier Name" required>
            </div>

            <div class="row">
              <div class="lbl">B.Phone</div>
              <input name="bussiness_phone" value="{{ old('bussiness_phone') }}" class="ctrl" placeholder="Enter The Business Phone Number">
            </div>

            <div class="row">
              <div class="lbl">Email</div>
              <input type="email" name="email" value="{{ old('email') }}" class="ctrl" placeholder="Enter Email">
            </div>

            <div class="row">
              <div class="lbl">Remarks</div>
              <input name="remarks" value="{{ old('remarks') }}" class="ctrl" placeholder="Enter Remarks">
            </div>

            <div class="row">
              <div class="lbl">Due Limit</div>
              <input name="due_limit" value="{{ old('due_limit') }}" class="ctrl" placeholder="Supplier Due Limit">
            </div>

            <div class="row">
              <div class="lbl">Party Type</div>
              <select name="party_type_id" class="ctrl">
                <option value="">-Party Type Name-</option>
                @foreach($partyTypes ?? [] as $pt)
                  <option value="{{ $pt->id }}" @selected(old('party_type_id')==$pt->id)>{{ $pt->name }}</option>
                @endforeach
              </select>
            </div>

            {{-- Image row --}}
            <div class="file-wrap">
              <div class="lbl">Image</div>
              <div id="fileLabel" class="file-name">No File …</div>
              <label class="btn-file">
                Choose
                <input type="file" name="image" id="imageInput" accept="image/*">
              </label>
            </div>
          </div>

          {{-- Right column --}}
          <div class="col">
            <div class="row">
              <div class="lbl">Company</div>
              <input name="company_name" value="{{ old('company_name') }}" class="ctrl" placeholder="Enter Company Name">
            </div>

            <div class="row">
              <div class="lbl req">Phone</div>
              <input name="personal_phone" value="{{ old('personal_phone') }}" class="ctrl" placeholder="Enter Personal Phone Number" required>
            </div>

            <div class="row">
              <div class="lbl req">Address</div>
              <input name="address" value="{{ old('address') }}" class="ctrl" placeholder="Enter Address" required>
            </div>

            <div class="row">
              <div class="lbl">Balance</div>
              <input name="current_balance" value="{{ old('current_balance',0) }}" class="ctrl" readonly>
            </div>

            <div class="row">
              <div class="lbl req">Bag Ware</div>
              <select name="bag_warehouse_id" class="ctrl" required>
                <option value="">-Select Bag Warehouse-</option>
                @foreach(($bagWares ?? $bagWarehouses ?? []) as $wh)
                  <option value="{{ $wh->id }}" @selected(old('bag_warehouse_id')==$wh->id)>{{ $wh->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="row">
              <div class="lbl req">Bag Opening</div>
              <input name="bag_opening" value="{{ old('bag_opening') }}" class="ctrl" placeholder="Enter the Bag Opening  Quantity" required>
            </div>

            {{-- ✅ Status row just under Bag Opening --}}
            <div class="row">
              <div class="lbl">Status</div>
              <select name="status" class="ctrl">
                <option value="1" @selected(old('status',1)==1)>Active</option>
                <option value="0" @selected(old('status',1)==0)>Inactive</option>
              </select>
            </div>
          </div>
        </div>

        {{-- Actions --}}
        <div class="actions">
          <button type="submit" class="btn btn-save"><i class="fa fa-save"></i> Save</button>
          <button type="reset" class="btn btn-reset"><i class="fa fa-refresh"></i> Reset</button>
        </div>
      </form>

      @if ($errors->any())
        <div class="alert alert-danger mt-2">
          <ul class="mb-0">
            @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
            @endforeach
          </ul>
        </div>
      @endif
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
  // Show selected file name
  const inp = document.getElementById('imageInput');
  const lbl = document.getElementById('fileLabel');
  if (inp) {
    inp.addEventListener('change', function(){
      lbl.textContent = this.files && this.files.length ? this.files[0].name : 'No File …';
    });
  }
</script>
@endpush
