@extends('layouts.app')
@section('title','Packages')

@push('styles')
<style>
/* ===== scoped to avoid global collisions ===== */
.pkg *{ box-sizing:border-box; font-size:14px }
.pkg .card{ background:#fff; border:1px solid #e4e8f0; border-radius:8px; overflow:hidden }
.pkg .card-hd{
  display:flex; align-items:center; justify-content:space-between;
  padding:12px 14px; border-bottom:1px solid #eef1f6; background:#f8fafc;
}
.pkg .card-hd .ttl{ font-size:18px; font-weight:800; color:#223047; display:flex; gap:8px; align-items:center }
.pkg .card-hd .ttl i{ color:#2f80ed }

.pkg .toolbar{ display:flex; gap:10px; align-items:center }
.pkg .toolbar .btn{ height:34px; border-radius:6px; padding:0 12px; border:1px solid transparent; cursor:pointer; font-weight:700 }
.pkg .btn-primary{ background:#2f80ed; color:#fff; border-color:#2f80ed }
.pkg .btn-outline{ background:#fff; color:#2f80ed; border-color:#cfe0ff }

.pkg .filters{ display:flex; gap:8px; padding:12px 14px; border-bottom:1px solid #f0f3f8; background:#fff }
.pkg .filters .ctl{ height:34px; border:1px solid #d8dee9; border-radius:6px; padding:0 10px; background:#fff }

.pkg table{ width:100%; border-collapse:separate; border-spacing:0; }
.pkg thead th{
  background:#f7f9fc; color:#475569; font-weight:800; text-transform:uppercase; letter-spacing:.02em;
  border-bottom:1px solid #e9eef5; padding:10px; font-size:12px;
}
.pkg tbody td{ padding:10px; border-bottom:1px solid #f1f5fb; vertical-align:middle }
.pkg tbody tr:hover{ background:#fbfdff }

.pkg .badge{ display:inline-flex; align-items:center; height:24px; border-radius:999px; padding:0 10px; font-weight:700; font-size:12px }
.pkg .badge-green{ background:#e6f7ef; color:#1f8f5c }
.pkg .badge-gray{ background:#eef2f7; color:#64748b }

.pkg .chip{ display:inline-block; background:#eef4ff; color:#2753c7; border:1px solid #dbe6ff;
            border-radius:999px; padding:2px 8px; font-size:12px; margin:2px 6px 2px 0 }
.pkg .money{ font-variant-numeric: tabular-nums; font-weight:800; color:#1f2a44 }
.pkg .muted{ color:#6b7280 }

.pkg .actions{ display:flex; gap:6px; justify-content:flex-end }
.pkg .btn-xs{ height:28px; padding:0 10px; border-radius:6px; border:1px solid #d8dee9; background:#fff; color:#334155; font-weight:700 }
.pkg .btn-danger{ color:#b42318; border-color:#f5c2c0; background:#fff5f5 }

.pkg .pagination-wrap{ padding:10px 14px; display:flex; justify-content:flex-end }
</style>
@endpush

@section('content')
<div class="pkg">
  <div class="card">
    {{-- Header --}}
    <div class="card-hd">
      <div class="ttl"><i class="fa-solid fa-cubes"></i> Packages</div>
      <div class="toolbar">
        <a href="{{ route('superadmin.packages.create') }}" class="btn btn-primary">
          <i class="fa-solid fa-plus"></i> New Package
        </a>
      </div>
    </div>

    {{-- Filters --}}
    <form method="GET" action="{{ route('superadmin.packages.index') }}">
      <div class="filters">
        <input class="ctl" type="text" name="q" value="{{ request('q') }}" placeholder="Search name…">
        <select class="ctl" name="status">
          <option value="">All status</option>
          <option value="1" @selected(request('status')==='1')>Active</option>
          <option value="0" @selected(request('status')==='0')>Inactive</option>
        </select>
        <select class="ctl" name="per_page">
          @foreach([10,20,50,100] as $pp)
            <option value="{{ $pp }}" @selected((int)request('per_page',20)===$pp)>{{ $pp }}/page</option>
          @endforeach
        </select>
        <button class="btn btn-outline" type="submit"><i class="fa-solid fa-magnifying-glass"></i> Apply</button>
        @if(request()->hasAny(['q','status','per_page']))
          <a class="btn btn-outline" href="{{ route('superadmin.packages.index') }}"><i class="fa-solid fa-rotate-right"></i> Reset</a>
        @endif
      </div>
    </form>

    {{-- Table --}}
    <div class="table-responsive">
      <table>
        <thead>
          <tr>
            <th style="width:28px">#</th>
            <th>Name</th>
            <th style="width:140px">Price</th>
            <th style="width:120px">Duration</th>
            <th>Features</th>
            <th style="width:120px">Status</th>
            <th style="width:150px" class="text-end">Actions</th>
          </tr>
        </thead>
        <tbody>
        @forelse($rows as $i => $p)
          <tr>
            <td class="muted">{{ $rows->firstItem() + $i }}</td>
            <td><strong>{{ $p->name }}</strong></td>
            <td><span class="money">{{ number_format($p->price) }}</span></td>
            <td>{{ (int)$p->duration_months }} mo</td>
            <td>
              @php $features = is_array($p->features) ? $p->features : (json_decode($p->features ?? '[]', true) ?: []); @endphp
              @forelse($features as $key => $val)
                <span class="chip">{{ is_numeric($key) ? $val : $key . ': ' . $val }}</span>
              @empty
                <span class="muted">—</span>
              @endforelse
            </td>
            <td>
              @if($p->is_active)
                <span class="badge badge-green">Active</span>
              @else
                <span class="badge badge-gray">Inactive</span>
              @endif
            </td>
            <td>
              <div class="actions">
                <a href="{{ route('superadmin.packages.edit',$p) }}" class="btn-xs">
                  <i class="fa-regular fa-pen-to-square"></i> Edit
                </a>
                <form method="POST" action="{{ route('superadmin.packages.destroy',$p) }}"
                      onsubmit="return confirm('Delete this package?');">
                  @csrf @method('DELETE')
                  <button class="btn-xs btn-danger" type="submit">
                    <i class="fa-regular fa-trash-can"></i> Delete
                  </button>
                </form>
              </div>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="7" class="muted" style="padding:18px; text-align:center">No packages found.</td>
          </tr>
        @endforelse
        </tbody>
      </table>
    </div>

    {{-- Pagination --}}
    <div class="pagination-wrap">
      {{ $rows->appends(request()->query())->links() }}
    </div>
  </div>
</div>
@endsection
