@extends('layouts.app')
@section('title','Create Business')
@section('content')
<form method="POST" action="{{ route('superadmin.businesses.store') }}">
@csrf
<div class="card">
  <div class="card-header"><h5>Create Business</h5></div>
  <div class="card-body">
    <div class="mb-3">
      <label class="form-label">Business Name</label>
      <input name="name" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Owner</label>
      <select name="owner_id" class="form-select" required>
        <option value="">-- select owner --</option>
        @foreach($owners as $o)
          <option value="{{ $o->id }}">{{ $o->name }} ({{ $o->email }})</option>
        @endforeach
      </select>
    </div>
    <div class="mb-3">
      <label class="form-label">Package</label>
      <select name="package_id" class="form-select" required>
        <option value="">-- select package --</option>
        @foreach($packages as $p)
          <option value="{{ $p->id }}">{{ $p->name }} — {{ $p->duration_months }} mo</option>
        @endforeach
      </select>
    </div>
    <div class="row">
      <div class="col-md-6 mb-3">
        <label class="form-label">Subdomain (optional)</label>
        <input name="subdomain" class="form-control" placeholder="eg. acme">
      </div>
      <div class="col-md-6 mb-3">
        <label class="form-label">Timezone</label>
        <input name="timezone" class="form-control" value="Asia/Dhaka">
      </div>
    </div>
  </div>
  <div class="card-footer text-end">
    <button class="btn btn-primary">Create</button>
  </div>
</div>
</form>
@endsection
