@extends('layouts.app')
@section('title','Printers')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111}
  .wrap{max-width:1100px;margin:0 auto}
  .panel{background:var(--card);border:1px solid var(--border);border-radius:10px;padding:16px;margin-bottom:16px}
  .panel h3{margin:0 0 12px;font-size:16px;font-weight:800;color:var(--text)}
  .grid{display:grid;grid-template-columns:1fr 1fr;gap:16px}
  @media (max-width: 980px){.grid{grid-template-columns:1fr}}
  .row{display:grid;grid-template-columns:220px 1fr;align-items:center;gap:10px;margin:10px 0}
  .row label{font-weight:600;color:var(--text)}
  .row small{color:var(--muted)}
  input[type="text"], input[type="number"], select, textarea{
    width:100%;padding:10px;border:1px solid var(--border);border-radius:8px;background:#fff
  }
  .check{display:flex;align-items:center;gap:8px}
  .muted{color:var(--muted)}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:#1d4ed8;color:#fff}
  .btn-ghost{background:#f3f4f6}
  .actions{display:flex;gap:8px;justify-content:flex-end;margin-top:12px}
  .hint{font-size:12px;color:var(--muted);margin-top:4px}
  .sep{height:1px;background:var(--border);margin:12px 0}
</style>
@endpush

@section('content')
@php
  $s = fn($k,$d=null)=> old($k, $settings[$k] ?? $d);
@endphp

<div class="wrap">

  {{-- Page header --}}
  <div class="panel" style="display:flex;align-items:center;justify-content:space-between;">
    <h3><i class="fa-solid fa-print"></i> Printer Settings</h3>
    <div class="actions">
      @if (Route::has('settings.printers.test'))
        <a href="{{ route('settings.printers.test') }}" class="btn btn-ghost">
          <i class="fa-solid fa-vial"></i> Test Print
        </a>
      @endif
      <button form="printerForm" class="btn btn-primary">
        <i class="fa-solid fa-floppy-disk"></i> Save Settings
      </button>
    </div>
  </div>

  <form id="printerForm" action="{{ route('settings.printers.save') }}" method="POST">
    @csrf @method('PUT')

    <div class="grid">
      {{-- ============ Left: General / Browser printing ============ --}}
      <div class="panel">
        <h3>General / Browser Printing</h3>

        <div class="row">
          <label for="print_driver">Print Driver</label>
          <div>
            <select id="print_driver" name="print_driver">
              <option value="browser"  {{ $s('print_driver','browser')==='browser'?'selected':'' }}>Browser (default)</option>
              <option value="system"   {{ $s('print_driver')==='system'?'selected':'' }}>System (connector/OS)</option>
              <option value="escpos"   {{ $s('print_driver')==='escpos'?'selected':'' }}>ESC/POS (USB/Network)</option>
            </select>
            <div class="hint">Choose how printing will be executed. “Browser” works everywhere. ESC/POS is for POS thermal printers.</div>
          </div>
        </div>

        <div class="row">
          <label for="default_printer">Default Printer Name</label>
          <div>
            <input type="text" id="default_printer" name="default_printer" placeholder="e.g. HP LaserJet or EPSON TM-T20"
                   value="{{ $s('default_printer') }}">
            <div class="hint">Needed for System/ESC-POS drivers. Keep empty for Browser print dialog to choose each time.</div>
          </div>
        </div>

        <div class="row">
          <label for="print_copies">Default Copies</label>
          <div>
            <input type="number" min="1" max="10" id="print_copies" name="print_copies" value="{{ $s('print_copies',1) }}">
          </div>
        </div>

        <div class="row">
          <label>Browser Print Dialog</label>
          <div class="check">
            <input type="hidden" name="show_print_dialog" value="0">
            <input type="checkbox" id="show_print_dialog" name="show_print_dialog" value="1"
                   {{ $s('show_print_dialog',1) ? 'checked':'' }}>
            <label for="show_print_dialog" class="muted">Show dialog (disable only if you use a connector for silent printing)</label>
          </div>
        </div>

        <div class="sep"></div>

        <div class="row">
          <label for="paper_size">Default Paper Size</label>
          <div>
            <select id="paper_size" name="paper_size">
              <option value="A4"  {{ $s('paper_size','A4')==='A4'?'selected':'' }}>A4</option>
              <option value="A5"  {{ $s('paper_size')==='A5'?'selected':'' }}>A5</option>
              <option value="POS80" {{ $s('paper_size')==='POS80'?'selected':'' }}>POS 80mm</option>
              <option value="POS58" {{ $s('paper_size')==='POS58'?'selected':'' }}>POS 58mm</option>
            </select>
          </div>
        </div>

        <div class="row">
          <label for="print_alignment">Default Alignment</label>
          <div>
            <select id="print_alignment" name="print_alignment">
              <option value="left"   {{ $s('print_alignment','left')==='left'?'selected':'' }}>Left</option>
              <option value="center" {{ $s('print_alignment')==='center'?'selected':'' }}>Center</option>
              <option value="right"  {{ $s('print_alignment')==='right'?'selected':'' }}>Right</option>
            </select>
          </div>
        </div>

      </div>

      {{-- ============ Right: POS / ESC-POS ============ --}}
      <div class="panel">
        <h3>POS / ESC-POS Options</h3>

        <div class="row">
          <label for="pos_width">Roll Width</label>
          <div>
            <select id="pos_width" name="pos_width">
              <option value="80" {{ $s('pos_width','80')==='80'?'selected':'' }}>80 mm</option>
              <option value="58" {{ $s('pos_width')==='58'?'selected':'' }}>58 mm</option>
            </select>
          </div>
        </div>

        <div class="row">
          <label for="pos_chars">Chars per Line</label>
          <div>
            <input type="number" min="24" max="64" id="pos_chars" name="pos_chars" value="{{ $s('pos_chars',42) }}">
            <div class="hint">Typical: 42 for 80mm, 32 for 58mm (depends on font/printer).</div>
          </div>
        </div>

        <div class="row">
          <label>Cut Paper</label>
          <div class="check">
            <input type="hidden" name="pos_cut" value="0">
            <input type="checkbox" id="pos_cut" name="pos_cut" value="1" {{ $s('pos_cut',1)?'checked':'' }}>
            <label for="pos_cut" class="muted">Send cut command after print (if supported)</label>
          </div>
        </div>

        <div class="row">
          <label>Open Cash Drawer</label>
          <div class="check">
            <input type="hidden" name="pos_drawer" value="0">
            <input type="checkbox" id="pos_drawer" name="pos_drawer" value="1" {{ $s('pos_drawer')?'checked':'' }}>
            <label for="pos_drawer" class="muted">Pulse drawer after print</label>
          </div>
        </div>

        <div class="row">
          <label>POS Logo</label>
          <div class="check">
            <input type="hidden" name="pos_logo" value="0">
            <input type="checkbox" id="pos_logo" name="pos_logo" value="1" {{ $s('pos_logo',1)?'checked':'' }}>
            <label for="pos_logo" class="muted">Print small logo at header (if present)</label>
          </div>
        </div>

        <div class="row">
          <label>QR on POS</label>
          <div class="check">
            <input type="hidden" name="pos_qr" value="0">
            <input type="checkbox" id="pos_qr" name="pos_qr" value="1" {{ $s('pos_qr',1)?'checked':'' }}>
            <label for="pos_qr" class="muted">Generate QR (invoice link / payment / text)</label>
          </div>
        </div>

        <div class="sep"></div>

        <div class="row">
          <label for="pos_left">Margin Left (mm)</label>
          <div><input type="number" id="pos_left" name="pos_left" min="0" max="20" value="{{ $s('pos_left',0) }}"></div>
        </div>
        <div class="row">
          <label for="pos_right">Margin Right (mm)</label>
          <div><input type="number" id="pos_right" name="pos_right" min="0" max="20" value="{{ $s('pos_right',0) }}"></div>
        </div>
        <div class="row">
          <label for="pos_top">Margin Top (mm)</label>
          <div><input type="number" id="pos_top" name="pos_top" min="0" max="30" value="{{ $s('pos_top',0) }}"></div>
        </div>
        <div class="row">
          <label for="pos_bottom">Margin Bottom (mm)</label>
          <div><input type="number" id="pos_bottom" name="pos_bottom" min="0" max="30" value="{{ $s('pos_bottom',0) }}"></div>
        </div>

      </div>
    </div>

    <div class="panel actions" style="justify-content:flex-end">
      <button class="btn btn-ghost" type="reset"><i class="fa-regular fa-rectangle-xmark"></i> Reset</button>
      <button class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save Settings</button>
    </div>

  </form>
</div>
@endsection

@push('scripts')
<script>
  // Hide POS block hints if driver is browser
  const driverSel = document.getElementById('print_driver');
  const posPanel  = document.querySelectorAll('.panel')[2]; // right panel
  function syncPOSVisibility(){
    if(!driverSel) return;
    if(driverSel.value === 'escpos' || driverSel.value === 'system'){
      posPanel.style.opacity = '1';
    } else {
      posPanel.style.opacity = '0.55';
    }
  }
  driverSel?.addEventListener('change', syncPOSVisibility);
  syncPOSVisibility();
</script>
@endpush
