@extends('layouts.app')
@section('title','Payment Methods')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111}
  .wrap{max-width:1200px;margin:0 auto}
  .panel{background:var(--card);border:1px solid var(--border);border-radius:10px;padding:16px;margin-bottom:16px}
  .panel h3{margin:0 0 12px;font-size:16px;font-weight:800;color:var(--text)}
  .actions{display:flex;gap:8px;justify-content:flex-end}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:#1d4ed8;color:#fff}
  .btn-ghost{background:#f3f4f6}
  .muted{color:var(--muted)}
  table.pm{width:100%;border-collapse:separate;border-spacing:0 8px}
  table.pm thead th{font-size:12px;text-transform:uppercase;color:var(--muted);text-align:left}
  table.pm tbody tr{background:#fff;border:1px solid var(--border)}
  table.pm tbody tr td{padding:8px}
  table.pm input[type="text"],
  table.pm input[type="number"],
  table.pm select, table.pm textarea{
    width:100%;padding:8px;border:1px solid var(--border);border-radius:8px;background:#fff
  }
  .switch{display:flex;align-items:center;gap:8px}
  .sep{height:1px;background:var(--border);margin:12px 0}
  .sticky-actions{position:sticky;bottom:0;background:#fff;border:1px solid var(--border);border-radius:10px;padding:10px}
  .drag{cursor:grab;opacity:.7}
  .w-8{width:2rem}
  .w-12{width:3rem}
  .w-16{width:4rem}
</style>
@endpush

@section('content')
@php
  $raw = $settings['payment_methods'] ?? null;
  $methods = is_string($raw) ? json_decode($raw, true) : (is_array($raw) ? $raw : null);

  // Fallback defaults
  if (!$methods || !is_array($methods) || !count($methods)) {
      $methods = [
          ['active'=>1,'name'=>'Cash','code'=>'cash','type'=>'cash','fee_type'=>'none','fee_value'=>0,'pos'=>1,'web'=>1,'order'=>1,'notes'=>null],
          ['active'=>1,'name'=>'Bank Transfer','code'=>'bank','type'=>'bank','fee_type'=>'none','fee_value'=>0,'pos'=>0,'web'=>1,'order'=>2,'notes'=>null],
          ['active'=>1,'name'=>'Card','code'=>'card','type'=>'card','fee_type'=>'percent','fee_value'=>1.5,'pos'=>1,'web'=>1,'order'=>3,'notes'=>null],
          ['active'=>1,'name'=>'Mobile Wallet','code'=>'mobile','type'=>'mobile','fee_type'=>'fixed','fee_value'=>5,'pos'=>1,'web'=>1,'order'=>4,'notes'=>'bKash / Nagad'],
      ];
  }
  $default = $settings['default_payment_method'] ?? 'cash';
@endphp

<div class="wrap">

  {{-- Header --}}
  <div class="panel" style="display:flex;align-items:center;justify-content:space-between;">
    <h3><i class="fa-solid fa-credit-card"></i> Payment Methods</h3>
    <div class="actions">
      <button type="button" id="addRowBtn" class="btn btn-ghost"><i class="fa-solid fa-plus"></i> Add Method</button>
      <button form="pmForm" class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save Settings</button>
    </div>
  </div>

  <form id="pmForm" action="{{ route('settings.payments.save') }}" method="POST">
    @csrf @method('PUT')

    {{-- Global options --}}
    <div class="panel">
      <h3>General Options</h3>
      <div style="display:grid;grid-template-columns:260px 1fr;gap:10px;align-items:center">
        <label for="default_payment_method" class="fw-600">Default Payment Method</label>
        <select name="default_payment_method" id="default_payment_method">
          @foreach($methods as $m)
            <option value="{{ $m['code'] }}" {{ $default===$m['code']?'selected':'' }}>
              {{ $m['name'] }} ({{ $m['code'] }})
            </option>
          @endforeach
        </select>
      </div>
    </div>

    {{-- Methods table --}}
    <div class="panel">
      <h3>Methods</h3>

      <table class="pm" id="pmTable">
        <thead>
          <tr>
            <th class="w-8">#</th>
            <th class="w-12">Active</th>
            <th>Name</th>
            <th>Code</th>
            <th>Type</th>
            <th>Fee</th>
            <th class="w-12">POS</th>
            <th class="w-12">Web</th>
            <th class="w-12">Order</th>
            <th>Notes</th>
            <th class="w-12">Del</th>
          </tr>
        </thead>
        <tbody id="pmBody">
          @foreach($methods as $i => $m)
          <tr data-row>
            <td class="drag" title="Drag (visual only)">
              <i class="fa-solid fa-grip-lines"></i>
            </td>

            <td>
              <div class="switch">
                <input type="hidden" name="methods[{{ $i }}][active]" value="0">
                <input type="checkbox" name="methods[{{ $i }}][active]" value="1" {{ !empty($m['active'])?'checked':'' }}>
              </div>
            </td>

            <td>
              <input type="text" name="methods[{{ $i }}][name]" value="{{ $m['name'] }}" placeholder="e.g. Cash">
            </td>

            <td>
              <input type="text" name="methods[{{ $i }}][code]" value="{{ $m['code'] }}" placeholder="unique code (slug)">
            </td>

            <td>
              <select name="methods[{{ $i }}][type]">
                @php $types=['cash'=>'Cash','bank'=>'Bank','card'=>'Card','mobile'=>'Mobile','other'=>'Other']; @endphp
                @foreach($types as $tv=>$tl)
                  <option value="{{ $tv }}" {{ ($m['type']??'')===$tv ? 'selected':'' }}>{{ $tl }}</option>
                @endforeach
              </select>
            </td>

            <td>
              <div style="display:flex;gap:8px">
                <select class="w-16" name="methods[{{ $i }}][fee_type]">
                  @php $ft=['none'=>'None','percent'=>'%','fixed'=>'Fixed']; @endphp
                  @foreach($ft as $fv=>$fl)
                    <option value="{{ $fv }}" {{ ($m['fee_type']??'none')===$fv?'selected':'' }}>{{ $fl }}</option>
                  @endforeach
                </select>
                <input class="w-16" type="number" step="0.01" name="methods[{{ $i }}][fee_value]" value="{{ $m['fee_value'] ?? 0 }}">
              </div>
              <div class="muted" style="font-size:12px">Percent/fixed charge applied on this method.</div>
            </td>

            <td style="text-align:center">
              <input type="hidden" name="methods[{{ $i }}][pos]" value="0">
              <input type="checkbox" name="methods[{{ $i }}][pos]" value="1" {{ !empty($m['pos'])?'checked':'' }}>
            </td>

            <td style="text-align:center">
              <input type="hidden" name="methods[{{ $i }}][web]" value="0">
              <input type="checkbox" name="methods[{{ $i }}][web]" value="1" {{ !empty($m['web'])?'checked':'' }}>
            </td>

            <td>
              <input type="number" class="w-16" name="methods[{{ $i }}][order]" value="{{ $m['order'] ?? ($i+1) }}">
            </td>

            <td>
              <input type="text" name="methods[{{ $i }}][notes]" value="{{ $m['notes'] ?? '' }}" placeholder="instruction / account hint">
            </td>

            <td style="text-align:center">
              <button type="button" class="btn btn-ghost" onclick="removeRow(this)" title="Delete">
                <i class="fa-regular fa-trash-can"></i>
              </button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>

      <div class="sep"></div>

      <div class="sticky-actions actions">
        <button type="button" id="addRowBtn2" class="btn btn-ghost"><i class="fa-solid fa-plus"></i> Add Method</button>
        <button class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save Settings</button>
      </div>
    </div>
  </form>
</div>

{{-- Template row (hidden) --}}
<template id="pmRowTmpl">
<tr data-row>
  <td class="drag"><i class="fa-solid fa-grip-lines"></i></td>

  <td>
    <div class="switch">
      <input type="hidden" name="__N__[active]" value="0">
      <input type="checkbox" name="__N__[active]" value="1" checked>
    </div>
  </td>

  <td><input type="text" name="__N__[name]" placeholder="e.g. New Method"></td>
  <td><input type="text" name="__N__[code]" placeholder="unique-code"></td>

  <td>
    <select name="__N__[type]">
      <option value="cash">Cash</option>
      <option value="bank">Bank</option>
      <option value="card">Card</option>
      <option value="mobile">Mobile</option>
      <option value="other">Other</option>
    </select>
  </td>

  <td>
    <div style="display:flex;gap:8px">
      <select class="w-16" name="__N__[fee_type]">
        <option value="none" selected>None</option>
        <option value="percent">%</option>
        <option value="fixed">Fixed</option>
      </select>
      <input class="w-16" type="number" step="0.01" name="__N__[fee_value]" value="0">
    </div>
    <div class="muted" style="font-size:12px">Percent/fixed charge applied on this method.</div>
  </td>

  <td style="text-align:center">
    <input type="hidden" name="__N__[pos]" value="0">
    <input type="checkbox" name="__N__[pos]" value="1" checked>
  </td>

  <td style="text-align:center">
    <input type="hidden" name="__N__[web]" value="0">
    <input type="checkbox" name="__N__[web]" value="1" checked>
  </td>

  <td><input type="number" class="w-16" name="__N__[order]" value="1"></td>

  <td><input type="text" name="__N__[notes]" placeholder="instruction / account hint"></td>

  <td style="text-align:center">
    <button type="button" class="btn btn-ghost" onclick="removeRow(this)" title="Delete">
      <i class="fa-regular fa-trash-can"></i>
    </button>
  </td>
</tr>
</template>
@endsection

@push('scripts')
<script>
  const bodyEl = document.getElementById('pmBody');
  const tmpl    = document.getElementById('pmRowTmpl').innerHTML;

  function nextIndex(){
    const rows = bodyEl.querySelectorAll('[data-row]');
    return rows.length ? Math.max(...[...rows].map((r,i)=>i)) + 1 : 0;
  }

  function addRow(){
    const i = nextIndex();
    const html = tmpl.replaceAll('__N__', `methods[${i}]`);
    bodyEl.insertAdjacentHTML('beforeend', html);
    // also append in default select
    const defSel = document.getElementById('default_payment_method');
    // try to capture new code once user types; initially keep placeholder
    const lastRow = bodyEl.querySelectorAll('tr[data-row]')[bodyEl.querySelectorAll('tr[data-row]').length-1];
    const codeInp = lastRow.querySelector('input[name="methods['+i+'][code]"]');
    const nameInp = lastRow.querySelector('input[name="methods['+i+'][name]"]');
    function syncOption(){
      let code = codeInp.value || 'method_'+i;
      let label = (nameInp.value||'New Method')+' ('+code+')';
      let opt = defSel.querySelector('option[value="'+code+'"]');
      if(!opt){
        opt = document.createElement('option');
        opt.value = code;
        defSel.appendChild(opt);
      }
      opt.textContent = label;
    }
    codeInp.addEventListener('input', syncOption);
    nameInp.addEventListener('input', syncOption);
  }

  function removeRow(btn){
    const tr = btn.closest('tr');
    if(!tr) return;
    const codeInp = tr.querySelector('input[name*="[code]"]');
    if(codeInp && codeInp.value){
      const defSel = document.getElementById('default_payment_method');
      const opt = defSel.querySelector('option[value="'+codeInp.value+'"]');
      opt && opt.remove();
    }
    tr.remove();
  }

  document.getElementById('addRowBtn').addEventListener('click', addRow);
  document.getElementById('addRowBtn2').addEventListener('click', addRow);
  window.removeRow = removeRow;
</script>
@endpush
