{{-- resources/views/settings/invoice.blade.php --}}
@extends('layouts.app')
@section('title','Invoice Settings')

@push('styles')
<style>
  :root { --card:#fff; --border:#e5e7eb; --muted:#6b7280; --text:#111; --active:#1d4ed8; }
  .page-wrap{max-width:1100px;margin:0 auto}
  .card{background:var(--card);border:1px solid var(--border);border-radius:10px;padding:16px;margin-bottom:16px}
  .card h3{margin:0 0 12px;font-size:18px;font-weight:800}
  .grid{display:grid;grid-template-columns:repeat(12,minmax(0,1fr));gap:14px}
  .col-12{grid-column:span 12 / span 12}
  .col-6 {grid-column:span 6 / span 6}
  .col-4 {grid-column:span 4 / span 4}
  .col-3 {grid-column:span 3 / span 3}
  @media (max-width:980px){ .col-6,.col-4,.col-3{grid-column:span 12 / span 12} }

  label{display:block;font-size:13px;font-weight:700;color:var(--muted);margin-bottom:6px}
  .form-control, select, textarea, input[type="number"], input[type="text"]{
    width:100%;border:1px solid var(--border);border-radius:8px;padding:10px 12px;font-size:14px;outline:none;background:#fff
  }
  textarea{min-height:100px;resize:vertical}
  .hint{font-size:12px;color:var(--muted)}
  .rowline{height:1px;background:var(--border);margin:6px 0 2px}
  .switch{display:inline-flex;align-items:center;gap:8px}
  .switch input{width:18px;height:18px}
  .logo-box{display:flex;align-items:center;gap:12px}
  .logo-box img{width:80px;height:80px;object-fit:cover;border:1px solid var(--border);border-radius:6px;background:#fff}
  .actions{display:flex;gap:10px;justify-content:flex-end;margin-top:12px}
  .btn{border:0;border-radius:8px;padding:10px 16px;cursor:pointer;font-weight:700}
  .btn-primary{background:var(--active);color:#fff}
  .btn-secondary{background:#e5e7eb}
  .inline{display:flex;align-items:center;gap:10px}
  .readonly{background:#f8fafc}
</style>
@endpush

@section('content')
@php
  $s = $settings ?? []; // controller থেকে: ['invoice_prefix'=>..., ...]
  $prefix       = old('invoice_prefix',        $s['invoice_prefix'] ?? 'INV-');
  $pad          = old('invoice_pad',           $s['invoice_pad'] ?? 6);
  $next         = old('invoice_next',          $s['invoice_next'] ?? 1);
  $currencyPos  = old('currency_position',     $s['currency_position'] ?? 'left'); // left,left_space,right,right_space
  $dateFormat   = old('date_format',           $s['date_format'] ?? 'd-m-Y');
  $paper        = old('paper_size',            $s['paper_size'] ?? 'A4');
  $orientation  = old('orientation',           $s['orientation'] ?? 'portrait');
  $margin_top   = old('margin_top',            $s['margin_top'] ?? 18);
  $margin_right = old('margin_right',          $s['margin_right'] ?? 12);
  $margin_bottom= old('margin_bottom',         $s['margin_bottom'] ?? 18);
  $margin_left  = old('margin_left',           $s['margin_left'] ?? 12);
  $vat_percent  = old('default_vat',           $s['default_vat'] ?? 0);
  $copies_office= old('copies_office',         $s['copies_office'] ?? 1);
  $copies_customer=old('copies_customer',      $s['copies_customer'] ?? 1);

  $show_logo    = (int) old('show_logo',       $s['show_logo'] ?? 1);
  $show_header  = (int) old('show_header',     $s['show_header'] ?? 1);
  $show_footer  = (int) old('show_footer',     $s['show_footer'] ?? 1);
  $show_qr      = (int) old('show_qr',         $s['show_qr'] ?? 0);
  $show_barcode = (int) old('show_barcode',    $s['show_barcode'] ?? 0);
  $show_sign    = (int) old('show_signature',  $s['show_signature'] ?? 1);
  $show_stamp   = (int) old('show_paid_stamp', $s['show_paid_stamp'] ?? 1);

  $header_note  = old('header_note',           $s['header_note'] ?? '');
  $footer_note  = old('footer_note',           $s['footer_note'] ?? '');
  $terms        = old('terms',                 $s['terms'] ?? '');
  $logo_path    = $s['invoice_logo'] ?? null; // storage path/url
@endphp

<div class="page-wrap">
  <form method="POST" action="{{ route('settings.invoice.save') }}" enctype="multipart/form-data">
    @csrf
    @method('PUT')

    {{-- ========== Numbering & Formats ========== --}}
    <div class="card">
      <h3>Numbering & Formats</h3>
      <div class="grid">
        <div class="col-4">
          <label for="invoice_prefix">Invoice Prefix</label>
          <input type="text" id="invoice_prefix" name="invoice_prefix" class="form-control" value="{{ $prefix }}" placeholder="e.g. INV-">
          <div class="hint">উদাহরণ: <code>INV-</code>, <code>RCPT-</code></div>
        </div>
        <div class="col-4">
          <label for="invoice_pad">Number Padding</label>
          <input type="number" min="1" max="12" id="invoice_pad" name="invoice_pad" class="form-control" value="{{ $pad }}">
          <div class="hint">উদাহরণ: 6 দিলে <code>000123</code></div>
        </div>
        <div class="col-4">
          <label for="invoice_next">Next Number</label>
          <input type="number" min="1" id="invoice_next" name="invoice_next" class="form-control" value="{{ $next }}">
          <div class="hint">পরের ইনভয়েসে যে ক্রমিক শুরু হবে</div>
        </div>

        <div class="col-4">
          <label for="currency_position">Currency Position</label>
          <select id="currency_position" name="currency_position">
            <option value="left"        {{ $currencyPos==='left' ? 'selected':'' }}>৳123 (Left)</option>
            <option value="left_space"  {{ $currencyPos==='left_space' ? 'selected':'' }}>৳ 123 (Left + Space)</option>
            <option value="right"       {{ $currencyPos==='right' ? 'selected':'' }}>123৳ (Right)</option>
            <option value="right_space" {{ $currencyPos==='right_space' ? 'selected':'' }}>123 ৳ (Right + Space)</option>
          </select>
        </div>

        <div class="col-4">
          <label for="date_format">Date Format</label>
          <select id="date_format" name="date_format">
            @foreach(['d-m-Y','d/m/Y','Y-m-d','M d, Y','d M Y'] as $fmt)
              <option value="{{ $fmt }}" {{ $dateFormat===$fmt?'selected':'' }}>{{ $fmt }}</option>
            @endforeach
          </select>
          <div class="hint">উদাহরণ: {{ now()->format($dateFormat) }}</div>
        </div>

        <div class="col-4">
          <label for="default_vat">Default VAT (%)</label>
          <input type="number" step="0.01" id="default_vat" name="default_vat" class="form-control" value="{{ $vat_percent }}">
        </div>

        <div class="col-12 inline">
          <span class="hint">Sample next code:</span>
          <code id="sample_code" style="font-weight:700"></code>
        </div>
      </div>
    </div>

    {{-- ========== Visuals (Logo/Header/Footer) ========== --}}
    <div class="card">
      <h3>Visuals</h3>
      <div class="grid">
        <div class="col-6">
          <label>Invoice Logo</label>
          <div class="logo-box">
            <img id="logoPreview" src="{{ $logo_path ? asset($logo_path) : 'https://via.placeholder.com/80x80?text=Logo' }}" alt="logo">
            <div>
              <input type="file" name="invoice_logo" accept="image/*" onchange="previewLogo(this)">
              <div class="hint">PNG/JPG, suggested: transparent PNG</div>
            </div>
          </div>
        </div>

        <div class="col-3">
          <label class="switch"><input type="checkbox" name="show_logo" value="1" {{ $show_logo ? 'checked':'' }}> Show Logo</label>
          <div class="rowline"></div>
          <label class="switch"><input type="checkbox" name="show_header" value="1" {{ $show_header ? 'checked':'' }}> Show Header</label>
          <div class="rowline"></div>
          <label class="switch"><input type="checkbox" name="show_footer" value="1" {{ $show_footer ? 'checked':'' }}> Show Footer</label>
        </div>

        <div class="col-3">
          <label class="switch"><input type="checkbox" name="show_qr" value="1" {{ $show_qr ? 'checked':'' }}> Show QR</label>
          <div class="rowline"></div>
          <label class="switch"><input type="checkbox" name="show_barcode" value="1" {{ $show_barcode ? 'checked':'' }}> Show Barcode</label>
          <div class="rowline"></div>
          <label class="switch"><input type="checkbox" name="show_signature" value="1" {{ $show_sign ? 'checked':'' }}> Show Signature</label>
          <div class="rowline"></div>
          <label class="switch"><input type="checkbox" name="show_paid_stamp" value="1" {{ $show_stamp ? 'checked':'' }}> Show PAID Stamp</label>
        </div>

        <div class="col-12">
          <label for="header_note">Header Note (optional)</label>
          <textarea id="header_note" name="header_note">{{ $header_note }}</textarea>
        </div>
        <div class="col-12">
          <label for="footer_note">Footer Note (optional)</label>
          <textarea id="footer_note" name="footer_note">{{ $footer_note }}</textarea>
        </div>
        <div class="col-12">
          <label for="terms">Terms & Conditions</label>
          <textarea id="terms" name="terms">{{ $terms }}</textarea>
        </div>
      </div>
    </div>

    {{-- ========== Paper & Margins ========== --}}
    <div class="card">
      <h3>Paper & Margins</h3>
      <div class="grid">
        <div class="col-3">
          <label for="paper_size">Paper Size</label>
          <select id="paper_size" name="paper_size">
            <option value="A4"  {{ $paper==='A4' ? 'selected':'' }}>A4</option>
            <option value="A5"  {{ $paper==='A5' ? 'selected':'' }}>A5</option>
            <option value="POS80" {{ $paper==='POS80' ? 'selected':'' }}>POS 80mm</option>
          </select>
        </div>
        <div class="col-3">
          <label for="orientation">Orientation</label>
          <select id="orientation" name="orientation">
            <option value="portrait"  {{ $orientation==='portrait' ? 'selected':'' }}>Portrait</option>
            <option value="landscape" {{ $orientation==='landscape' ? 'selected':'' }}>Landscape</option>
          </select>
        </div>

        <div class="col-2">
          <label for="margin_top">Top (mm)</label>
          <input type="number" id="margin_top" name="margin_top" class="form-control" value="{{ $margin_top }}">
        </div>
        <div class="col-2">
          <label for="margin_right">Right (mm)</label>
          <input type="number" id="margin_right" name="margin_right" class="form-control" value="{{ $margin_right }}">
        </div>
        <div class="col-2">
          <label for="margin_bottom">Bottom (mm)</label>
          <input type="number" id="margin_bottom" name="margin_bottom" class="form-control" value="{{ $margin_bottom }}">
        </div>
        <div class="col-2">
          <label for="margin_left">Left (mm)</label>
          <input type="number" id="margin_left" name="margin_left" class="form-control" value="{{ $margin_left }}">
        </div>
      </div>
    </div>

    {{-- ========== Copies / Print behavior ========== --}}
    <div class="card">
      <h3>Copies & Printing</h3>
      <div class="grid">
        <div class="col-3">
          <label for="copies_office">Office Copies</label>
          <input type="number" min="0" id="copies_office" name="copies_office" class="form-control" value="{{ $copies_office }}">
        </div>
        <div class="col-3">
          <label for="copies_customer">Customer Copies</label>
          <input type="number" min="0" id="copies_customer" name="copies_customer" class="form-control" value="{{ $copies_customer }}">
        </div>
        <div class="col-6" style="display:flex;align-items:flex-end">
          <div class="hint">Note: Many browsers ignore “copies” for security. Use print dialog presets or thermal drivers for POS.</div>
        </div>
      </div>
    </div>

    <div class="actions">
      <button type="reset" class="btn btn-secondary">Reset</button>
      <button type="submit" class="btn btn-primary">Save Changes</button>
    </div>
  </form>
</div>
@endsection

@push('scripts')
<script>
  const prefix = document.getElementById('invoice_prefix');
  const pad    = document.getElementById('invoice_pad');
  const next   = document.getElementById('invoice_next');
  const sample = document.getElementById('sample_code');

  function updateSample(){
    const p = prefix.value || '';
    const n = String(Math.max(1, parseInt(next.value||1))).padStart(Math.max(1, parseInt(pad.value||1)), '0');
    sample.textContent = p + n;
  }
  ['input','change'].forEach(evt=>{
    prefix.addEventListener(evt, updateSample);
    pad.addEventListener(evt, updateSample);
    next.addEventListener(evt, updateSample);
  });
  updateSample();

  function previewLogo(input){
    if(!input.files || !input.files[0]) return;
    const reader = new FileReader();
    reader.onload = e => document.getElementById('logoPreview').src = e.target.result;
    reader.readAsDataURL(input.files[0]);
  }
  window.previewLogo = previewLogo;
</script>
@endpush
