@extends('layouts.app')
@section('title','Currencies')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111}
  .wrap{max-width:1200px;margin:0 auto}
  .panel{background:var(--card);border:1px solid var(--border);border-radius:10px;padding:16px;margin-bottom:16px}
  .panel h3{margin:0 0 12px;font-size:16px;font-weight:800;color:var(--text)}
  .actions{display:flex;gap:8px;justify-content:flex-end}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:#1d4ed8;color:#fff}
  .btn-ghost{background:#f3f4f6}
  .muted{color:var(--muted)}
  table.cur{width:100%;border-collapse:separate;border-spacing:0 8px}
  table.cur thead th{font-size:12px;text-transform:uppercase;color:var(--muted);text-align:left}
  table.cur tbody tr{background:#fff;border:1px solid var(--border)}
  table.cur tbody tr td{padding:8px}
  table.cur input[type="text"],
  table.cur input[type="number"],
  table.cur select{
    width:100%;padding:8px;border:1px solid var(--border);border-radius:8px;background:#fff
  }
  .w-10{width:2.5rem} .w-14{width:3.5rem} .w-18{width:4.5rem}
  .sticky-actions{position:sticky;bottom:0;background:#fff;border:1px solid var(--border);border-radius:10px;padding:10px}
</style>
@endpush

@section('content')
@php
  $raw = $settings['currencies'] ?? null;
  $currs = is_string($raw) ? json_decode($raw, true) : (is_array($raw) ? $raw : null);

  if (!$currs || !is_array($currs) || !count($currs)) {
      // Fallback defaults
      $currs = [
        ['active'=>1,'name'=>'Bangladeshi Taka','code'=>'BDT','symbol'=>'৳','position'=>'left','decimals'=>2,'thousand_sep'=>',','decimal_sep'=>'.','rate'=>1,'order'=>1,'notes'=>null],
        ['active'=>1,'name'=>'US Dollar','code'=>'USD','symbol'=>'$','position'=>'left','decimals'=>2,'thousand_sep'=>',','decimal_sep'=>'.','rate'=>0.0091,'order'=>2,'notes'=>null],
        ['active'=>1,'name'=>'Indian Rupee','code'=>'INR','symbol'=>'₹','position'=>'left','decimals'=>2,'thousand_sep'=>',','decimal_sep'=>'.','rate'=>0.76,'order'=>3,'notes'=>null],
      ];
  }
  $default = $settings['default_currency'] ?? 'BDT';
@endphp

<div class="wrap">

  <div class="panel" style="display:flex;align-items:center;justify-content:space-between;">
    <h3><i class="fa-solid fa-coins"></i> Currency Settings</h3>
    <div class="actions">
      <button type="button" id="addRowBtn" class="btn btn-ghost"><i class="fa-solid fa-plus"></i> Add Currency</button>
      <button form="curForm" class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save Settings</button>
    </div>
  </div>

  <form id="curForm" action="{{ route('settings.currencies.save') }}" method="POST">
    @csrf @method('PUT')

    <div class="panel">
      <h3>General</h3>
      <div style="display:grid;grid-template-columns:260px 1fr;gap:10px;align-items:center">
        <label for="default_currency" class="fw-600">Default (Base) Currency</label>
        <select name="default_currency" id="default_currency">
          @foreach($currs as $c)
            <option value="{{ $c['code'] }}" {{ $default===$c['code']?'selected':'' }}>
              {{ $c['name'] }} ({{ $c['code'] }})
            </option>
          @endforeach
        </select>
      </div>
      <div class="muted" style="margin-top:8px">
        ডিফল্ট মুদ্রা **Base** ধরা হবে (Rate = 1). অন্যগুলোর `Rate` হবে Base মুদ্রার বিপরীতে।
      </div>
    </div>

    <div class="panel">
      <h3>Currencies</h3>

      <table class="cur" id="curTable">
        <thead>
          <tr>
            <th>Active</th>
            <th>Name</th>
            <th>Code</th>
            <th>Symbol</th>
            <th>Position</th>
            <th>Decimals</th>
            <th>Thousand</th>
            <th>Decimal</th>
            <th>Rate vs Base</th>
            <th>Order</th>
            <th>Notes</th>
            <th>Del</th>
          </tr>
        </thead>
        <tbody id="curBody">
          @foreach($currs as $i => $c)
          <tr data-row>
            <td style="text-align:center">
              <input type="hidden" name="currencies[{{ $i }}][active]" value="0">
              <input type="checkbox" name="currencies[{{ $i }}][active]" value="1" {{ !empty($c['active'])?'checked':'' }}>
            </td>
            <td><input type="text" name="currencies[{{ $i }}][name]" value="{{ $c['name'] }}" placeholder="e.g. Bangladeshi Taka"></td>
            <td><input type="text" name="currencies[{{ $i }}][code]" value="{{ $c['code'] }}" maxlength="3" class="w-14" style="text-transform:uppercase" oninput="this.value=this.value.toUpperCase()"></td>
            <td><input type="text" name="currencies[{{ $i }}][symbol]" value="{{ $c['symbol'] }}" class="w-14"></td>
            <td>
              <select name="currencies[{{ $i }}][position]">
                @php $pos=['left'=>'Left','left_space'=>'Left + Space','right'=>'Right','right_space'=>'Right + Space']; @endphp
                @foreach($pos as $pv=>$pl)
                  <option value="{{ $pv }}" {{ ($c['position']??'left')===$pv?'selected':'' }}>{{ $pl }}</option>
                @endforeach
              </select>
            </td>
            <td><input type="number" name="currencies[{{ $i }}][decimals]" class="w-10" min="0" max="4" value="{{ $c['decimals'] ?? 2 }}"></td>
            <td>
              <select name="currencies[{{ $i }}][thousand_sep]" class="w-14">
                @php $ths=[','=>',','.'=>'.',' '=>'Space','_'=>'_','none'=>'None']; @endphp
                @foreach($ths as $tv=>$tl)
                  <option value="{{ $tv }}" {{ ($c['thousand_sep']??',')===$tv?'selected':'' }}>{{ $tl }}</option>
                @endforeach
              </select>
            </td>
            <td>
              <select name="currencies[{{ $i }}][decimal_sep]" class="w-14">
                <option value="." {{ ($c['decimal_sep']??'.')==='.'?'selected':'' }}>.</option>
                <option value="," {{ ($c['decimal_sep']??'.')===','?'selected':'' }}>,</option>
              </select>
            </td>
            <td><input type="number" step="0.000001" min="0" name="currencies[{{ $i }}][rate]" value="{{ $c['rate'] ?? 1 }}" class="w-18"></td>
            <td><input type="number" name="currencies[{{ $i }}][order]" value="{{ $c['order'] ?? ($i+1) }}" class="w-14"></td>
            <td><input type="text" name="currencies[{{ $i }}][notes]" value="{{ $c['notes'] ?? '' }}"></td>
            <td style="text-align:center">
              <button type="button" class="btn btn-ghost" onclick="removeRow(this)" title="Delete">
                <i class="fa-regular fa-trash-can"></i>
              </button>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>

      <div class="sticky-actions actions" style="margin-top:12px">
        <button type="button" id="addRowBtn2" class="btn btn-ghost"><i class="fa-solid fa-plus"></i> Add Currency</button>
        <button class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Save Settings</button>
      </div>

      <div class="muted" style="margin-top:10px">
        <b>Preview logic:</b> শো করার সময় আপনার ফরম্যাটার (symbol+position+separators+decimals) ব্যবহার করবেন। Base currency-র rate সবসময় 1.00।
      </div>
    </div>
  </form>
</div>

{{-- Template row --}}
<template id="curRowTmpl">
<tr data-row>
  <td style="text-align:center">
    <input type="hidden" name="__N__[active]" value="0">
    <input type="checkbox" name="__N__[active]" value="1" checked>
  </td>
  <td><input type="text" name="__N__[name]" placeholder="Currency Name"></td>
  <td><input type="text" name="__N__[code]" maxlength="3" class="w-14" style="text-transform:uppercase" oninput="this.value=this.value.toUpperCase()"></td>
  <td><input type="text" name="__N__[symbol]" class="w-14" placeholder="৳ $ ₹ €"></td>
  <td>
    <select name="__N__[position]">
      <option value="left">Left</option>
      <option value="left_space">Left + Space</option>
      <option value="right">Right</option>
      <option value="right_space">Right + Space</option>
    </select>
  </td>
  <td><input type="number" name="__N__[decimals]" class="w-10" min="0" max="4" value="2"></td>
  <td>
    <select name="__N__[thousand_sep]" class="w-14">
      <option value="," selected>,</option>
      <option value=".">.</option>
      <option value=" ">Space</option>
      <option value="_">_</option>
      <option value="none">None</option>
    </select>
  </td>
  <td>
    <select name="__N__[decimal_sep]" class="w-14">
      <option value="." selected>.</option>
      <option value=",">,</option>
    </select>
  </td>
  <td><input type="number" step="0.000001" min="0" name="__N__[rate]" value="1" class="w-18"></td>
  <td><input type="number" name="__N__[order]" value="1" class="w-14"></td>
  <td><input type="text" name="__N__[notes]" placeholder="optional"></td>
  <td style="text-align:center">
    <button type="button" class="btn btn-ghost" onclick="removeRow(this)" title="Delete">
      <i class="fa-regular fa-trash-can"></i>
    </button>
  </td>
</tr>
</template>
@endsection

@push('scripts')
<script>
  const bodyEl = document.getElementById('curBody');
  const tmpl    = document.getElementById('curRowTmpl').innerHTML;
  const defSel  = document.getElementById('default_currency');

  function nextIndex(){
    return bodyEl.querySelectorAll('[data-row]').length;
  }

  function addRow(){
    const i = nextIndex();
    const html = tmpl.replaceAll('__N__', `currencies[${i}]`);
    bodyEl.insertAdjacentHTML('beforeend', html);

    // keep default select updated when code/name changes
    const row   = bodyEl.querySelectorAll('tr[data-row]')[i];
    const codeI = row.querySelector(`input[name="currencies[${i}][code]"]`);
    const nameI = row.querySelector(`input[name="currencies[${i}][name]"]`);

    function syncOption(){
      const code = (codeI.value||'CUR').toUpperCase();
      let opt = defSel.querySelector(`option[value="${code}"]`);
      const label = (nameI.value||'Currency') + ' ('+code+')';
      if(!opt){
        opt = document.createElement('option');
        opt.value = code;
        defSel.appendChild(opt);
      }
      opt.textContent = label;
    }
    codeI.addEventListener('input', syncOption);
    nameI.addEventListener('input', syncOption);
  }

  function removeRow(btn){
    const tr = btn.closest('tr');
    if(!tr) return;
    const codeI = tr.querySelector('input[name*="[code]"]');
    if(codeI && codeI.value){
      const opt = defSel.querySelector(`option[value="${codeI.value}"]`);
      opt && opt.remove();
    }
    tr.remove();
  }

  document.getElementById('addRowBtn').addEventListener('click', addRow);
  document.getElementById('addRowBtn2').addEventListener('click', addRow);
  window.removeRow = removeRow;
</script>
@endpush
