@extends('layouts.app')

@section('title','Business Settings')

@push('styles')
<style>
  :root{ --card:#fff; --border:#e5e7eb; --muted:#6b7280; --text:#111; --brand:#d4482d; }

  .wrap{display:grid; gap:16px;}
  .panel{background:var(--card); border:1px solid var(--border); border-radius:10px; padding:16px;}
  .panel h3{margin:0 0 12px; font-size:16px; font-weight:800; color:var(--text)}
  .grid{display:grid; gap:12px; grid-template-columns:repeat(12, minmax(0, 1fr))}
  .col-6{grid-column:span 6 / span 6}
  .col-4{grid-column:span 4 / span 4}
  .col-8{grid-column:span 8 / span 8}
  .col-12{grid-column:span 12 / span 12}
  @media (max-width: 900px){
    .col-6,.col-4,.col-8{grid-column:span 12 / span 12}
  }

  label{display:block; font-size:12px; color:var(--muted); margin-bottom:6px; font-weight:600}
  input[type="text"], input[type="email"], input[type="url"], input[type="tel"], input[type="date"], select, textarea{
    width:100%; border:1px solid var(--border); border-radius:8px; padding:10px 12px; font-size:14px; outline:none
  }
  textarea{min-height:96px; resize:vertical}

  .row{display:flex; gap:12px; align-items:center}
  .help{font-size:12px; color:var(--muted)}

  .actions{display:flex; gap:10px; justify-content:flex-end; margin-top:10px}
  .btn{border:0; border-radius:8px; padding:10px 16px; font-weight:700; cursor:pointer}
  .btn-primary{background:#1d4ed8; color:#fff}
  .btn-light{background:#f3f4f6}

  .logo-uploader{display:flex; gap:16px; align-items:center}
  .logo-preview{width:84px; height:84px; border:1px dashed var(--border); border-radius:10px; display:flex; align-items:center; justify-content:center; overflow:hidden; background:#fafafa}
  .logo-preview img{width:100%; height:100%; object-fit:contain}
  .switch{position:relative; width:46px; height:26px; background:#e5e7eb; border-radius:999px; cursor:pointer}
  .switch input{display:none}
  .knob{position:absolute; top:3px; left:3px; width:20px; height:20px; background:#fff; border-radius:999px; transition:all .18s ease}
  .switch input:checked + .knob{left:23px; background:#fff}
  .switch input:checked ~ .track{background:#22c55e}
  .track{position:absolute; inset:0; border-radius:999px; background:#e5e7eb; z-index:-1}
  .flash{background:#ecfdf5; border:1px solid #bbf7d0; color:#065f46; padding:10px 12px; border-radius:8px; margin-bottom:12px}
  .errors{background:#fef2f2; border:1px solid #fecaca; color:#991b1b; padding:10px 12px; border-radius:8px; margin-bottom:12px}
</style>
@endpush

@section('content')
<div class="wrap">

  {{-- Flash / Errors --}}
  @if (session('status'))
    <div class="flash">{{ session('status') }}</div>
  @endif

  @if ($errors->any())
    <div class="errors">
      <strong>Validation errors:</strong>
      <ul style="margin:6px 0 0 18px">
        @foreach ($errors->all() as $e)
          <li>{{ $e }}</li>
        @endforeach
      </ul>
    </div>
  @endif

  <form method="POST" action="{{ url()->current() }}" enctype="multipart/form-data">
    @csrf
    {{-- If you wire a PUT route later, just add: @method('PUT') --}}

    {{-- Business profile --}}
    <div class="panel">
      <h3>Business Profile</h3>
      <div class="grid">
        <div class="col-6">
          <label for="name">Business Name</label>
          <input id="name" name="name" type="text"
                 value="{{ old('name', $settings['name'] ?? '') }}"
                 placeholder="e.g. Messrs Auto Rice Mill" required>
        </div>
        <div class="col-6">
          <label for="legal_name">Legal / Trade Name</label>
          <input id="legal_name" name="legal_name" type="text"
                 value="{{ old('legal_name', $settings['legal_name'] ?? '') }}"
                 placeholder="(optional)">
        </div>

        <div class="col-12">
          <label for="address">Address</label>
          <textarea id="address" name="address" placeholder="Street, Area, City, Zip, Country">{{ old('address', $settings['address'] ?? '') }}</textarea>
        </div>

        <div class="col-4">
          <label for="phone">Phone</label>
          <input id="phone" name="phone" type="tel" value="{{ old('phone', $settings['phone'] ?? '') }}" placeholder="+8801XXXXXXXXX">
        </div>
        <div class="col-4">
          <label for="email">Email</label>
          <input id="email" name="email" type="email" value="{{ old('email', $settings['email'] ?? '') }}" placeholder="info@domain.com">
        </div>
        <div class="col-4">
          <label for="website">Website</label>
          <input id="website" name="website" type="url" value="{{ old('website', $settings['website'] ?? '') }}" placeholder="https://…">
        </div>
      </div>
    </div>

    {{-- Localization --}}
    <div class="panel">
      <h3>Localization</h3>
      <div class="grid">
        <div class="col-4">
          <label for="currency">Currency</label>
          <select id="currency" name="currency">
            @php $curr = old('currency', $settings['currency'] ?? 'BDT'); @endphp
            <option value="BDT" {{ $curr==='BDT' ? 'selected':'' }}>Bangladeshi Taka (BDT)</option>
            <option value="USD" {{ $curr==='USD' ? 'selected':'' }}>US Dollar (USD)</option>
            <option value="INR" {{ $curr==='INR' ? 'selected':'' }}>Indian Rupee (INR)</option>
            <option value="EUR" {{ $curr==='EUR' ? 'selected':'' }}>Euro (EUR)</option>
          </select>
        </div>
        <div class="col-4">
          <label for="timezone">Time Zone</label>
          <select id="timezone" name="timezone">
            @php $tz = old('timezone', $settings['timezone'] ?? 'Asia/Dhaka'); @endphp
            @foreach (['Asia/Dhaka','Asia/Kolkata','UTC','Europe/London','America/New_York'] as $z)
              <option value="{{ $z }}" {{ $tz===$z ? 'selected':'' }}>{{ $z }}</option>
            @endforeach
          </select>
        </div>
        <div class="col-4">
          <label for="date_format">Date Format</label>
          @php $df = old('date_format', $settings['date_format'] ?? 'd-m-Y'); @endphp
          <select id="date_format" name="date_format">
            <option value="d-m-Y" {{ $df==='d-m-Y' ? 'selected':'' }}>DD-MM-YYYY</option>
            <option value="m/d/Y" {{ $df==='m/d/Y' ? 'selected':'' }}>MM/DD/YYYY</option>
            <option value="Y-m-d" {{ $df==='Y-m-d' ? 'selected':'' }}>YYYY-MM-DD</option>
          </select>
        </div>
        <div class="col-4">
          <label for="fy_start">Financial Year Start</label>
          <input id="fy_start" name="fy_start" type="date" value="{{ old('fy_start', $settings['fy_start'] ?? '') }}">
        </div>
        <div class="col-4">
          <label for="locale">Language (Locale)</label>
          @php $lc = old('locale', $settings['locale'] ?? 'bn'); @endphp
          <select id="locale" name="locale">
            <option value="bn" {{ $lc==='bn' ? 'selected':'' }}>Bangla (bn)</option>
            <option value="en" {{ $lc==='en' ? 'selected':'' }}>English (en)</option>
          </select>
        </div>
        <div class="col-4">
          <label for="number_format">Number Format</label>
          @php $nf = old('number_format', $settings['number_format'] ?? '1,23,456.78'); @endphp
          <select id="number_format" name="number_format">
            <option value="1,23,456.78" {{ $nf==='1,23,456.78' ? 'selected':'' }}>Bangla (লাখ/কোটি) — 1,23,456.78</option>
            <option value="1,234,567.89" {{ $nf==='1,234,567.89' ? 'selected':'' }}>International (1,234,567.89)</option>
          </select>
        </div>
      </div>
    </div>

    {{-- Tax & Finance --}}
    <div class="panel">
      <h3>Tax & Finance</h3>
      <div class="grid">
        <div class="col-6">
          <label for="tax_id">Tax / BIN / VAT No.</label>
          <input id="tax_id" name="tax_id" type="text" value="{{ old('tax_id', $settings['tax_id'] ?? '') }}" placeholder="e.g. BIN-XXXXXXXXXX">
        </div>
        <div class="col-6">
          <label for="tax_rate">Default Tax Rate (%)</label>
          <input id="tax_rate" name="tax_rate" type="text" value="{{ old('tax_rate', $settings['tax_rate'] ?? '') }}" placeholder="e.g. 15">
          <div class="help">Used as default on invoices unless overridden.</div>
        </div>
      </div>
    </div>

    {{-- Branding & Printing --}}
    <div class="panel">
      <h3>Branding & Print</h3>
      <div class="grid">
        <div class="col-8">
          <label>Logo</label>
          <div class="logo-uploader">
            <div class="logo-preview" id="logoPreview">
              @if (!empty($settings['logo_url']))
                <img src="{{ $settings['logo_url'] }}" alt="Logo">
              @else
                <span class="help">84×84</span>
              @endif
            </div>
            <div>
              <input type="file" name="logo" id="logoInput" accept="image/*">
              <div class="help">PNG/JPG, recommended ≥ 200×200.</div>
            </div>
          </div>
        </div>

        <div class="col-4">
          <label>Show Header on Print</label>
          @php $showHeader = (bool) old('print_header', $settings['print_header'] ?? true); @endphp
          <label class="switch">
            <input type="checkbox" name="print_header" value="1" {{ $showHeader ? 'checked':'' }}>
            <span class="knob"></span><span class="track"></span>
          </label>
        </div>

        <div class="col-4">
          <label>Show Footer on Print</label>
          @php $showFooter = (bool) old('print_footer', $settings['print_footer'] ?? true); @endphp
          <label class="switch">
            <input type="checkbox" name="print_footer" value="1" {{ $showFooter ? 'checked':'' }}>
            <span class="knob"></span><span class="track"></span>
          </label>
        </div>

        <div class="col-12">
          <label for="print_footer_text">Footer Text (Invoice/Report)</label>
          <input id="print_footer_text" name="print_footer_text" type="text"
                 value="{{ old('print_footer_text', $settings['print_footer_text'] ?? 'Developed By: Core4 Billings Technologies Ltd') }}">
        </div>
      </div>
    </div>

    {{-- Actions --}}
    <div class="actions">
      <button type="reset" class="btn btn-light">Reset</button>
      <button type="submit" class="btn btn-primary">Save Settings</button>
    </div>
  </form>
</div>
@endsection

@push('scripts')
<script>
  // Live logo preview
  const input = document.getElementById('logoInput');
  const preview = document.getElementById('logoPreview');
  input?.addEventListener('change', e=>{
    const file = e.target.files?.[0];
    if(!file) return;
    const url = URL.createObjectURL(file);
    preview.innerHTML = '';
    const img = new Image();
    img.onload = ()=> URL.revokeObjectURL(url);
    img.src = url;
    preview.appendChild(img);
  });
</script>
@endpush

