﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">
  <div class="sd-wrap">

    {{-- header --}}
    <div class="sd-head">
      <div class="sd-title"><i class="fas fa-list-ul me-2"></i> Sale Delivery List</div>
      <a href="{{ route('sales_delivery.create') }}" class="sd-add">
        <i class="fas fa-plus me-1"></i> Add Delivery
      </a>
    </div>

    {{-- FILTER BAR – 1 row, 5 blocks --}}
    <form method="GET" class="sd-bar">
      {{-- Company --}}
      <div class="sd-block">
        <div class="sd-lab">Company</div>
        <select name="company_id" class="sd-inp">
          <option value="">- Company Name -</option>
          @foreach($companies ?? [] as $c)
            <option value="{{ $c->id }}" @selected(request('company_id')==$c->id)>{{ $c->name }}</option>
          @endforeach
        </select>
      </div>

      {{-- Customer --}}
      <div class="sd-block">
        <div class="sd-lab">Customer</div>
        <select name="customer_id" class="sd-inp">
          <option value="">- Select Customer -</option>
          @foreach($customers ?? [] as $x)
            <option value="{{ $x->id }}" @selected(request('customer_id')==$x->id)>{{ $x->name }}</option>
          @endforeach
        </select>
      </div>

      {{-- Challan --}}
      <div class="sd-block">
        <div class="sd-lab">Challan Number</div>
        <input type="text" name="challan" value="{{ request('challan') }}" class="sd-inp" placeholder="Search by Challan No">
      </div>

      {{-- Dates --}}
      <div class="sd-block sd-dates">
        <div class="sd-lab">Filter by Date</div>
        <div class="sd-datewrap">
          <div class="sd-date">
            <span class="sd-ico"><i class="far fa-calendar"></i></span>
            <input type="date" name="from" value="{{ request('from') }}" class="sd-inp">
          </div>
          <div class="sd-date">
            <span class="sd-ico"><i class="fas fa-exchange-alt"></i></span>
            <input type="date" name="to" value="{{ request('to') }}" class="sd-inp">
          </div>
        </div>
      </div>

      {{-- Action (right) --}}
      <div class="sd-block sd-action">
        <div class="sd-lab">Action</div>
        <div class="sd-btns">
          <button class="sd-btn sd-btn-primary" type="submit">
            <i class="fas fa-search me-1"></i> Search
          </button>
          <a href="{{ route('sales_delivery.index') }}" class="sd-btn sd-btn-light" title="Refresh">
            <i class="fas fa-sync-alt"></i>
          </a>
        </div>
      </div>
    </form>

    {{-- right small search text box (dummy) --}}
    <div class="sd-mini-search">
      <span>Search:</span>
      <input class="sd-inp sd-inp-sm" type="text" />
    </div>

    {{-- TABLE --}}
    <div class="sd-tablewrap">
      <table class="sd-table">
        <thead>
          <tr>
            <th style="width:44px;">SL</th>
            <th style="width:120px;">Challan No</th>
            <th>Company</th>
            <th style="width:140px;">Customer Name</th>
            <th style="width:95px;">Date</th>
            <th>Delivery Address</th>
            <th style="width:110px;">Driver Name</th>
            <th style="width:120px;">Driver Phone</th>
            <th style="width:85px;">Vehicle No.</th>
            <th style="width:80px;">Cho No.</th>
            <th style="width:70px;">Total Bag</th>
            <th style="width:80px;">Total Kg</th>
            <th style="width:110px;">Total Amount</th>
            <th style="width:140px;">Action</th>
          </tr>
        </thead>
        <tbody>
          @forelse($deliveries as $i => $d)
            <tr>
              <td>{{ $deliveries->firstItem() + $i }}</td>
              <td>{{ $d->challan_no }}</td>
              <td>{{ $d->company->name ?? '' }}</td>
              <td>{{ $d->customer->name ?? '' }}</td>
              <td>{{ optional($d->delivered_at ?: $d->date)->format('Y-m-d') }}</td>
              <td>{{ $d->delivery_address }}</td>
              <td>{{ $d->driver_name }}</td>
              <td>{{ $d->driver_phone }}</td>
              <td>{{ $d->vehicle_no }}</td>
              <td>{{ $d->cho_no }}</td>
              <td class="text-end">{{ number_format($d->total_bag,2) }}</td>
              <td class="text-end">{{ number_format($d->total_kg,2) }}</td>
              <td class="text-end">{{ number_format($d->total_amount,0) }}</td>
              <td class="sd-actions">
                <a href="#" class="sd-ic sd-blue"   title="View"><i class="fas fa-eye"></i></a>
                <a href="#" class="sd-ic sd-cyan"   title="Edit"><i class="fas fa-edit"></i></a>
                <a href="#" class="sd-ic sd-amber"  title="Print"><i class="fas fa-print"></i></a>
                <a href="#" class="sd-ic sd-gray"   title="PDF"><i class="far fa-file-pdf"></i></a>
                <a href="#" class="sd-ic sd-green"  title="Bag"><i class="fas fa-briefcase"></i></a>
                <form action="#" method="POST" class="d-inline">@csrf @method('DELETE')
                  <button class="sd-ic sd-red" title="Delete" onclick="return confirm('Delete?')">
                    <i class="fas fa-trash"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr><td colspan="14" class="sd-empty">No delivery found.</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- pagination --}}
    <div class="sd-pag">
      {{ $deliveries->withQueryString()->links() }}
    </div>

    {{-- bottom export icons left --}}
    <div class="sd-export">
      <button type="button" class="sd-excel">X</button>
      <button type="button" class="sd-pdf">P</button>
    </div>

  </div>
</div>
@endsection

@push('styles')
<style>
/* --- skeleton & colors --- */
:root{
  --bdr:#d7dce3; --hdr:#eef3f9; --ink:#2e3d4f; --mut:#6d7a86;
  --primary:#2d7bd3; --light:#f4f7fb;
}
.sd-wrap{background:#fff;border:1px solid var(--bdr)}
.sd-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid var(--bdr);background:#f5f8fc}
.sd-title{font-weight:700;color:#2f537a;font-size:18px}
.sd-add{padding:6px 10px;border:1px solid #cfe0f6;background:#e9f1fe;color:#2463aa;text-decoration:none;border-radius:2px;font-weight:600}

/* --- filter bar --- */
.sd-bar{
  display:grid;
  grid-template-columns: 1.25fr 1.25fr 1.25fr 1.6fr auto; /* EXACT 5 blocks in one row */
  gap:10px; padding:10px 12px; border-bottom:1px solid var(--bdr);
}
.sd-block{display:flex;flex-direction:column}
.sd-lab{font-size:12px;color:var(--mut);margin-bottom:4px}
.sd-inp{height:34px;border:1px solid var(--bdr);border-radius:2px;padding:6px 8px;font-size:14px}
.sd-dates .sd-datewrap{display:flex;gap:8px}
.sd-date{display:flex;align-items:center;border:1px solid var(--bdr);border-radius:2px;background:#fff}
.sd-date .sd-ico{padding:0 8px;color:#7a8a99}
.sd-date input{border:0;height:32px;padding:0 6px;font-size:14px;min-width:150px}
.sd-action .sd-btns{display:flex;gap:8px}
.sd-btn{height:34px;border-radius:2px;border:1px solid var(--bdr);background:#fff;color:#234;display:inline-flex;align-items:center;padding:0 10px;text-decoration:none}
.sd-btn-primary{background:#2d7bd3;border-color:#2466b1;color:#fff}
.sd-btn-light{background:#f3f6fa}

/* mini search right */
.sd-mini-search{display:flex;justify-content:flex-end;align-items:center;padding:8px 12px;gap:8px}
.sd-mini-search span{color:#6e7b87;font-size:13px}
.sd-inp-sm{height:28px;width:240px}

/* table */
.sd-tablewrap{padding:0 12px 12px}
.sd-table{width:100%;border:1px solid var(--bdr);border-collapse:separate;border-spacing:0}
.sd-table thead th{background:var(--hdr);border-bottom:1px solid var(--bdr);padding:8px 10px;color:#344;font-weight:700;vertical-align:middle;text-align:left}
.sd-table tbody td{border-top:1px solid #edf1f5;padding:8px 10px;vertical-align:middle}
.sd-empty{padding:16px;text-align:center;color:#7a8694}
.text-end{text-align:right}

/* action icons */
.sd-actions form{display:inline}
.sd-ic{width:26px;height:26px;border:1px solid var(--bdr);border-radius:2px;background:#fff;display:inline-flex;align-items:center;justify-content:center;margin-right:6px;cursor:pointer}
.sd-ic i{font-size:12px}
.sd-blue{color:#0b77d5} .sd-cyan{color:#17a2b8}
.sd-amber{color:#e09a00} .sd-gray{color:#667085}
.sd-green{color:#198754} .sd-red{color:#dc3545;background:#fff}

/* pagination container */
.sd-pag{display:flex;justify-content:end;padding:6px 12px}

/* export icons (bottom-left) */
.sd-export{padding:6px 12px}
.sd-export .sd-excel,.sd-export .sd-pdf{width:28px;height:22px;border:1px solid var(--bdr);background:#f3f6fa;margin-right:6px;font-weight:700;font-size:12px}

/* responsive: keep single row till 1200px, then stack if smaller */
@media (max-width:1199.98px){
  .sd-bar{grid-template-columns: 1fr 1fr}
  .sd-action{order:5}
}
</style>
@endpush

