﻿{{-- resources/views/delivery-sale/create.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="ds-wrap">

  {{-- Header --}}
  <div class="ds-head">
    <div class="ds-title">
      <span class="ds-plus">+</span>
      Delivery Sale
    </div>

    <a href="{{ route('sales_delivery.index') }}" class="ds-back">← BACK TO LIST</a>
  </div>

  {{-- Row: Company + Sale Id --}}
  <form method="POST" action="{{ route('sales_delivery.store') }}">
    @csrf

    <div class="ds-row">
      {{-- Company --}}
      <div class="ds-field">
        <div class="ds-label">Company</div>
        <select name="company_id" class="ds-select">
          <option value="">- Select Company -</option>
          @foreach($companies ?? [] as $c)
            <option value="{{ $c->id }}">{{ $c->name }}</option>
          @endforeach
        </select>
        <button class="ds-rightbtn" type="button" title="Next">
          <span>›</span>
        </button>
      </div>

      {{-- Sale Id --}}
      <div class="ds-field">
        <div class="ds-label">Sale Id</div>
        <select name="sale_id" class="ds-select">
          <option value="">- Select Sale Id -</option>
          @foreach($sales ?? [] as $s)
            <option value="{{ $s->id }}">{{ $s->id }}</option>
          @endforeach
        </select>
        <button class="ds-rightbtn" type="submit" title="Go">
          <span>›</span>
        </button>
      </div>
    </div>
  </form>

</div>
@endsection

@push('styles')
<style>
/* ---------- Layout shell ---------- */
.ds-wrap{padding:18px}
.ds-head{
  display:flex;align-items:center;justify-content:space-between;
  margin-bottom:18px;
}
.ds-title{
  font-size:20px;font-weight:600;color:#222;display:flex;align-items:center;gap:8px;
}
.ds-plus{
  display:inline-grid;place-items:center;
  width:22px;height:22px;border:2px solid #333;border-radius:50%;
  line-height:1;font-weight:700;font-size:14px
}
.ds-back{
  text-decoration:none;
  font-size:13px;font-weight:600;letter-spacing:.2px;
  color:#3b6bb3;border:1px solid #cfe0ff;background:#f5f9ff;
  padding:8px 12px;border-radius:3px;
}

/* ---------- Field row ---------- */
.ds-row{
  display:grid;grid-template-columns:1fr 1fr;gap:18px;
}

/* One framed field (label + select + right button) */
.ds-field{
  display:grid;grid-template-columns:170px 1fr 34px;align-items:center;
  border:2px solid #c7d1f3;border-radius:3px;
  background:#fff;overflow:hidden;
}
.ds-label{
  background:#eef1f7;border-right:2px solid #c7d1f3;
  padding:10px 14px;font-weight:700;color:#111;text-align:left;
}
.ds-select{
  border:0;outline:none;padding:10px 12px;font-size:14px;color:#333;
  background:#fff;appearance:none;width:100%;
}
.ds-select:focus{outline:none}
.ds-rightbtn{
  width:34px;height:100%;border:0;border-left:2px solid #c7d1f3;
  background:#f2f4fb;cursor:pointer;display:grid;place-items:center;
}
.ds-rightbtn span{font-size:18px;color:#333;font-weight:700}

/* Small screens */
@media (max-width: 960px){
  .ds-row{grid-template-columns:1fr}
  .ds-field{grid-template-columns:140px 1fr 34px}
}
</style>
@endpush
