﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sl-wrap">
    {{-- Header --}}
    <div class="sl-head">
      <div class="sl-head-left">
        <i class="fas fa-list"></i>
        <span>Sale List</span>
      </div>
      <a href="{{ route('sales.create') }}" class="sl-add">
        <i class="fas fa-plus"></i> Add Sale
      </a>
    </div>

    <div class="sl-body">

      {{-- FILTER BAR --}}
      <form method="GET" action="{{ route('sales.index') }}" class="sl-filter">
        <div class="row g-2">
          <div class="col-xl-3 col-md-6">
            <div class="sl-filter-block">
              <div class="sl-filter-title">Company</div>
              <select name="company_id" class="sl-inp">
                <option value="">-Company Name-</option>
                @foreach($companies ?? [] as $co)
                  <option value="{{ $co->id }}" @selected(request('company_id')==$co->id)>{{ $co->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="col-xl-3 col-md-6">
            <div class="sl-filter-block">
              <div class="sl-filter-title">Customer</div>
              <select name="customer_id" class="sl-inp">
                <option value="">-Select Customer-</option>
                @foreach($customers ?? [] as $cu)
                  <option value="{{ $cu->id }}" @selected(request('customer_id')==$cu->id)>{{ $cu->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="col-xl-3 col-md-6">
            <div class="sl-filter-block">
              <div class="sl-filter-title">Invoice Number</div>
              <input type="text" name="invoice_no" value="{{ request('invoice_no') }}" class="sl-inp" placeholder="Search by Invoice number">
            </div>
          </div>

          <div class="col-xl-3 col-md-6">
            <div class="sl-filter-block">
              <div class="sl-filter-title">Filter by Date</div>
              <div class="d-flex gap-2">
                <div class="sl-ig">
                  <input type="date" name="date_from" value="{{ request('date_from') }}" class="sl-inp sl-date" placeholder="From Date">
                  <span class="sl-ico"><i class="far fa-calendar"></i></span>
                </div>
                <div class="sl-ig">
                  <input type="date" name="date_to" value="{{ request('date_to') }}" class="sl-inp sl-date" placeholder="To Date">
                  <span class="sl-ico"><i class="far fa-calendar"></i></span>
                </div>
              </div>
            </div>
          </div>

          <div class="col-12 d-flex justify-content-end gap-2 mt-1">
            <button type="submit" class="sl-btn sl-btn-primary">
              <i class="fas fa-search"></i> Search
            </button>
            <a href="{{ route('sales.index') }}" class="sl-btn sl-btn-gray" title="Reset">
              <i class="fas fa-sync-alt"></i>
            </a>
          </div>
        </div>
      </form>

      {{-- TABLE --}}
      <div class="table-responsive mt-2">
        <table class="table sl-table">
          <colgroup>
            <col style="width:50px">
            <col style="width:220px">
            <col style="width:160px">
            <col style="width:180px">
            <col style="width:150px">
            <col style="width:150px">
            <col style="width:120px">
            <col style="width:120px">
            <col style="width:130px">
            <col style="width:130px">
            <col style="width:130px">
            <col style="width:140px">
            <col style="width:120px">
            <col style="width:140px">
          </colgroup>
          <thead>
            <tr>
              <th>SL</th>
              <th>Company</th>
              <th>Invoice No</th>
              <th>Customer Name</th>
              <th>Customer Phone</th>
              <th>Employee Name</th>
              <th>Date</th>
              <th>Subtotal</th>
              <th>Discount</th>
              <th>Payable Amount</th>
              <th>Paid Amount</th>
              <th>Due Amount</th>
              <th>Payment Type</th>
              <th>Status</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>
          <tbody>
            @forelse($sales as $i => $row)
              @php
                $subtotal = (float)($row->sub_total ?? 0);
                $discount = (float)($row->discount ?? 0);
                $grand    = (float)($row->grand_total ?? ($subtotal - $discount));
                $paid     = (float)($row->paid ?? 0);
                $due      = max($grand - $paid, 0);
              @endphp
              <tr>
                <td>{{ $sales->firstItem() + $i }}</td>
                <td>{{ $row->company->name ?? '-' }}</td>
                <td>{{ $row->invoice_no ?? '-' }}</td>
                <td>{{ $row->customer->name ?? '-' }}</td>
                <td>{{ $row->customer->phone ?? '-' }}</td>
                <td>{{ $row->employee->name ?? '-' }}</td>
                <td>{{ \Carbon\Carbon::parse($row->date ?? $row->created_at)->format('Y-m-d') }}</td>
                <td>{{ number_format($subtotal, 0) }}</td>
                <td>{{ number_format($discount, 0) }}</td>
                <td>{{ number_format($grand, 0) }}</td>
                <td>{{ number_format($paid, 0) }}</td>
                <td>{{ number_format($due, 0) }}</td>
                <td>{{ $row->payment_type ?? 'Cash' }}</td>
                <td>
                  <span class="sl-badge sl-badge-green">Delivered</span>
                </td>
                <td class="text-center">
                  <div class="sl-actions">
                    <a class="sl-act sl-blue"  href="{{ route('sales.show',  $row->id) }}" title="Details"><i class="fas fa-info"></i></a>
                    <a class="sl-act sl-green" href="{{ route('sales.show',  $row->id) }}" title="View"><i class="fas fa-eye"></i></a>
                    <a class="sl-act sl-orange"href="{{ route('sales.edit',  $row->id) }}" title="Edit"><i class="fas fa-edit"></i></a>
                    <a class="sl-act sl-cyan"  href="{{ route('sales.print', $row->id) }}" title="Print"><i class="fas fa-print"></i></a>
                    <a class="sl-act sl-indigo"href="{{ route('sales.invoice',$row->id) }}" title="Invoice"><i class="fas fa-file-invoice"></i></a>
                    <form action="{{ route('sales.destroy',$row->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this sale?')">
                      @csrf @method('DELETE')
                      <button type="submit" class="sl-act sl-red" title="Delete"><i class="fas fa-trash"></i></button>
                    </form>
                  </div>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="15" class="text-center text-muted py-4">No data found!</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      {{-- Pagination --}}
      <div class="mt-2">
        {{ $sales->withQueryString()->links() }}
      </div>

      {{-- (Optional) Export icons row --}}
      {{-- <div class="mt-3">
        <a href="#"><img src="{{ asset('img/xls.png') }}" height="22"></a>
        <a href="#" class="ms-2"><img src="{{ asset('img/pdf.png') }}" height="22"></a>
      </div> --}}
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
/* Frame */
:root{
  --b1:#eaf2ff; --b2:#cfe0f7; --b3:#f6f9ff;
  --bd:#dfe6ee; --thead:#d7e6ff; --text:#556575;
  --green:#22b36b; --blue:#2f7ee6; --orange:#f1a43a; --cyan:#31b7c2; --indigo:#5562d6; --red:#e25b57;
}
.sl-wrap{border:1px solid var(--bd);background:#fff;border-radius:3px;}
.sl-head{display:flex;align-items:center;justify-content:space-between;padding:10px;border-bottom:1px solid var(--bd);background:#f3f7fc}
.sl-head-left{display:flex;gap:8px;align-items:center;color:#334}
.sl-head-left i{color:#6aa3c6}
.sl-add{display:inline-flex;align-items:center;gap:8px;background:var(--b3);border:1px solid var(--b2);padding:6px 10px;border-radius:3px;font-weight:600;color:#2f6fa8;text-decoration:none}

/* Filter */
.sl-body{padding:12px;font-size:12px;color:var(--text)}
.sl-filter-title{background:#edf1f6;border:1px solid var(--bd);border-radius:3px;padding:6px 8px;font-weight:700;margin-bottom:4px}
.sl-inp{height:34px;border:1px solid var(--bd);border-radius:3px;padding:4px 10px;width:100%}
.sl-ig{display:flex;position:relative;width:100%}
.sl-ico{position:absolute;right:0;top:0;height:34px;width:34px;border-left:1px solid var(--bd);background:#eef3f8;display:flex;align-items:center;justify-content:center;color:#8592a3;border-radius:0 3px 3px 0}
.sl-btn{height:34px;border:1px solid transparent;border-radius:4px;padding:0 12px;font-weight:600;display:inline-flex;gap:6px;align-items:center}
.sl-btn-primary{background:#5aa0d6;color:#fff;border-color:#4b93ca}
.sl-btn-gray{background:#fff;color:#6c7a89;border-color:var(--bd)}

/* Table */
.sl-table{margin:0;border:1px solid var(--bd);table-layout:fixed;font-size:12px}
.sl-table thead th{background:var(--thead);border-bottom:1px solid var(--bd);padding:8px 10px;font-weight:700;white-space:nowrap}
.sl-table tbody td{padding:9px 10px;border-top:1px solid var(--bd);vertical-align:middle}

/* Status pill */
.sl-badge{display:inline-block;padding:3px 10px;border-radius:12px;font-weight:700;font-size:11px;color:#fff}
.sl-badge-green{background:var(--green)}

/* Actions row */
.sl-actions{display:flex;justify-content:center;gap:6px}
.sl-act{width:28px;height:28px;border-radius:50%;border:0;display:inline-flex;align-items:center;justify-content:center;color:#fff;text-decoration:none}
.sl-blue  {background:var(--blue)}
.sl-green {background:var(--green)}
.sl-orange{background:var(--orange)}
.sl-cyan  {background:var(--cyan)}
.sl-indigo{background:var(--indigo)}
.sl-red   {background:var(--red)}
.sl-act button{background:transparent;border:0}
</style>
@endpush

