@extends('layouts.app')
@section('title','Edit Role')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111;--primary:#1d4ed8}
  .wrap{max-width:1000px;margin:0 auto}
  .panel{background:var(--card);border:1px solid var(--border);border-radius:10px}
  .panel-h{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
  .panel-b{padding:16px}
  .title{font-size:18px;font-weight:800}
  .muted{color:var(--muted)}
  .form-row{display:flex;flex-direction:column;gap:6px;margin-bottom:12px}
  .form-row label{font-size:13px;font-weight:700}
  .input{border:1px solid var(--border);border-radius:8px;padding:10px 12px;background:#fff}
  .is-invalid{border-color:#ef4444 !important}
  .err{color:#b91c1c;font-size:12px}
  .grid{display:grid;grid-template-columns:repeat(3,minmax(0,1fr));gap:10px}
  @media (max-width:900px){.grid{grid-template-columns:repeat(2,minmax(0,1fr))}}
  @media (max-width:600px){.grid{grid-template-columns:1fr}}
  .perm{border:1px solid var(--border);border-radius:8px;padding:10px}
  .actions{display:flex;gap:8px;justify-content:flex-end;margin-top:14px}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:var(--primary);color:#fff}
  .btn-ghost{background:#f3f4f6}
  .tool{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px}
</style>
@endpush

@section('content')
<div class="wrap">
  <div class="panel">
    <div class="panel-h">
      <div class="title"><i class="fa-solid fa-shield-halved"></i> Edit Role</div>
      <div class="muted">ID: #{{ $role->id }}</div>
    </div>

    <form class="panel-b" action="{{ route('roles.update',$role->id) }}" method="POST">
      @csrf @method('PUT')

      <div class="form-row">
        <label for="name">Role Name *</label>
        <input id="name" name="name" type="text" class="input @error('name') is-invalid @enderror"
               value="{{ old('name', $role->name) }}" required>
        @error('name') <div class="err">{{ $message }}</div> @enderror
      </div>

      {{-- Permissions --}}
      <div class="tool">
        <div class="muted"><i class="fa-regular fa-rectangle-list"></i> Permissions</div>
        <label style="display:flex;gap:8px;align-items:center;cursor:pointer">
          <input type="checkbox" id="checkAll"> <span>Select all</span>
        </label>
      </div>

      @php
        $assigned = collect(old('permissions', isset($rolePermissions) ? $rolePermissions : (method_exists($role,'permissions') ? $role->permissions->pluck('id')->toArray() : [])))->map(fn($v)=>(int)$v)->all();
      @endphp

      <div class="grid" id="permGrid">
        @forelse(($permissions ?? []) as $perm)
          <label class="perm">
            <input type="checkbox" name="permissions[]" value="{{ $perm->id }}"
                   {{ in_array((int)$perm->id, $assigned, true) ? 'checked' : '' }}>
            <span style="margin-left:8px">{{ $perm->name }}</span>
          </label>
        @empty
          <div class="muted">No permissions provided.</div>
        @endforelse
      </div>

      <div class="actions">
        @if(Route::has('roles.index'))
          <a href="{{ route('roles.index') }}" class="btn btn-ghost"><i class="fa-solid fa-circle-arrow-left"></i> Back</a>
        @endif
        <button type="submit" class="btn btn-primary"><i class="fa-solid fa-floppy-disk"></i> Update Role</button>
      </div>
    </form>
  </div>
</div>
@endsection

@push('scripts')
<script>
  // Select all
  const checkAll = document.getElementById('checkAll');
  const permGrid = document.getElementById('permGrid');
  checkAll?.addEventListener('change', function(){
    permGrid.querySelectorAll('input[type="checkbox"]').forEach(cb=> cb.checked = checkAll.checked);
  });
</script>
@endpush
