﻿@extends('layouts.app')
@section('title','Add Raw Purchase')

@section('content')
<div class="rm-wrap">
  {{-- Header --}}
  <div class="rm-head">
    <div class="rm-head-title"><i class="rm-gear">⚙</i> Add Raw Purchase</div>
    <a href="{{ route('purchase.raw_material.index') }}" class="rm-head-link">Purchase List</a>
  </div>

  <form action="{{ route('purchase.raw_material.store') }}" method="POST" enctype="multipart/form-data" id="rmForm">
    @csrf

    {{-- Top fields (exact layout) --}}
    <div class="rm-topgrid">
      <div class="rm-row">
        <div class="rm-label">Company</div>
        <select class="rm-input" name="company_id" required>
          <option value="">-Select Company-</option>
          @foreach(($companies ?? []) as $c)
            <option value="{{ $c->id }}" @selected(old('company_id')==$c->id)>{{ $c->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="rm-row">
        <div class="rm-label">Supplier</div>
        <select class="rm-input" name="supplier_id" required>
          <option value="">-Select Supplier-</option>
          @foreach(($suppliers ?? []) as $s)
            <option value="{{ $s->id }}" @selected(old('supplier_id')==$s->id)>{{ $s->name }}</option>
          @endforeach
        </select>
      </div>

      <div class="rm-row">
        <div class="rm-label">Employee</div>
        <select class="rm-input" name="employee_id">
          <option value="">-Select Employee-</option>
          @foreach(($employees ?? []) as $e)
            <option value="{{ $e->id }}" @selected(old('employee_id')==$e->id)>{{ $e->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="rm-row">
        <div class="rm-label">Warehouse</div>
        <select class="rm-input" name="warehouse_id">
          <option value="">-Select Warehouse-</option>
          @foreach(($warehouses ?? []) as $w)
            <option value="{{ $w->id }}" @selected(old('warehouse_id')==$w->id)>{{ $w->name }}</option>
          @endforeach
        </select>
      </div>

      <div class="rm-row">
        <div class="rm-label">Reference</div>
        <input class="rm-input" type="text" name="reference" placeholder="Reference" value="{{ old('reference') }}">
      </div>
      <div class="rm-row">
        <div class="rm-label">Attachment</div>
        <div class="rm-fileline">
          <div class="rm-filefake">No File …</div>
          <label class="rm-choose">Choose
            <input type="file" name="attachment" hidden>
          </label>
        </div>
      </div>

      <div class="rm-row">
        <div class="rm-label">Date</div>
        <div class="rm-datewrap">
          <input class="rm-input" type="date" name="date" value="{{ old('date', now()->toDateString()) }}" required>
          <button class="rm-datebtn" type="button">🗓</button>
        </div>
      </div>
      <div class="rm-row">
        <div class="rm-label">&nbsp;</div>
        <div class="rm-bagline">
          <input type="text" class="rm-baginput" readonly>
          <button type="button" class="rm-bagbtn">Bag</button>
          <label class="rm-radio"><input type="radio" name="bag_mode" value="with" checked> With Bag</label>
          <label class="rm-radio"><input type="radio" name="bag_mode" value="without"> Without Bag</label>
        </div>
      </div>
    </div>

    {{-- Items table --}}
    <div class="rm-tablewrap">
      <table class="rm-table" id="itemsTable">
        <thead>
          <tr>
            <th style="width:70px;">SL.</th>
            <th>Product <span class="req">*</span></th>
            <th style="width:220px;">Price</th>
            <th style="width:220px;">Kg</th>
            <th style="width:220px;">Bag</th>
            <th style="width:220px;">Total Kg</th>
            <th style="width:220px;">Mon</th>
            <th style="width:220px;">Sub Total</th>
            <th style="width:120px;"></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="sl">1</td>
            <td>
              <div class="rm-inputgrp">
                <select name="items[0][product_id]" class="rm-input prod" required>
                  <option value="">-select product-</option>
                  @foreach(($products ?? []) as $p)
                    <option value="{{ $p->id }}" data-kg="{{ $p->kg_per_bag ?? 0 }}">{{ $p->name }}</option>
                  @endforeach
                </select>
                <button type="button" class="rm-info">i</button>
              </div>
            </td>
            <td><input type="number" name="items[0][price]" class="rm-input text-end price" step="0.01" placeholder="Unit Price"></td>
            <td><input type="number" name="items[0][kg]" class="rm-input text-end kg" step="0.001" placeholder="KG"></td>
            <td><input type="number" name="items[0][bag]" class="rm-input text-end bag" step="1" placeholder="Bag"></td>
            <td><input type="number" name="items[0][total_kg]" class="rm-input text-end totalkg disabled" value="0.000" readonly></td>
            <td><input type="number" name="items[0][mon]" class="rm-input text-end mon" step="0.001" placeholder="Mon"></td>
            <td><input type="number" name="items[0][subtotal]" class="rm-input text-end subtotal disabled" value="0.00" readonly></td>
            <td class="rm-actions">
              <button type="button" class="rm-btn rm-minus" disabled>—</button>
              <button type="button" class="rm-btn rm-plus">+</button>
            </td>
          </tr>
        </tbody>
        <tfoot>
          <tr>
            <th colspan="5" class="text-end">Total:</th>
            <th><input class="rm-input text-end disabled" id="sumTotalKg" value="0.000" readonly></th>
            <th><input class="rm-input text-end disabled" value="0.000" readonly></th>
            <th><input class="rm-input text-end disabled" id="sumSubTotal" value="0.00" readonly></th>
            <th></th>
          </tr>
        </tfoot>
      </table>
    </div>

    {{-- Totals side block (right aligned like screenshot) --}}
    <div class="rm-bottomgrid">
      <div class="rm-spacer"></div>
      <div class="rm-totalsbox">
        <div class="rm-trow">
          <div class="rm-tlabel">Sub Total:</div>
          <input class="rm-input disabled" id="subTotalBox" value="0.00" readonly>
        </div>
        <div class="rm-trow">
          <div class="rm-tlabel">Discount:</div>
          <input class="rm-input" name="discount" id="discount" step="0.01" value="{{ old('discount',0) }}">
        </div>
        <div class="rm-trow">
          <div class="rm-tlabel">Grand Total:</div>
          <input class="rm-input disabled" name="grand_total" id="grandTotal" value="0.00" readonly>
        </div>
        <div class="rm-trow">
          <div class="rm-tlabel">Paid:</div>
          <div class="rm-inputgrp">
            <select class="rm-input" name="bank_id" style="max-width:260px;">
              <option value="">Bank Name</option>
              @foreach(($banks ?? []) as $b)
                <option value="{{ $b->id }}">{{ $b->name }}</option>
              @endforeach
            </select>
            <input class="rm-input text-end" name="paid" id="paid" step="0.01" value="{{ old('paid',0) }}">
          </div>
        </div>
        <div class="rm-trow">
          <div class="rm-tlabel">Due:</div>
          <input class="rm-input disabled" name="due" id="due" value="0.00" readonly>
        </div>
      </div>

      <div class="rm-savewrap">
        <button type="submit" class="rm-save"><span class="rm-disk">💾</span> Save</button>
      </div>
    </div>
  </form>
</div>
@endsection

@push('styles')
<style>
:root{
  --bd:#e3e7ed; --lbl:#eff3f7; --inp:#f5f8fb; --muted:#6b7280;
  --plus:#f4ad21; --minus:#e2786b; --link:#1976d2;
}
.rm-wrap{background:#fff;border:1px solid var(--bd);border-radius:2px;padding:12px}
.rm-head{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}
.rm-head-title{font-weight:600;color:#263238}
.rm-head-link{color:#1976d2;text-decoration:none}
.rm-head-link:hover{text-decoration:underline}
.rm-gear{margin-right:6px}

.rm-topgrid{display:grid;grid-template-columns:1fr 1fr;gap:10px}
.rm-row{display:flex;align-items:center}
.rm-label{width:130px;padding:9px 12px;border:1px solid var(--bd);background:var(--lbl);color:#333;border-radius:2px;margin-right:10px}
.rm-input{flex:1;border:1px solid var(--bd);background:var(--inp);padding:9px 12px;border-radius:2px;outline:none}
.rm-input.disabled{background:#e9edf2;color:#333}
.rm-fileline{display:flex;align-items:center;gap:10px;width:100%}
.rm-filefake{flex:1;border:1px solid var(--bd);background:var(--inp);padding:9px 12px;color:#6b7280;border-radius:2px}
.rm-choose{background:#1e88e5;color:#fff;border-radius:2px;padding:7px 12px;cursor:pointer;user-select:none}
.rm-choose:hover{filter:brightness(.95)}

.rm-datewrap{display:flex;gap:8px}
.rm-datebtn{border:1px solid var(--bd);background:var(--lbl);padding:0 10px;border-radius:2px}

.rm-bagline{display:flex;align-items:center;gap:10px}
.rm-baginput{width:170px;border:1px solid var(--bd);background:var(--inp);padding:9px 12px;border-radius:2px}
.rm-bagbtn{border:1px solid var(--bd);background:var(--lbl);padding:7px 14px;border-radius:2px}
.rm-radio{display:inline-flex;align-items:center;gap:6px;color:#333;margin-left:6px}

.rm-tablewrap{margin-top:12px}
.rm-table{width:100%;border-collapse:collapse}
.rm-table th,.rm-table td{border:1px solid var(--bd);padding:10px;background:#fff}
.rm-table thead th{background:#f1f4f8;color:#333;font-weight:600}
.rm-inputgrp{display:flex;gap:6px}
.rm-info{border:1px solid var(--bd);background:var(--lbl);padding:0 10px;border-radius:2px}
.text-end{text-align:right}
.req{color:#e34b4b}
.sl{text-align:center}

.rm-actions{display:flex;gap:8px;justify-content:center}
.rm-btn{width:42px;height:36px;border:0;border-radius:2px;color:#fff}
.rm-plus{background:var(--plus)}
.rm-minus{background:var(--minus)}
.rm-btn:disabled{opacity:.5}

.rm-bottomgrid{display:grid;grid-template-columns:1fr auto;gap:12px;margin-top:14px}
.rm-spacer{min-height:1px}
.rm-totalsbox{border:1px solid var(--bd);padding:10px;width:740px}
.rm-trow{display:grid;grid-template-columns:220px 1fr;gap:10px;margin-bottom:10px}
.rm-tlabel{background:var(--lbl);border:1px solid var(--bd);padding:9px 12px;border-radius:2px}
.rm-savewrap{align-self:start}
.rm-save{background:#43a047;color:#fff;border:0;border-radius:2px;padding:8px 16px;display:flex;align-items:center;gap:8px}
</style>
@endpush

@push('scripts')
<script>
(function(){
  const tbody = document.querySelector('#itemsTable tbody');
  const discount = document.getElementById('discount');
  const paid     = document.getElementById('paid');
  const subTotalBox = document.getElementById('subTotalBox');
  const sumSubTotal = document.getElementById('sumSubTotal');
  const sumTotalKg  = document.getElementById('sumTotalKg');
  const grandTotal  = document.getElementById('grandTotal');
  const due         = document.getElementById('due');
  const bagRadios   = document.querySelectorAll('input[name="bag_mode"]');

  const f2 = v => (Number(v||0)).toFixed(2);
  const f3 = v => (Number(v||0)).toFixed(3);

  function renumber(){
    [...tbody.rows].forEach((tr,i)=>{
      tr.querySelector('.sl').textContent = i+1;
      tr.querySelectorAll('input,select').forEach(el=>{
        el.name = el.name.replace(/items\[\d+]/, `items[${i}]`);
      });
      tr.querySelector('.rm-minus').disabled = (tbody.rows.length===1);
    });
  }

  function addRow(after){
    const t = tbody.rows[0].cloneNode(true);
    t.querySelectorAll('input').forEach(i=>{
      if(i.classList.contains('totalkg')) i.value='0.000';
      else if(i.classList.contains('subtotal')) i.value='0.00';
      else i.value='';
    });
    tbody.insertBefore(t, after? after.nextSibling : null);
    renumber(); calcAll();
  }

  function calcRow(tr){
    const withBag = [...bagRadios].find(r=>r.checked)?.value==='with';
    const price = Number(tr.querySelector('.price').value||0);
    const kg    = Number(tr.querySelector('.kg').value||0);
    const bag   = Number(tr.querySelector('.bag').value||0);
    const mon   = Number(tr.querySelector('.mon').value||0);
    const totalKg = withBag ? (kg*bag) : kg;
    tr.querySelector('.totalkg').value = f3(totalKg);
    const qty = mon>0 ? mon : totalKg;
    tr.querySelector('.subtotal').value = f2(price*qty);
  }

  function calcAll(){
    let tKg=0, tSub=0;
    [...tbody.rows].forEach(tr=>{
      calcRow(tr);
      tKg  += Number(tr.querySelector('.totalkg').value||0);
      tSub += Number(tr.querySelector('.subtotal').value||0);
    });
    sumTotalKg.value = f3(tKg);
    sumSubTotal.value = f2(tSub);
    subTotalBox.value = f2(tSub);
    const gt = Math.max(0, tSub - Number(discount.value||0));
    grandTotal.value = f2(gt);
    due.value = f2(Math.max(0, gt - Number(paid.value||0)));
  }

  tbody.addEventListener('click', e=>{
    if(e.target.classList.contains('rm-plus')) addRow(e.target.closest('tr'));
    if(e.target.classList.contains('rm-minus') && tbody.rows.length>1){
      e.target.closest('tr').remove(); renumber(); calcAll();
    }
  });
  tbody.addEventListener('input', e=>{
    if(e.target.matches('.price,.kg,.bag,.mon')) calcAll();
  });
  [discount,paid].forEach(el=>el.addEventListener('input', calcAll));
  bagRadios.forEach(r=>r.addEventListener('change', calcAll));

  renumber(); calcAll();
})();
</script>
@endpush
