@extends('layouts.app')
@section('title','Warehouse List')

@section('content')
<div class="whx">

  {{-- ===== Title row ===== --}}
  <div class="whx-titlebar">
    <div class="whx-title">
      <i class="fa fa-list-ul"></i>
      <span>Warehouse List</span>
    </div>

    <a href="{{ route('products.warehouses.create') }}" class="whx-add-btn">
      <i class="fa fa-plus"></i> Add Warehouse
    </a>
  </div>

  {{-- ===== Card ===== --}}
  <div class="whx-card">
    <div class="whx-card-head">
      <div></div>
      <label class="whx-search">
        <span>Search:</span>
        <input type="text" oninput="whxFilter(this.value)" placeholder="">
      </label>
    </div>

    <div class="whx-table-wrap">
      <table class="whx-table" id="whxTable">
        <thead>
          <tr>
            <th style="width:70px">SL</th>
            <th>Warehouse Name</th>
            <th style="width:220px">Warehouse Type</th>
            <th style="width:200px">Product Type</th>
            <th style="width:140px">Status</th>
            <th style="width:220px">Action</th>
          </tr>
        </thead>

        <tbody>
        @forelse($warehouses as $w)
          @php
            $active = (string)($w->status ?? '1') === '1';

            $sl = ($warehouses instanceof \Illuminate\Pagination\LengthAwarePaginator)
                ? $warehouses->firstItem() + $loop->index
                : $loop->iteration;

            // relation name (Warehouse Type). Fallback dash.
            $typeName = trim($w->warehouseType->name ?? '—');

            // === FIX: Product Type comes from DB "type" (INT) / accessor "type_label" ===
            $ptypeLabel = $w->type_label ?? '—';   // e.g., Raw / Finish / Bag / G. Store

            // pick badge color by INT value in $w->type
            switch ((int)($w->type ?? 0)) {
              case 4: $ptClass = 'pt-blue';  break; // G. Store
              case 2: $ptClass = 'pt-red';   break; // Finish
              case 1: $ptClass = 'pt-green'; break; // Raw
              case 3: $ptClass = 'pt-cyan';  break; // Bag
              default:$ptClass = 'pt-gray';
            }

            // Hover details (optional)
            $createdBy = $w->createdByName ?? (optional($w->createdBy)->name ?: ($w->created_by ? "User #{$w->created_by}" : '—'));
            $updatedBy = $w->updatedByName ?? (optional($w->updatedBy)->name ?: ($w->updated_by ? "User #{$w->updated_by}" : '—'));
            $createdAt = optional($w->created_at)->format('Y-m-d H:i:s') ?? '';
            $updatedAt = optional($w->updated_at)->format('Y-m-d H:i:s') ?? '';
          @endphp

          <tr>
            <td>{{ $sl }}</td>
            <td>{{ $w->name }}</td>
            <td>{{ $typeName }}</td>

            {{-- === FIX: show Product Type correctly === --}}
            <td>
              <span class="whx-pt {{ $ptClass }}">
                {{ $ptypeLabel }}
              </span>
            </td>

            <td>
              @if($active)
                <span class="whx-badge whx-badge-green">Active</span>
              @else
                <span class="whx-badge">Inactive</span>
              @endif
            </td>

            <td class="whx-actions">
              {{-- Info popover trigger --}}
              <button type="button" class="whx-btn whx-btn-blue whx-pop-trigger"
                      title="Details"
                      data-created-by="{{ $createdBy }}"
                      data-created-at="{{ $createdAt }}"
                      data-updated-by="{{ $updatedBy }}"
                      data-updated-at="{{ $updatedAt }}">
                <i class="fa fa-info"></i>
              </button>

              {{-- Edit --}}
              <a href="{{ route('products.warehouses.edit', $w->id) }}"
                 class="whx-btn whx-btn-green" title="Edit">
                <i class="fa fa-pen"></i>
              </a>

              {{-- Delete (needs DELETE method) --}}
              <form action="{{ route('products.warehouses.destroy', $w->id) }}" method="POST" style="display:inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="whx-btn whx-btn-red" title="Delete"
                        onclick="return confirm('Delete this warehouse?')">
                  <i class="fa fa-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="6" style="text-align:center;color:#6b7280;padding:18px">No data found.</td>
          </tr>
        @endforelse
        </tbody>
      </table>
    </div>

    {{-- Pagination --}}
    @if($warehouses instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="whx-paginate">
        {{ $warehouses->links() }}
      </div>
    @endif
  </div>
</div>

{{-- ====== STYLES (scoped) ====== --}}
<style>
.whx{margin-top:4px}
.whx-titlebar{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px}
.whx-title{display:flex;align-items:center;gap:10px;color:#1f4b99}
.whx-title .fa{color:#1f7bd8;font-size:22px}
.whx-title span{font-size:28px;font-weight:600}

.whx-add-btn{
  background:#1f7bd8;color:#fff;border:1px solid #1b6dbf;text-decoration:none;
  padding:7px 11px;border-radius:3px;font-size:14px;display:inline-flex;align-items:center;gap:6px
}
.whx-add-btn:hover{background:#1866b5;border-color:#155b9f}

.whx-card{border:1px solid #dbe3ee;border-radius:3px;background:#fff}
.whx-card-head{
  display:flex;align-items:center;justify-content:space-between;
  padding:10px 12px;border-bottom:1px solid #dbe3ee;background:#eef3f9
}
.whx-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.whx-search input{
  height:26px;width:180px;border:1px solid #cfd9e5;border-radius:2px;padding:0 6px;outline:none
}
.whx-search input:focus{border-color:#89b8ef;box-shadow:0 0 0 2px rgba(49,132,255,.15)}

.whx-table{width:100%;border-collapse:collapse;table-layout:auto}
.whx-table thead th{
  text-align:left;padding:10px;background:linear-gradient(180deg,#f5f7fb 0%,#e9edf3 100%);
  border:1px solid #e2e8f0;color:#1f4b99;font-weight:700;font-size:14px
}
.whx-table tbody td{padding:10px;border:1px solid #e9eef5;font-size:14px;color:#111827}
.whx-table tbody tr:nth-child(odd){background:#fafcfe}

.whx-badge{display:inline-block;padding:3px 8px;border-radius:2px;font-size:12px;background:#e6e7eb;color:#374151;font-weight:700}
.whx-badge-green{background:#8be27d;color:#0e4b15}

/* Product Type badges */
.whx-pt{display:inline-block;padding:3px 8px;border-radius:3px;font-weight:700;font-size:12px}
.pt-blue{background:#e6f2ff;color:#1352a3;border:1px solid #cfe6ff}
.pt-red{background:#ffe7e7;color:#aa1e1e;border:1px solid #ffcece}
.pt-green{background:#e8f7eb;color:#1e7e34;border:1px solid #ccefd6}
.pt-cyan{background:#e8fbff;color:#0b7285;border:1px solid #c9f3ff}
.pt-gray{background:#f2f4f7;color:#495057;border:1px solid #e5e7eb}

.whx-actions{display:flex;align-items:center;gap:6px}
.whx-btn{
  width:26px;height:26px;border-radius:2px;display:inline-flex;align-items:center;justify-content:center;
  color:#fff;border:1px solid transparent;text-decoration:none;cursor:pointer
}
.whx-btn .fa{font-size:13px}
.whx-btn-blue{background:#2ea3f2;border-color:#248dd1}
.whx-btn-green{background:#38b36b;border-color:#2e9a5b}
.whx-btn-red{background:#e2554f;border-color:#c24741}
.whx-btn:hover{filter:brightness(.97)}

.whx-paginate{padding:10px 12px;border-top:1px solid #e9edf3}

/* Hover popover */
.whx-pop{
  position:fixed; z-index:50; min-width:360px; max-width:380px;
  background:#fff; color:#111827; border:1px solid #d8e1ef; border-radius:3px;
  box-shadow:0 10px 24px rgba(0,0,0,.12); overflow:hidden;
}
.whx-pop .hd{display:flex;align-items:center;gap:8px;padding:8px 10px;font-weight:700;color:#1f2937;background:#f2f6fc;border-bottom:1px solid #e1e8f5}
.whx-pop .hd .fa{color:#2ca44f}
.whx-pop .bd{padding:10px 12px;font-size:14px}
.whx-pop .row{margin:6px 0}
.whx-pop .lbl{color:#6b7280}
.whx-pop .arrow{position:absolute;left:calc(50% - 8px);bottom:-8px;width:0;height:0;border-left:8px solid transparent;border-right:8px solid transparent;border-top:8px solid #d8e1ef}
.whx-pop .arrow::after{content:"";position:absolute;left:-7px;top:-9px;width:0;height:0;border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid #fff}
</style>

{{-- ====== SCRIPTS ====== --}}
<script>
function whxFilter(q){
  const rows = document.querySelectorAll('#whxTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => {
    if(r.querySelector('td[colspan]')) { r.style.display = ''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}

/* Info hover popover */
(function(){
  let tip, hideTimer, showTimer;

  const makeTip = (btn) => {
    tip = document.createElement('div');
    tip.className = 'whx-pop';
    tip.innerHTML =
      `<div class="hd"><i class="fa fa-info-circle"></i> <span>Log Information</span></div>
       <div class="bd">
         <div class="row"><span class="lbl">Created By:</span> ${btn.dataset.createdBy || 'N/A'}</div>
         <div class="row"><span class="lbl">Created At :</span> ${btn.dataset.createdAt || 'N/A'}</div>
         <div class="row" style="margin:8px 0;border-top:1px solid #eef2f7"></div>
         <div class="row"><span class="lbl">Updated By:</span> ${btn.dataset.updatedBy || 'N/A'}</div>
         <div class="row"><span class="lbl">Updated At :</span> ${btn.dataset.updatedAt || 'N/A'}</div>
       </div>
       <div class="arrow"></div>`;
    document.body.appendChild(tip);

    const r = btn.getBoundingClientRect();
    const gap = 10;
    const top = r.top + window.scrollY - tip.offsetHeight - gap;
    const left = Math.min(
      window.innerWidth - tip.offsetWidth - 10,
      Math.max(10, r.right - tip.offsetWidth)
    );
    tip.style.top  = (top > 10 ? top : 10) + 'px';
    tip.style.left = left + 'px';
  };

  const show = (btn) => {
    clearTimeout(hideTimer);
    clearTimeout(showTimer);
    showTimer = setTimeout(()=> {
      if(tip) tip.remove();
      makeTip(btn);
    }, 120);
  };

  const hide = () => {
    clearTimeout(showTimer);
    hideTimer = setTimeout(()=>{ if(tip){ tip.remove(); tip=null; } }, 120);
  };

  document.addEventListener('mouseover', (e)=>{
    const btn = e.target.closest('.whx-pop-trigger');
    if(btn) show(btn);
  });
  document.addEventListener('mouseout', (e)=>{
    if(e.target.closest('.whx-pop-trigger')) hide();
  });
  window.addEventListener('scroll', hide, {passive:true});
  window.addEventListener('resize', hide);
})();
</script>
@endsection
