@extends('layouts.app')
@section('title','Edit Warehouse')

@section('content')
<div class="wh-wrap">
  <div class="wh-panel">
    <div class="wh-head">
      <div class="wh-head-left">
        <i class="fa fa-cog"></i>
        <span>Edit Warehouse</span>
      </div>
      <a href="{{ route('products.warehouses.index') }}" class="wh-head-link">
        <i class="fa fa-list"></i> Warehouse List
      </a>
    </div>

    <div class="wh-body">
      <form action="{{ route('products.warehouses.update', $warehouse->id) }}" method="POST" autocomplete="off">
        @csrf
        @method('PUT')

        {{-- Warehouse Name --}}
        <div class="wh-row @error('name') has-error @enderror">
          <div class="wh-label">Warehouse Name</div>
          <div class="wh-control">
            <input type="text" name="name" class="wh-input"
                   value="{{ old('name', $warehouse->name) }}">
            @error('name') <div class="wh-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Warehouse Type (ID) --}}
        <div class="wh-row @error('warehouse_type_id') has-error @enderror">
          <div class="wh-label">Warehouse Type</div>
          <div class="wh-control">
            <select name="warehouse_type_id" class="wh-select">
              <option value="">- Select Warehouse Type -</option>
              @foreach($warehouseTypes as $wt)
                <option value="{{ $wt->id }}"
                  {{ (string)old('warehouse_type_id', (string)$warehouse->warehouse_type_id) === (string)$wt->id ? 'selected' : '' }}>
                  {{ $wt->name }}
                </option>
              @endforeach
            </select>
            @error('warehouse_type_id') <div class="wh-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Type (Select instead of radios) --}}
        @php
          // If your controller sets $warehouse->type_key (when DB stores INT), use it.
          // Fallback: map INT -> key here so it still preselects.
          $intToKey = [1=>'raw', 2=>'finish', 3=>'bag', 4=>'g_store'];
          $currentTypeKey = old('type', $warehouse->type_key ?? ($intToKey[$warehouse->type] ?? ''));
        @endphp
        <div class="wh-row @error('type') has-error @enderror">
          <div class="wh-label">Type</div>
          <div class="wh-control">
            <select name="type" class="wh-select">
              <option value="">-- Select --</option>
              <option value="raw"     {{ $currentTypeKey==='raw'     ? 'selected' : '' }}>Raw</option>
              <option value="finish"  {{ $currentTypeKey==='finish'  ? 'selected' : '' }}>Finish</option>
              <option value="bag"     {{ $currentTypeKey==='bag'     ? 'selected' : '' }}>Bag</option>
              <option value="g_store" {{ $currentTypeKey==='g_store' ? 'selected' : '' }}>G. Store</option>
            </select>
            @error('type') <div class="wh-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Status (1/0) --}}
        @php
          $statusVal = (string)old('status', (string)$warehouse->status);
        @endphp
        <div class="wh-row @error('status') has-error @enderror">
          <div class="wh-label">Status</div>
          <div class="wh-control">
            <select name="status" class="wh-select">
              <option value="1" {{ $statusVal==='1' ? 'selected' : '' }}>Active</option>
              <option value="0" {{ $statusVal==='0' ? 'selected' : '' }}>Inactive</option>
            </select>
            @error('status') <div class="wh-help">{{ $message }}</div> @enderror
          </div>
        </div>

        <div class="wh-actions">
          <button type="submit" class="btn-ico btn-green">
            <i class="fa fa-floppy-o"></i> Update
          </button>
          <button type="reset" class="btn-ico btn-gray">
            <i class="fa fa-refresh"></i> Reset
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

{{-- Scoped styles (unchanged look) --}}
<style>
.wh-wrap{padding:10px}
.wh-panel{border:1px solid #d9d9d9;border-radius:2px;background:#fff}
.wh-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid #e6e6e6;background:linear-gradient(#f7f7f7,#ececec)}
.wh-head-left{display:flex;gap:8px;align-items:center;color:#2b78c5;font-weight:600}
.wh-head-link{border:1px solid #c7d7ea;background:#f3f8ff;color:#2b78c5;padding:6px 10px;border-radius:2px;text-decoration:none}
.wh-head-link i{margin-right:6px}
.wh-body{padding:18px}
.wh-row{display:flex;align-items:center;margin-bottom:16px}
.wh-label{width:160px;min-width:160px;background:#f0f2f5;border:1px solid #d9d9d9;border-right:none;border-radius:3px 0 0 3px;padding:10px 14px;text-align:center;font-weight:600;color:#666}
.wh-control{flex:1}
.wh-input,.wh-select,.wh-control.form-like{
  width:100%;border:1px solid #d9d9d9;border-radius:0 3px 3px 0;padding:9px 12px;line-height:1.4}
.wh-input,.wh-select{height:36px}
.wh-select{background:#fff}
.wh-actions{text-align:right;margin-top:12px}
.btn-ico{display:inline-flex;align-items:center;gap:8px;padding:9px 14px;border-radius:3px;border:1px solid transparent;font-weight:600;cursor:pointer}
.btn-green{background:#7dbd71;border-color:#6fb064;color:#fff}
.btn-gray{background:#e7edf3;border-color:#d4dbe2;color:#3b4b5c}
.btn-ico i{font-size:14px}
.wh-help{margin-top:6px;color:#a94442}
.has-error .wh-input,.has-error .wh-select{border-color:#a94442}
</style>
@endsection
