@extends('layouts.app')
@section('title','Edit Warehouse Type')

@section('content')
@php
  // যদি কন্ট্রোলার অন্য নামে পাঠায় (যেমন $type / $whType), ফ্যালব্যাক নিন
  $wt = $warehouseType ?? $type ?? $whType ?? $model ?? null;
@endphp

@if(!$wt)
  <div style="padding:12px;border:1px solid #fca5a5;background:#fff1f2;color:#991b1b;border-radius:6px">
    Warehouse type not found. Make sure the controller passes <code>$warehouseType</code> to this view.
  </div>
@else
<div class="wh-card">
  <div class="wh-head">
    <div class="wh-title">
      <i class="fa fa-cog"></i>
      <span>Edit Warehouse Type</span>
    </div>

    <a href="{{ route('products.warehouse-types.index') }}" class="wh-link">
      <i class="fa fa-list-ul"></i> Warehouse Type List
    </a>
  </div>

  <form action="{{ route('products.warehouse-types.update', $wt->id) }}" method="POST" autocomplete="off">
    @csrf
    @method('PUT')

    <div class="wh-row">
      <div class="wh-label">
        Warehouse Type Name <b class="req">*</b>
      </div>
      <div class="wh-field">
        <input type="text" name="name"
               value="{{ old('name', $wt->name) }}"
               placeholder="Enter the Warehouse Type Name">
        @error('name') <div class="wh-error">{{ $message }}</div> @enderror
      </div>
      <div class="wh-addon">
        <span class="pill"><i class="fa fa-chart-line"></i></span>
      </div>
    </div>

    <div class="wh-row">
      <div class="wh-label">Status</div>
      <div class="wh-field">
        <select name="status">
          <option value="1" {{ old('status',$wt->status)=='1' ? 'selected' : '' }}>Active</option>
          <option value="0" {{ old('status',$wt->status)=='0' ? 'selected' : '' }}>Inactive</option>
        </select>
      </div>
      <div class="wh-addon"><i class="fa fa-angle-down"></i></div>
    </div>

    <div class="wh-actions">
      <button type="submit" class="btn btn-save">
        <i class="fa fa-save"></i> Update
      </button>
      <button type="reset" class="btn btn-reset">
        <i class="fa fa-sync"></i> Reset
      </button>
    </div>
  </form>
</div>
@endif

<style>
.wh-card{border:1px solid #dfe7f1;border-radius:3px;background:#fff}
.wh-head{display:flex;align-items:center;justify-content:space-between;border-bottom:1px solid #e6edf7;
  background:linear-gradient(180deg,#f5f8fc 0%,#eef3f9 100%);padding:12px 14px}
.wh-title{display:flex;align-items:center;gap:8px;color:#3b4966;font-weight:700}
.wh-title i{color:#6aa7ff}
.wh-link{font-size:14px;text-decoration:none;color:#2b6cb0}
.wh-link i{margin-right:6px}
.wh-link:hover{color:#1f5a92}

.wh-row{display:grid;grid-template-columns:220px 1fr 40px;gap:8px;align-items:center;
  padding:10px 12px;border-bottom:1px solid #eef2f7}
.wh-label{background:#f1f5fa;border:1px solid #e2e8f0;border-radius:2px;padding:8px 10px;color:#334155;font-weight:600}
.req{color:#e11d48}
.wh-field input,.wh-field select{width:100%;height:36px;border:1px solid #d1d9e6;border-radius:2px;padding:0 10px;outline:none}
.wh-field input:focus,.wh-field select:focus{border-color:#7db4ff;box-shadow:0 0 0 2px rgba(64,132,255,.15)}
.wh-addon{display:flex;align-items:center;justify-content:center}
.wh-addon .pill{display:inline-flex;align-items:center;justify-content:center;width:28px;height:28px;border-radius:999px;
  background:#e6f6ff;color:#2aa1ff;border:1px solid #bde3ff}
.wh-error{margin-top:6px;color:#dc2626;font-size:12px}

.wh-actions{display:flex;gap:10px;justify-content:flex-start;padding:14px}
.btn{display:inline-flex;align-items:center;gap:8px;border:1px solid transparent;border-radius:3px;height:36px;padding:0 14px;cursor:pointer}
.btn-save{background:#4caf50;border-color:#449d48;color:#fff}
.btn-save:hover{filter:brightness(.95)}
.btn-reset{background:#90a4ae;border-color:#7f96a1;color:#fff}
.btn-reset:hover{filter:brightness(.95)}
</style>
@endsection
