@extends('layouts.app')
@section('title','Unit List')

@section('content')
<div class="ulst-card">
  <div class="ulst-card-head">
    <div class="ulst-title">
      <i class="fa fa-list-ul"></i>
      <span>Unit List</span>
    </div>

    <div class="ulst-actions">
      {{-- FIX: create রুটে নিন --}}
      <a href="{{ route('products.units.create') }}" class="ulst-btn ulst-btn-primary">
        <i class="fa fa-plus"></i> Add Unit List
      </a>
    </div>
  </div>

  <div class="ulst-card-toolbar">
    <label class="ulst-search">
      <span>Search:</span>
      <input type="text" oninput="ulstFilter(this.value)">
    </label>
  </div>

  <div class="ulst-table-wrap">
    <table class="ulst-table" id="ulstTable">
      <thead>
        <tr>
          <th style="width:70px">SL</th>
          <th>Unit Name</th>
          <th style="width:160px">Status</th>
          <th style="width:180px">Action</th>
        </tr>
      </thead>
      <tbody>
        @php
          // ডাটা না এলে ডেমো
          $rows = isset($units) ? $units : collect([
            (object)['name'=>'bag','active'=>true],
            (object)['name'=>'Ton','active'=>true],
            (object)['name'=>'Kg','active'=>true],
            (object)['name'=>'Pound','active'=>true],
            (object)['name'=>'Mon','active'=>true],
            (object)['name'=>'gm','active'=>true],
          ]);
        @endphp

        @foreach($rows as $i => $unit)
        @php
          // rm_units.status ('1'/'0') অথবা active (bool) – দুটোই সাপোর্ট
          $isActive = isset($unit->status) ? (string)$unit->status === '1' : (bool)($unit->active ?? true);
        @endphp
        <tr>
          <td>{{ $loop->iteration }}</td>
          <td>{{ $unit->name ?? '' }}</td>
          <td>
            @if($isActive)
              <span class="ulst-badge ulst-badge-success">Active</span>
            @else
              <span class="ulst-badge">Inactive</span>
            @endif
          </td>
          <td class="ulst-actions-td">
            <a href="#" class="ulst-btn-icon ulst-info" title="Details"><i class="fa fa-info"></i></a>

            {{-- Edit (id থাকলে রুট দেখাবো, নাহলে #) --}}
            <a
              href="{{ isset($unit->id) ? route('products.units.edit', $unit->id) : '#'}}"
              class="ulst-btn-icon ulst-edit" title="Edit">
              <i class="fa fa-pen"></i>
            </a>

            {{-- Delete (id থাকলে ফর্ম, নাহলে #) --}}
            @if(isset($unit->id))
              <form action="{{ route('products.units.destroy', $unit->id) }}" method="POST" style="display:inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="ulst-btn-icon ulst-del" title="Delete" onclick="return confirm('Delete this unit?')">
                  <i class="fa fa-trash"></i>
                </button>
              </form>
            @else
              <a href="#" class="ulst-btn-icon ulst-del" title="Delete"><i class="fa fa-trash"></i></a>
            @endif
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>

<style>
/* ====== Unit List (scoped) ====== */
.ulst-card{border:1px solid #e5e7eb;border-radius:6px;background:#fff;box-shadow:0 1px 1px rgba(0,0,0,.02)}
.ulst-card-head{display:flex;align-items:center;justify-content:space-between;padding:12px 14px;border-bottom:1px solid #e9edf3;background:#eef5fd;background:linear-gradient(180deg,#eef5fd 0%,#e9f0fb 100%)}
.ulst-title{display:flex;align-items:center;gap:10px;color:#1f2937;font-weight:700;font-size:20px}
.ulst-title .fa{color:#3b82f6}
.ulst-actions{display:flex;gap:8px}
.ulst-btn{display:inline-flex;align-items:center;gap:8px;padding:8px 10px;border-radius:4px;font-size:14px;text-decoration:none;border:1px solid transparent}
.ulst-btn-primary{background:#3b82f6;color:#fff;border-color:#3b82f6}
.ulst-btn-primary:hover{background:#2563eb;border-color:#2563eb}

.ulst-card-toolbar{display:flex;justify-content:flex-end;padding:10px 14px;border-bottom:1px solid #e9edf3}
.ulst-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.ulst-search input{height:30px;border:1px solid #d1d5db;border-radius:3px;padding:0 8px;outline:none}
.ulst-search input:focus{border-color:#60a5fa;box-shadow:0 0 0 3px rgba(59,130,246,.15)}

.ulst-table-wrap{padding:0 0 10px}
.ulst-table{width:100%;border-collapse:separate;border-spacing:0}
.ulst-table thead th{background:linear-gradient(180deg,#f7f9fc 0%,#eef2f7 100%);color:#1f4b99;font-weight:700;padding:10px;border-top:1px solid #e5e7eb;border-bottom:1px solid #e5e7eb;text-align:left;font-size:14px}
.ulst-table tbody td{padding:10px;border-bottom:1px solid #edf1f5;font-size:14px;color:#111827}
.ulst-table tbody tr:nth-child(odd){background:#fafbfc}
.ulst-table tbody tr:hover{background:#f5f9ff}

.ulst-badge{display:inline-block;padding:4px 8px;font-size:12px;border-radius:4px;font-weight:700;background:#e5e7eb;color:#374151}
.ulst-badge-success{background:#86efac;color:#14532d}

.ulst-actions-td{display:flex;align-items:center;gap:8px}
.ulst-btn-icon{width:28px;height:28px;display:inline-flex;align-items:center;justify-content:center;border-radius:4px;color:#fff;text-decoration:none;border:0;cursor:pointer}
.ulst-info{background:#60a5fa}
.ulst-edit{background:#22c55e}
.ulst-del{background:#ef4444}
.ulst-btn-icon:hover{filter:brightness(.95)}
</style>

<script>
function ulstFilter(q){
  const rows = document.querySelectorAll('#ulstTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none');
}
</script>
@endsection
