@extends('layouts.app')
@section('title','Add New Unit')

@section('content')
<form class="uform-card" method="POST" action="{{ route('products.units.store') }}">
    @csrf

    <div class="uform-head">
        <div class="uform-title">
            <i class="fa fa-cog"></i>
            <span>Add New Unit</span>
        </div>
        <a href="{{ route('products.units.index') }}" class="uform-link">
            <i class="fa fa-list"></i> Unit List
        </a>
    </div>

    <div class="uform-body">

        {{-- Unit Name --}}
        <div class="uform-row">
            <div class="uform-label">
                Unit Name <span class="uform-req">*</span>
            </div>
            <div class="uform-field">
                <input type="text" name="name" value="{{ old('name') }}"
                       class="uform-input" placeholder="Enter The Unit Name" required>
                @error('name') <div class="uform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Status --}}
        <div class="uform-row">
            <div class="uform-label">Status</div>
            <div class="uform-field">
                <select name="status" class="uform-select">
                    <option value="1" {{ old('status','1')=='1' ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ old('status')==='0' ? 'selected' : '' }}>Inactive</option>
                </select>
                @error('status') <div class="uform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        <div class="uform-actions">
            <button type="submit" class="uform-btn uform-btn-save">
                <i class="fa fa-save"></i> Save
            </button>
            <button type="reset" class="uform-btn uform-btn-reset">
                <i class="fa fa-rotate"></i> Reset
            </button>
        </div>
    </div>
</form>

<style>
/* ====== Scoped styles: Unit Create Form (uform-) ====== */
.uform-card{border:1px solid #e5e7eb;border-radius:6px;background:#fff;max-width:1120px;margin:0 auto;box-shadow:0 1px 1px rgba(0,0,0,.02)}
.uform-head{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid #e9edf3;background:linear-gradient(180deg,#eef2f7 0%,#e7edf7 100%)}
.uform-title{display:flex;align-items:center;gap:8px;font-weight:700;color:#2563eb;font-size:18px}
.uform-title .fa{color:#3b82f6}
.uform-link{display:inline-flex;align-items:center;gap:6px;background:#f1f5f9;border:1px solid #dbe4ee;color:#2563eb;text-decoration:none;padding:6px 10px;border-radius:4px;font-weight:600}
.uform-link:hover{background:#e6eef8}

.uform-body{padding:18px}
.uform-row{display:flex;align-items:center;margin-bottom:16px}
.uform-label{flex:0 0 220px;background:#eef1f5;border:1px solid #e3e7ee;border-right:0;border-radius:4px 0 0 4px;padding:10px 14px;color:#475569;font-weight:600;text-align:center}
.uform-req{color:#ef4444}
.uform-field{flex:1}
.uform-input,.uform-select{
    width:100%;height:38px;border:1px solid #e3e7ee;border-left:0;border-radius:0 4px 4px 0;
    padding:0 12px;outline:none;color:#111827;background:#fff;
}
.uform-input:focus,.uform-select:focus{
    border-color:#fb923c; box-shadow:0 0 0 2px rgba(251,146,60,.25);
}

.uform-error{margin-top:6px;color:#b91c1c;font-size:13px}

.uform-actions{display:flex;gap:10px;justify-content:flex-end;padding:12px 4px}
.uform-btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:4px;padding:8px 12px;color:#fff;font-weight:700;cursor:pointer}
.uform-btn-save{background:#6ab47c}
.uform-btn-save:hover{filter:brightness(.95)}
.uform-btn-reset{background:#9aa9b8}
.uform-btn-reset:hover{filter:brightness(.95)}
</style>
@endsection
