@extends('layouts.app')
@section('title','Raw Material Product List')

@section('content')
<div class="rm-wrap">

  {{-- title bar --}}
  <div class="rm-topbar">
    <div class="rm-title">
      <i class="fa fa-list-ul"></i>
      <span>Raw Material Product List</span>
    </div>

    <a href="{{ route('products.raw-materials.create') }}" class="rm-add">
      <i class="fa fa-plus"></i> Create Product
    </a>
  </div>

  {{-- card --}}
  <div class="rm-card">
    <div class="rm-card-head">
      <div></div>
      <label class="rm-search">
        <span>Search:</span>
        <input type="text" oninput="rmFilter(this.value)" placeholder="">
      </label>
    </div>

    <div class="rm-table-wrap">
      <table id="rmTable" class="rm-table">
        <thead>
          <tr>
            <th style="width:64px">SL</th>
            <th style="width:145px">Image</th>
            <th>Product</th>
            <th style="width:220px">Category Name</th>
            <th style="width:160px">Opening Qty (Mon)</th>
            <th style="width:160px">Alert Qty (Mon)</th>
            <th style="width:140px">Date</th>
            <th style="width:150px">Action</th>
          </tr>
        </thead>

        <tbody>
          @forelse($products as $p)
            @php
              $sl = ($products instanceof \Illuminate\Pagination\LengthAwarePaginator)
                    ? $products->firstItem() + $loop->index
                    : $loop->iteration;
            @endphp
            <tr>
              <td>{{ $sl }}</td>
              <td class="rm-img">
                @if($p->image_path)
                  <img src="{{ asset($p->image_path) }}" alt="{{ $p->name }}">
                @else
                  <span>Not available</span>
                @endif
              </td>
              <td>{{ $p->name }}</td>
              <td>{{ $p->category->name ?? '—' }}</td>
              <td>{{ (int)($p->opening_qty ?? 0) }}</td>
              <td>{{ (int)($p->alert_qty ?? 0) }}</td>
              <td>{{ optional($p->created_at)->format('d/m/Y') }}</td>

              <td class="rm-actions">
                {{-- Info --}}
                <button type="button" class="rm-btn rm-blue" title="Info">
                    <i class="fa fa-info"></i>
                </button>

                {{-- Edit --}}
                <a href="{{ route('products.raw-materials.edit', $p->id) }}" class="rm-btn rm-green" title="Edit">
                    <i class="fa fa-pen"></i>
                </a>

                {{-- Delete --}}
                <form action="{{ route('products.raw-materials.destroy', $p->id) }}" method="POST" style="display:inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="rm-btn rm-red" title="Delete" onclick="return confirm('Delete this product?')">
                    <i class="fa fa-trash"></i>
                    </button>
                </form>
                </td>
            </tr>
          @empty
            <tr>
              <td colspan="8" class="rm-empty">No data available in table</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    @if($products instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="rm-paginate">{{ $products->links() }}</div>
    @endif
  </div>
</div>

{{-- ====== Styles (tuned to match screenshot 1) ====== --}}
<style>
.rm-wrap{margin-top:6px}

/* top bar */
.rm-topbar{
  display:flex;justify-content:space-between;align-items:center;
  background:#eef3f9;border:1px solid #e4ebf6;border-radius:4px 4px 0 0;
  padding:12px 14px;margin-bottom:0
}
.rm-title{display:flex;align-items:center;gap:10px;color:#2d5daa}
.rm-title .fa{color:#2b78c5;font-size:22px}
.rm-title span{font-size:28px;font-weight:600}

/* add button (blue like screenshot) */
.rm-add{
  display:inline-flex;align-items:center;gap:6px;text-decoration:none;
  background:#4aa8ff;border:1px solid #3793eb;color:#fff;
  padding:8px 12px;border-radius:4px;font-weight:600
}
.rm-add:hover{filter:brightness(.97)}

/* card */
.rm-card{border:1px solid #e4ebf6;border-top:0;background:#fff;border-radius:0 0 4px 4px}
.rm-card-head{
  display:flex;justify-content:space-between;align-items:center;
  padding:10px 12px;border-bottom:1px solid #e4ebf6;background:#f3f7fd
}

/* search */
.rm-search{display:flex;align-items:center;gap:8px;color:#3b4b5c}
.rm-search input{height:26px;width:190px;border:1px solid #cfd9e5;border-radius:3px;padding:0 6px}

/* table */
.rm-table{width:100%;border-collapse:collapse}
.rm-table thead th{
  padding:11px 10px;
  background:#d5e6ff;             /* pale blue header */
  color:#1f4b99;font-weight:700;
  border:1px solid #d7e1f0;font-size:15px
}
.rm-table tbody td{
  padding:10px;border:1px solid #ebf0f7;font-size:15px;color:#0f172a
}
.rm-table tbody tr:nth-child(odd){background:#fbfdff}

/* image cell */
.rm-img img{max-width:115px;max-height:72px;display:block}
.rm-img span{color:#6b7280}

/* action buttons: square small icons */
.rm-actions{display:flex;align-items:center;gap:6px}
.rm-btn{
  width:28px;height:28px;border-radius:4px;border:1px solid transparent;
  display:inline-flex;align-items:center;justify-content:center;color:#fff;cursor:pointer
}
.rm-green{background:#2fb36a;border-color:#249b5b}
.rm-red{background:#e2554f;border-color:#c24741}
.rm-blue{background:#2ea3f2;border-color:#248dd1}
.rm-btn .fa{font-size:13px}

/* empty row */
.rm-empty{color:#6b7280;text-align:center}

/* pagination container (if present) */
.rm-paginate{padding:10px 12px;border-top:1px solid #e4ebf6}
</style>

{{-- ====== Filter script ====== --}}
<script>
function rmFilter(q){
  const rows = document.querySelectorAll('#rmTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r=>{
    if(r.querySelector('td.rm-empty')){ r.style.display=''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}
</script>
@endsection
