@extends('layouts.app')
@section('title','Edit Product')

@section('content')
<div class="rpc">
  <div class="rpc-panel">
    <div class="rpc-head">
      <div class="rpc-left"><i class="fa fa-cog"></i><span>Edit Product</span></div>
      <a href="{{ route('products.raw-materials.index') }}" class="rpc-link"><i class="fa fa-list"></i> Product List</a>
    </div>

    <div class="rpc-body">
      <form action="{{ route('products.raw-materials.update', $product) }}" method="POST" enctype="multipart/form-data" autocomplete="off">
        @csrf @method('PUT')

        <div class="rpc-grid">
          {{-- row 1 --}}
          <div class="rpc-row @error('name') has-error @enderror">
            <div class="rpc-label">Product Name <span class="req">*</span></div>
            <div class="rpc-ctrl">
              <input type="text" name="name" class="rpc-input" value="{{ old('name', $product->name) }}" required>
              @error('name') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>
          <div class="rpc-row @error('alert_qty') has-error @enderror">
            <div class="rpc-label">Alert Quantity</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="alert_qty" class="rpc-input"
                     value="{{ old('alert_qty', $product->alert_quantity) }}"
                     placeholder="Enter the Alert Quantity">
              @error('alert_qty') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- row 2 --}}
          <div class="rpc-row @error('category_id') has-error @enderror">
            <div class="rpc-label">Category <span class="req">*</span></div>
            <div class="rpc-ctrl">
              <select name="category_id" class="rpc-select" required>
                @foreach($categories as $c)
                  <option value="{{ $c->id }}"
                    {{ (string)old('category_id', (string)$product->category_id)==(string)$c->id ? 'selected' : '' }}>
                    {{ $c->name }}
                  </option>
                @endforeach
              </select>
              @error('category_id') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>
          <div class="rpc-row @error('vat') has-error @enderror">
            <div class="rpc-label">VAT</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="vat" class="rpc-input"
                     value="{{ old('vat', $product->vat) }}" placeholder="Enter the VAT">
              @error('vat') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- row 3 --}}
          <div class="rpc-row @error('supplier_id') has-error @enderror">
            <div class="rpc-label">Supplier</div>
            <div class="rpc-ctrl">
              <select name="supplier_id" class="rpc-select">
                <option value="">-Supplier Name-</option>
                @foreach($suppliers as $s)
                  <option value="{{ $s->id }}"
                    {{ (string)old('supplier_id', (string)$product->supplier_id)==(string)$s->id ? 'selected' : '' }}>
                    {{ $s->name }}
                  </option>
                @endforeach
              </select>
              @error('supplier_id') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>
          <div class="rpc-row @error('image') has-error @enderror">
            <div class="rpc-label">Image</div>
            <div class="rpc-ctrl">
              <input type="file" name="image" class="rpc-input">
              @error('image') <div class="rpc-help">{{ $message }}</div> @enderror
              <div style="margin-top:6px;font-size:13px;color:#6b7280">
                @if(!empty($product->image))
                  <img src="{{ asset($product->image) }}" alt="image" style="max-width:140px;max-height:90px;display:block">
                @else
                  Not available
                @endif
              </div>
            </div>
          </div>

          {{-- row 4 --}}
          <div class="rpc-row @error('status') has-error @enderror">
            <div class="rpc-label">Status</div>
            <div class="rpc-ctrl">
              @php $sv = (string)old('status', (string)$product->status); @endphp
              <select name="status" class="rpc-select">
                <option value="1" {{ $sv==='1' ? 'selected' : '' }}>Active</option>
                <option value="0" {{ $sv==='0' ? 'selected' : '' }}>Inactive</option>
              </select>
              @error('status') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>
          <div class="rpc-row @error('description') has-error @enderror">
            <div class="rpc-label">Description</div>
            <div class="rpc-ctrl">
              <input type="text" name="description" class="rpc-input"
                     value="{{ old('description', $product->description) }}"
                     placeholder="Enter the product Description">
              @error('description') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- row 5 --}}
          <div class="rpc-row">
            <div class="rpc-label">Type <span class="req">*</span></div>
            <div class="rpc-ctrl">
              <select class="rpc-select" disabled>
                <option selected>Raw Material</option>
              </select>
            </div>
          </div>
          <div class="rpc-row @error('price') has-error @enderror">
            <div class="rpc-label">Prod. Price (Mon)</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="price" class="rpc-input"
                     value="{{ old('price', $product->product_price) }}"
                     placeholder="Enter the product Price">
              @error('price') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>
        </div>

        <div class="rpc-actions">
          <button type="submit" class="btn-ico btn-green"><i class="fa fa-save"></i> Update</button>
          <button type="reset" class="btn-ico btn-gray"><i class="fa fa-refresh"></i> Reset</button>
        </div>
      </form>
    </div>
  </div>
</div>

<style>
/* same visual system as your other product pages */
.rpc{padding:10px}
.rpc-panel{border:1px solid #d9d9d9;border-radius:2px;background:#fff}
.rpc-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid #e6e6e6;background:linear-gradient(#f7f7f7,#ececec)}
.rpc-left{display:flex;gap:8px;align-items:center;color:#2b78c5;font-weight:600}
.rpc-link{border:1px solid #c7d7ea;background:#f3f8ff;color:#2b78c5;padding:6px 10px;border-radius:2px;text-decoration:none}
.rpc-body{padding:14px}
.rpc-grid{display:grid;grid-template-columns:1fr 1fr;gap:12px 22px}
.rpc-row{display:flex;align-items:center}
.rpc-label{width:160px;min-width:160px;background:#f0f2f5;border:1px solid #d9d9d9;border-right:none;border-radius:3px 0 0 3px;padding:10px 14px;text-align:left;font-weight:600;color:#666}
.rpc-ctrl{flex:1}
.rpc-input,.rpc-select{width:100%;height:36px;border:1px solid #d9d9d9;border-radius:0 3px 3px 0;padding:9px 12px;background:#fff}
.rpc-actions{text-align:right;margin-top:12px}
.btn-ico{display:inline-flex;gap:8px;align-items:center;padding:9px 14px;border-radius:3px;border:1px solid transparent;font-weight:600;cursor:pointer}
.btn-green{background:#7dbd71;border-color:#6fb064;color:#fff}
.btn-gray{background:#e7edf3;border-color:#d4dbe2;color:#3b4b5c}
.req{color:#e23b3b}
.rpc-help{margin-top:6px;color:#a94442}
.has-error .rpc-input,.has-error .rpc-select{border-color:#a94442}
@media (max-width:1100px){.rpc-grid{grid-template-columns:1fr}}
</style>
@endsection