@extends('layouts.app')
@section('title','Create Raw Product')

@section('content')
<div class="rpc">
  <div class="rpc-panel">
    <div class="rpc-head">
      <div class="rpc-left"><i class="fa fa-cog"></i><span>Create Raw Product</span></div>
      <a href="{{ route('products.raw-materials.index') }}" class="rpc-link"><i class="fa fa-list"></i> Product List</a>
    </div>

    <div class="rpc-body">
      <form action="{{ route('products.raw-materials.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
        @csrf

        <div class="rpc-grid">
          {{-- Product Name --}}
          <div class="rpc-row @error('name') has-error @enderror">
            <div class="rpc-label">Product Name <span class="req">*</span></div>
            <div class="rpc-ctrl">
              <input type="text" name="name" class="rpc-input" placeholder="Enter Product Name" value="{{ old('name') }}" required>
              @error('name') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Ware --}}
          <div class="rpc-row @error('warehouse_id') has-error @enderror">
            <div class="rpc-label">Ware <span class="req">*</span></div>
            <div class="rpc-ctrl">
              <select name="warehouse_id" class="rpc-select" required>
                <option value="">-Select Warehouse-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}" {{ old('warehouse_id')==$w->id ? 'selected':'' }}>{{ $w->name }}</option>
                @endforeach
              </select>
              @error('warehouse_id') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Category (rm_categories) --}}
          <div class="rpc-row @error('category_id') has-error @enderror">
            <div class="rpc-label">Category <span class="req">*</span></div>
            <div class="rpc-ctrl">
              <select name="category_id" class="rpc-select" required>
                <option value="">-Category Name-</option>
                @foreach($categories as $c)
                  <option value="{{ $c->id }}" {{ old('category_id')==$c->id ? 'selected':'' }}>{{ $c->name }}</option>
                @endforeach
              </select>
              @error('category_id') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Opening Qty --}}
          <div class="rpc-row @error('opening_qty') has-error @enderror">
            <div class="rpc-label">Opening Qty(Mon)</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="opening_qty" class="rpc-input" placeholder="Enter the Opening Quantity" value="{{ old('opening_qty') }}">
              @error('opening_qty') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Supplier (rm_suppliers) --}}
          <div class="rpc-row @error('supplier_id') has-error @enderror">
            <div class="rpc-label">Supplier</div>
            <div class="rpc-ctrl">
              <select name="supplier_id" class="rpc-select">
                <option value="">-Supplier Name-</option>
                @foreach($suppliers as $s)
                  <option value="{{ $s->id }}" {{ old('supplier_id')==$s->id ? 'selected':'' }}>{{ $s->name }}</option>
                @endforeach
              </select>
              @error('supplier_id') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Alert Quantity --}}
          <div class="rpc-row @error('alert_qty') has-error @enderror">
            <div class="rpc-label">Alert Quantity</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="alert_qty" class="rpc-input" placeholder="Enter the Alert Quantity" value="{{ old('alert_qty') }}">
              @error('alert_qty') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Status --}}
          <div class="rpc-row @error('status') has-error @enderror">
            <div class="rpc-label">Status</div>
            <div class="rpc-ctrl">
              <select name="status" class="rpc-select">
                <option value="1" {{ old('status','1')=='1' ? 'selected':'' }}>Active</option>
                <option value="0" {{ old('status')==='0' ? 'selected':'' }}>Inactive</option>
              </select>
              @error('status') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- VAT --}}
          <div class="rpc-row @error('vat') has-error @enderror">
            <div class="rpc-label">VAT</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="vat" class="rpc-input" placeholder="Enter the VAT" value="{{ old('vat') }}">
              @error('vat') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Price --}}
          <div class="rpc-row @error('price') has-error @enderror">
            <div class="rpc-label">Prod. Price (Mon)</div>
            <div class="rpc-ctrl">
              <input type="number" step="any" name="price" class="rpc-input" placeholder="Enter Product Price" value="{{ old('price') }}">
              @error('price') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Image --}}
          <div class="rpc-row @error('image') has-error @enderror">
            <div class="rpc-label">Image</div>
            <div class="rpc-ctrl">
              <input type="file" name="image" class="rpc-input" accept="image/*">
              @error('image') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>

          {{-- Description full width --}}
          <div class="rpc-row rpc-row-full @error('description') has-error @enderror">
            <div class="rpc-label">Description</div>
            <div class="rpc-ctrl">
              <textarea name="description" rows="3" class="rpc-input" placeholder="Enter the product Description">{{ old('description') }}</textarea>
              @error('description') <div class="rpc-help">{{ $message }}</div> @enderror
            </div>
          </div>
        </div>

        <div class="rpc-actions">
          <button type="submit" class="btn-ico btn-green"><i class="fa fa-save"></i> Save</button>
          <button type="reset" class="btn-ico btn-gray"><i class="fa fa-refresh"></i> Reset</button>
        </div>
      </form>
    </div>
  </div>
</div>

<style>
.rpc{padding:10px}
.rpc-panel{border:1px solid #d9d9d9;border-radius:2px;background:#fff}
.rpc-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid #e6e6e6;background:linear-gradient(#f7f7f7,#ececec)}
.rpc-left{display:flex;gap:8px;align-items:center;color:#2b78c5;font-weight:600}
.rpc-link{border:1px solid #c7d7ea;background:#f3f8ff;color:#2b78c5;padding:6px 10px;border-radius:2px;text-decoration:none}
.rpc-body{padding:14px}
.rpc-grid{display:grid;grid-template-columns:1fr 1fr;gap:10px 22px}
.rpc-row{display:flex;align-items:center}
.rpc-row-full{grid-column:1 / -1}
.rpc-label{width:170px;min-width:170px;background:#f0f2f5;border:1px solid #d9d9d9;border-right:none;border-radius:3px 0 0 3px;padding:10px 14px;text-align:center;font-weight:600;color:#666}
.rpc-ctrl{flex:1}
.rpc-input,.rpc-select,textarea.rpc-input{width:100%;height:36px;border:1px solid #d9d9d9;border-radius:0 3px 3px 0;padding:9px 12px;background:#fff}
textarea.rpc-input{height:auto}
.rpc-actions{text-align:right;margin-top:12px}
.btn-ico{display:inline-flex;gap:8px;align-items:center;padding:9px 14px;border-radius:3px;border:1px solid transparent;font-weight:600;cursor:pointer}
.btn-green{background:#7dbd71;border-color:#6fb064;color:#fff}
.btn-gray{background:#e7edf3;border-color:#d4dbe2;color:#3b4b5c}
.req{color:#e23b3b}
.rpc-help{margin-top:6px;color:#a94442}
.has-error .rpc-input,.has-error .rpc-select, .has-error textarea{border-color:#a94442}
@media (max-width:1100px){.rpc-grid{grid-template-columns:1fr}}
</style>
@endsection

