@extends('layouts.app')
@section('title','Mill List')

@section('content')
<div class="mlx">

  {{-- ===== Title row ===== --}}
  <div class="mlx-titlebar">
    <div class="mlx-title">
      <i class="fa fa-list-ul"></i>
      <span>Mill List</span>
    </div>

    <a href="{{ route('products.mills.create') }}" class="mlx-add-btn">
      <i class="fa fa-plus"></i> Add Mill
    </a>
  </div>

  {{-- ===== Card/Table ===== --}}
  <div class="mlx-card">
    <div class="mlx-card-head">
      <div></div>
      <label class="mlx-search">
        <span>Search:</span>
        <input type="text" oninput="mlxFilter(this.value)" placeholder="">
      </label>
    </div>

    <div class="mlx-table-wrap">
      <table class="mlx-table" id="mlxTable">
        <thead>
          <tr>
            <th style="width:70px">SL</th>
            <th>Mill Name</th>
            <th style="width:180px">Status</th>
            <th style="width:200px">Action</th>
          </tr>
        </thead>
        <tbody>
          @forelse($mills as $mill)
            @php
              $sl = ($mills instanceof \Illuminate\Pagination\LengthAwarePaginator)
                    ? $mills->firstItem() + $loop->index
                    : $loop->iteration;
              $active = (string)($mill->status ?? '1') === '1';
            @endphp
            <tr>
              <td>{{ $sl }}</td>
              <td>{{ $mill->name }}</td>
              <td>
                @if($active)
                  <span class="mlx-badge mlx-badge-green">Active</span>
                @else
                  <span class="mlx-badge">Inactive</span>
                @endif
              </td>
              <td class="mlx-actions">
                <a class="mlx-btn mlx-btn-green" title="Edit"
                   href="{{ route('products.mills.edit', $mill->id) }}">
                  <i class="fa fa-pen"></i>
                </a>

                <form action="{{ route('products.mills.destroy', $mill->id) }}"
                      method="POST" style="display:inline">
                  @csrf
                  @method('DELETE')
                  <button type="submit" class="mlx-btn mlx-btn-red" title="Delete"
                          onclick="return confirm('Delete this mill?')">
                    <i class="fa fa-trash"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="4" style="color:#6b7280">No data available in table</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- Pagination --}}
    @if($mills instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="mlx-paginate">
        {{ $mills->links() }}
      </div>
    @endif
  </div>
</div>

{{-- ===== Styles (scoped to avoid conflicts) ===== --}}
<style>
.mlx{margin-top:6px}
.mlx-titlebar{display:flex;align-items:center;justify-content:space-between;margin-bottom:10px}
.mlx-title{display:flex;align-items:center;gap:10px;color:#1f4b99}
.mlx-title .fa{color:#1f7bd8;font-size:22px}
.mlx-title span{font-size:26px;font-weight:600}

.mlx-add-btn{
  background:#7ab7e3;color:#fff;border:1px solid #6aa7d5;text-decoration:none;
  padding:7px 11px;border-radius:3px;font-size:14px;display:inline-flex;align-items:center;gap:6px
}
.mlx-add-btn .fa{font-size:12px}
.mlx-add-btn:hover{filter:brightness(.97)}

.mlx-card{border:1px solid #dbe3ee;border-radius:3px;background:#fff}
.mlx-card-head{
  display:flex;align-items:center;justify-content:space-between;
  padding:10px 12px;border-bottom:1px solid #dbe3ee;background:#eef3f9
}
.mlx-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.mlx-search input{height:26px;width:180px;border:1px solid #cfd9e5;border-radius:2px;padding:0 6px;outline:none}
.mlx-search input:focus{border-color:#89b8ef;box-shadow:0 0 0 2px rgba(49,132,255,.15)}

.mlx-table{width:100%;border-collapse:collapse}
.mlx-table thead th{
  text-align:left;padding:10px;background:linear-gradient(180deg,#f5f7fb 0%,#e9edf3 100%);
  border:1px solid #e2e8f0;color:#1f4b99;font-weight:700;font-size:14px
}
.mlx-table tbody td{padding:10px;border:1px solid #e9eef5;font-size:14px;color:#111827}
.mlx-table tbody tr:nth-child(odd){background:#fafcfe}

.mlx-badge{display:inline-block;padding:3px 8px;border-radius:2px;font-size:12px;background:#e6e7eb;color:#374151;font-weight:700}
.mlx-badge-green{background:#8be27d;color:#0e4b15}

.mlx-actions{display:flex;align-items:center;gap:6px}
.mlx-btn{
  width:26px;height:26px;border-radius:2px;display:inline-flex;align-items:center;justify-content:center;
  color:#fff;border:1px solid transparent;text-decoration:none;cursor:pointer
}
.mlx-btn .fa{font-size:13px}
.mlx-btn-green{background:#38b36b;border-color:#2e9a5b}
.mlx-btn-red{background:#e2554f;border-color:#c24741}
.mlx-paginate{padding:10px 12px;border-top:1px solid #e9edf3}
</style>

{{-- ===== Scripts ===== --}}
<script>
function mlxFilter(q){
  const rows = document.querySelectorAll('#mlxTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => {
    if (r.querySelector('td[colspan]')) { r.style.display=''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}
</script>
@endsection
