@extends('layouts.app')
@section('title','Finish Product List')

@section('content')
<div class="fp-wrap">

  {{-- Title bar --}}
  <div class="fp-topbar">
    <div class="fp-title">
      <i class="fa fa-list-ul"></i>
      <span>Finish Product List</span>
    </div>

    <a href="{{ route('products.finish-products.create') }}" class="fp-add">
      <i class="fa fa-plus"></i> Create Product
    </a>
  </div>

  {{-- Card --}}
  <div class="fp-card">
    <div class="fp-card-head">
      <div></div>
      <label class="fp-search">
        <span>Search:</span>
        <input type="text" oninput="fpFilter(this.value)" placeholder="">
      </label>
    </div>

    <div class="fp-table-wrap">
      <table id="fpTable" class="fp-table">
        <thead>
          <tr>
            <th style="width:64px">SL</th>
            <th style="width:145px">Image</th>
            <th>Product</th>
            <th style="width:220px">Category Name</th>
            <th style="width:170px">Opening Qty (Kg)</th>
            <th style="width:160px">Stock Type</th>
            <th style="width:170px">Conversion To Kg</th>
            <th style="width:120px">Vat</th>
            <th style="width:140px">Date</th>
            <th style="width:150px">Action</th>
          </tr>
        </thead>

        <tbody>
          @forelse($products as $p)
            @php
              $sl = ($products instanceof \Illuminate\Pagination\LengthAwarePaginator)
                    ? $products->firstItem() + $loop->index
                    : $loop->iteration;
              $typeVal  = $p->stock_type ?? 1;
              $typeText = in_array(strtolower((string)$typeVal), ['production','purchase'])
                            ? ucfirst($typeVal)
                            : ((string)$typeVal === '2' ? 'Purchase' : 'Production');
            @endphp
            <tr>
              <td>{{ $sl }}</td>

              {{-- Image --}}
              <td class="fp-img">
                @if(!empty($p->image_path))
                  <img src="{{ asset($p->image_path) }}" alt="{{ $p->name }}">
                @else
                  <span>Not available</span>
                @endif
              </td>

              <td>{{ $p->name }}</td>
              <td>{{ $p->category->name ?? '—' }}</td>
              <td>{{ number_format((float)($p->opening_qty_kg ?? $p->opening_qty ?? 0), 2) }}</td>

              <td>
                <span class="fp-badge fp-badge-green">{{ $typeText }}</span>
              </td>

              <td>{{ number_format((float)($p->conversion_to_kg ?? 0), 2) }}</td>
              <td>{{ rtrim(rtrim(number_format((float)($p->vat ?? 0), 2), '0'), '.') }}</td>
              <td>{{ optional($p->created_at)->format('d/m/Y') }}</td>

              {{-- Actions: info, edit, delete --}}
              <td class="fp-actions">
                <button type="button" class="fp-btn fp-blue" title="Info">
                  <i class="fa fa-info"></i>
                </button>

                <a href="{{ route('products.finish-products.edit', $p->id) }}"
                   class="fp-btn fp-green" title="Edit">
                  <i class="fa fa-pen"></i>
                </a>

                <form action="{{ route('products.finish-products.destroy', $p->id) }}"
                      method="POST" style="display:inline">
                  @csrf @method('DELETE')
                  <button type="submit" class="fp-btn fp-red" title="Delete"
                          onclick="return confirm('Delete this product?')">
                    <i class="fa fa-trash"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="10" class="fp-empty">No data available in table</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    @if($products instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="fp-paginate">{{ $products->links() }}</div>
    @endif
  </div>
</div>

{{-- ===== Styles: matches the screenshot ===== --}}
<style>
.fp-wrap{margin-top:6px}
.fp-topbar{
  display:flex;justify-content:space-between;align-items:center;
  background:#eef3f9;border:1px solid #e4ebf6;border-radius:4px 4px 0 0;
  padding:12px 14px;margin-bottom:0
}
.fp-title{display:flex;align-items:center;gap:10px;color:#2d5daa}
.fp-title .fa{color:#2b78c5;font-size:22px}
.fp-title span{font-size:28px;font-weight:600}
.fp-add{
  display:inline-flex;align-items:center;gap:6px;text-decoration:none;
  background:#4aa8ff;border:1px solid #3793eb;color:#fff;
  padding:8px 12px;border-radius:4px;font-weight:600
}
.fp-card{border:1px solid #e4ebf6;border-top:0;background:#fff;border-radius:0 0 4px 4px}
.fp-card-head{
  display:flex;justify-content:space-between;align-items:center;
  padding:10px 12px;border-bottom:1px solid #e4ebf6;background:#f3f7fd
}
.fp-search{display:flex;align-items:center;gap:8px;color:#3b4b5c}
.fp-search input{height:26px;width:190px;border:1px solid #cfd9e5;border-radius:3px;padding:0 6px}
.fp-table{width:100%;border-collapse:collapse}
.fp-table thead th{
  padding:11px 10px;background:#d5e6ff;color:#1f4b99;font-weight:700;
  border:1px solid #d7e1f0;font-size:15px
}
.fp-table tbody td{padding:10px;border:1px solid #ebf0f7;font-size:15px;color:#0f172a}
.fp-table tbody tr:nth-child(odd){background:#fbfdff}
.fp-img img{max-width:115px;max-height:72px;display:block}
.fp-img span{color:#6b7280}
.fp-badge{display:inline-block;padding:4px 8px;border-radius:3px;font-weight:700;font-size:12px;border:1px solid transparent}
.fp-badge-green{background:#8be27d;color:#0e4b15;border-color:#7bd66c}
.fp-actions{display:flex;align-items:center;gap:6px}
.fp-btn{
  width:28px;height:28px;border-radius:4px;border:1px solid transparent;
  display:inline-flex;align-items:center;justify-content:center;color:#fff;cursor:pointer
}
.fp-blue{background:#2ea3f2;border-color:#248dd1}
.fp-green{background:#38b36b;border-color:#2e9a5b}
.fp-red{background:#e2554f;border-color:#c24741}
.fp-btn .fa{font-size:13px}
.fp-empty{color:#6b7280;text-align:center}
.fp-paginate{padding:10px 12px;border-top:1px solid #e4ebf6}
</style>

{{-- simple client-side filter --}}
<script>
function fpFilter(q){
  const rows = document.querySelectorAll('#fpTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r=>{
    if(r.querySelector('td.fp-empty')){ r.style.display=''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}
</script>
@endsection

