@extends('layouts.app')

@section('title', 'Edit Product')

@section('content')
<style>
  .card-flat { border: 1px solid #e5e7eb; box-shadow: none; }
  .form-label { font-weight: 600; }
  .input-help { font-size: .85rem; color: #6b7280; }
  .toolbar { display:flex; align-items:center; justify-content:space-between; }
  .toolbar .title { font-size: 1.25rem; font-weight:700; }
  .btn-list { white-space: nowrap; }
  .required::after { content: ' *'; color: #e11d48; }
</style>

<div class="container-fluid">
  <div class="toolbar mb-3">
    <div class="title"><i class="bi bi-pencil-square me-2"></i>Edit Product</div>
    <div class="btn-list">
      <a href="{{ route('finish-products.index') }}" class="btn btn-outline-primary btn-sm">
        <i class="bi bi-card-list me-1"></i> Product List
      </a>
    </div>
  </div>

  <div class="card card-flat">
    <div class="card-body">
      <form action="{{ route('finish-products.update', $product->id) }}" method="POST" enctype="multipart/form-data" autocomplete="off">
        @csrf
        @method('PUT')

        {{-- Validation summary --}}
        @if ($errors->any())
          <div class="alert alert-danger">
            <div class="fw-semibold mb-1">Please fix the following:</div>
            <ul class="mb-0">
              @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
        @endif

        <div class="row g-3">
          {{-- LEFT COLUMN --}}
          <div class="col-lg-6">

            <div class="mb-3">
              <label class="form-label required">Product Name</label>
              <input type="text" name="name" value="{{ old('name', $product->name) }}" class="form-control" placeholder="Enter Product Name" required>
            </div>

            <div class="mb-3">
              <label class="form-label required">Category</label>
              <select name="category_id" class="form-select" required>
                <option value="">Select Category</option>
                @foreach($categories as $cat)
                  <option value="{{ $cat->id }}" {{ (old('category_id', $product->category_id) == $cat->id) ? 'selected' : '' }}>{{ $cat->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label">Supplier</label>
              <select name="supplier_id" class="form-select">
                <option value="">-Supplier Name-</option>
                @foreach($suppliers as $sup)
                  <option value="{{ $sup->id }}" {{ (old('supplier_id', $product->supplier_id) == $sup->id) ? 'selected' : '' }}>{{ $sup->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label">Status</label>
              <select name="status" class="form-select">
                @php($status = old('status', $product->status ?? 'active'))
                <option value="active" {{ $status==='active' ? 'selected' : '' }}>Active</option>
                <option value="inactive" {{ $status==='inactive' ? 'selected' : '' }}>Inactive</option>
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label required">Type</label>
              <select name="type" class="form-select" required>
                @php($typeVal = old('type', $product->type ?? 'Finish Good'))
                @foreach(($types ?? ['Finish Good','Raw','WIP']) as $type)
                  <option value="{{ $type }}" {{ $typeVal==$type ? 'selected' : '' }}>{{ $type }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label required">Unit</label>
              <select name="unit" class="form-select" required>
                @php($u = old('unit', $product->unit ?? 'Kg'))
                @foreach(($units ?? ['Kg','g','Lb','Bag','Piece']) as $unit)
                  <option value="{{ $unit }}" {{ $u==$unit ? 'selected' : '' }}>{{ $unit }}</option>
                @endforeach
              </select>
            </div>

            <div class="mb-3">
              <label class="form-label required">Bag Type</label>
              <select name="bag_type" class="form-select" required>
                @php($bag = old('bag_type', $product->bag_type ?? '25kg bag'))
                @foreach(($bagTypes ?? ['25kg bag','50kg bag','Custom']) as $b)
                  <option value="{{ $b }}" {{ $bag==$b ? 'selected' : '' }}>{{ $b }}</option>
                @endforeach
              </select>
            </div>
          </div>

          {{-- RIGHT COLUMN --}}
          <div class="col-lg-6">
            <div class="mb-3">
              <label class="form-label">Alert Quantity</label>
              <input type="number" name="alert_qty" value="{{ old('alert_qty', $product->alert_qty) }}" class="form-control" placeholder="Enter the Alert Quantity" min="0" step="1">
            </div>

            <div class="mb-3">
              <label class="form-label">VAT</label>
              <input type="number" name="vat" value="{{ old('vat', $product->vat) }}" class="form-control" placeholder="Enter the VAT" step="0.01" min="0">
            </div>

            <div class="mb-3">
              <label class="form-label">Image</label>
              <div class="input-group">
                <input class="form-control" type="file" name="image" accept="image/*">
                @if($product->image_path)
                  <a href="{{ Storage::url($product->image_path) }}" target="_blank" class="btn btn-outline-secondary">Current</a>
                @endif
              </div>
              <div class="input-help">No File …</div>
            </div>

            <div class="mb-3">
              <label class="form-label">Description</label>
              <textarea name="description" rows="2" class="form-control" placeholder="Enter the product Description">{{ old('description', $product->description) }}</textarea>
            </div>

            <div class="mb-3">
              <label class="form-label d-block">Stock Type</label>
              @php($stock = old('stock_type', $product->stock_type ?? 'production'))
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="stock_type" id="stock_production" value="production" {{ $stock==='production' ? 'checked' : '' }}>
                <label class="form-check-label" for="stock_production">Production</label>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="radio" name="stock_type" id="stock_purchase" value="purchase" {{ $stock==='purchase' ? 'checked' : '' }}>
                <label class="form-check-label" for="stock_purchase">Purchase</label>
              </div>
            </div>

            <div class="mb-3">
              <label class="form-label">Prod. Price (Kg)</label>
              <input type="number" name="price_per_kg" value="{{ old('price_per_kg', $product->price_per_kg) }}" class="form-control" placeholder="Enter the product Price" step="0.01" min="0">
              <div class="input-help">Not available</div>
            </div>
          </div>
        </div>

        <div class="d-flex justify-content-end gap-2 mt-3">
          <button type="submit" class="btn btn-success">
            <i class="bi bi-check2-circle me-1"></i> Update
          </button>
          <button type="reset" class="btn btn-secondary">
            <i class="bi bi-arrow-repeat me-1"></i> Reset
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection
