@extends('layouts.app')
@section('title','Create Finish Product')

@section('content')
<div class="fp-wrap">
  {{-- header bar --}}
  <div class="fp-head">
    <div class="fp-title">
      <i class="fa fa-cog"></i>
      <span>Create Finish Product</span>
    </div>
    <a href="{{ route('products.finish-products.index') }}" class="fp-list">
      <i class="fa fa-list"></i> Product List
    </a>
  </div>

  <form action="{{ route('products.finish-products.store') }}" method="POST" enctype="multipart/form-data" autocomplete="off">
    @csrf

    <div class="fp-grid">
      {{-- LEFT COLUMN --}}
      <div class="fp-col">
        {{-- Product Name --}}
        <div class="fp-row @error('name') has-error @enderror">
          <div class="fp-label">Product Name <span class="req">*</span></div>
          <div class="fp-ctrl">
            <input type="text" name="name" class="fp-input"
                   placeholder="Enter Product Name" value="{{ old('name') }}">
            @error('name')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Category --}}
        <div class="fp-row @error('category_id') has-error @enderror">
          <div class="fp-label">Category <span class="req">*</span></div>
          <div class="fp-ctrl">
            <select name="category_id" class="fp-select">
              <option value="">-Category Name-</option>
              @foreach(($categories ?? []) as $c)
                @php
                  $cid = is_object($c) ? ($c->id ?? null) : (is_array($c) ? ($c['id'] ?? null) : null);
                  $clb = is_object($c) ? ($c->name ?? $c->label ?? $c->title ?? '') :
                        (is_array($c) ? ($c['name'] ?? $c['label'] ?? $c['title'] ?? '') : (string)$c);
                @endphp
                @if($cid)<option value="{{ $cid }}" {{ old('category_id')==$cid?'selected':'' }}>{{ $clb }}</option>@endif
              @endforeach
            </select>
            @error('category_id')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Supplier --}}
        <div class="fp-row @error('supplier_id') has-error @enderror">
          <div class="fp-label">Supplier</div>
          <div class="fp-ctrl">
            <select name="supplier_id" class="fp-select">
              <option value="">-Supplier Name-</option>
              @foreach(($suppliers ?? []) as $s)
                @php
                  $sid = is_object($s) ? ($s->id ?? null) : (is_array($s) ? ($s['id'] ?? null) : null);
                  $slb = is_object($s) ? ($s->name ?? $s->label ?? $s->title ?? '') :
                        (is_array($s) ? ($s['name'] ?? $s['label'] ?? $s['title'] ?? '') : (string)$s);
                @endphp
                @if($sid)<option value="{{ $sid }}" {{ old('supplier_id')==$sid?'selected':'' }}>{{ $slb }}</option>@endif
              @endforeach
            </select>
            @error('supplier_id')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Status --}}
        <div class="fp-row">
          <div class="fp-label">Status</div>
          <div class="fp-ctrl">
            @php $sv=(string)old('status','1'); @endphp
            <select name="status" class="fp-select">
              <option value="1" {{ $sv==='1'?'selected':'' }}>Active</option>
              <option value="0" {{ $sv==='0'?'selected':'' }}>Inactive</option>
            </select>
          </div>
        </div>

        {{-- Unit Name --}}
        <div class="fp-row @error('unit_id') has-error @enderror">
          <div class="fp-label">Unit Name <span class="req">*</span></div>
          <div class="fp-ctrl">
            <select name="unit_id" class="fp-select">
              <option value="">-Select Unit-</option>
              @foreach(($units ?? []) as $u)
                @php
                  $uid = is_object($u) ? ($u->id ?? null) : (is_array($u) ? ($u['id'] ?? null) : null);
                  $ulb = is_object($u) ? ($u->name ?? $u->label ?? $u->title ?? '') :
                        (is_array($u) ? ($u['name'] ?? $u['label'] ?? $u['title'] ?? '') : (string)$u);
                @endphp
                @if($uid)<option value="{{ $uid }}" {{ old('unit_id')==$uid?'selected':'' }}>{{ $ulb }}</option>@endif
              @endforeach
            </select>
            @error('unit_id')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Bag Size --}}
        <div class="fp-row @error('bag_size_id') has-error @enderror">
          <div class="fp-label">Bag Size <span class="req">*</span></div>
          <div class="fp-ctrl">
            <select name="bag_size_id" class="fp-select">
              <option value="">No Conversion</option>
              @foreach(($bagSizes ?? []) as $b)
                @php
                  $bid = is_object($b) ? ($b->id ?? null) : (is_array($b) ? ($b['id'] ?? null) : null);
                  $blb = is_object($b) ? ($b->name ?? $b->label ?? $b->title ?? '') :
                        (is_array($b) ? ($b['name'] ?? $b['label'] ?? $b['title'] ?? '') : (string)$b);
                @endphp
                @if($bid)<option value="{{ $bid }}" {{ old('bag_size_id')==$bid?'selected':'' }}>{{ $blb }}</option>@endif
              @endforeach
            </select>
            @error('bag_size_id')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Prod. Price (Kg) --}}
        <div class="fp-row @error('price_per_kg') has-error @enderror">
          <div class="fp-label">Prod. Price (Kg)</div>
          <div class="fp-ctrl">
            <input type="number" step="0.01" name="price_per_kg" class="fp-input"
                   placeholder="Enter the product Price" value="{{ old('price_per_kg') }}">
            @error('price_per_kg')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>
      </div>

      {{-- RIGHT COLUMN --}}
      <div class="fp-col">
        {{-- Ware + Opening Qty --}}
        <div class="fp-row @error('warehouse_id') has-error @enderror">
          <div class="fp-label">Ware <span class="req">*</span></div>
          <div class="fp-ctrl fp-inline">
            <select name="warehouse_id" class="fp-select">
              <option value="">-Select Warehouse-</option>
              @foreach(($warehouses ?? []) as $w)
                @php
                  $wid = is_object($w) ? ($w->id ?? null) : (is_array($w) ? ($w['id'] ?? null) : null);
                  $wlb = is_object($w) ? ($w->name ?? $w->label ?? $w->title ?? '') :
                        (is_array($w) ? ($w['name'] ?? $w['label'] ?? $w['title'] ?? '') : (string)$w);
                @endphp
                @if($wid)<option value="{{ $wid }}" {{ old('warehouse_id')==$wid?'selected':'' }}>{{ $wlb }}</option>@endif
              @endforeach
            </select>

            <div class="fp-label mini">Opening Qty(Kg)</div>
            <input type="number" step="0.001" name="opening_qty" class="fp-input mini @error('opening_qty') is-bad @enderror"
                   placeholder="Enter the Opening Quantity" value="{{ old('opening_qty') }}">
          </div>
          @error('warehouse_id')<div class="fp-help">{{ $message }}</div>@enderror
          @error('opening_qty') <div class="fp-help">{{ $message }}</div>@enderror
        </div>

        {{-- Alert Quantity --}}
        <div class="fp-row @error('alert_qty') has-error @enderror">
          <div class="fp-label">Alert Quantity</div>
          <div class="fp-ctrl">
            <input type="number" step="0.001" name="alert_qty" class="fp-input"
                   placeholder="Enter the Alert Quantity" value="{{ old('alert_qty') }}">
            @error('alert_qty')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- VAT --}}
        <div class="fp-row @error('vat') has-error @enderror">
          <div class="fp-label">VAT</div>
          <div class="fp-ctrl">
            <input type="number" step="0.01" name="vat" class="fp-input"
                   placeholder="Enter the VAT" value="{{ old('vat') }}">
            @error('vat')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Image --}}
        <div class="fp-row @error('image') has-error @enderror">
          <div class="fp-label">Image</div>
          <div class="fp-ctrl">
            <input type="file" name="image" class="fp-file">
            @error('image')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Description --}}
        <div class="fp-row @error('description') has-error @enderror">
          <div class="fp-label">Description</div>
          <div class="fp-ctrl">
            <textarea name="description" rows="2" class="fp-input" placeholder="Enter the product Description">{{ old('description') }}</textarea>
            @error('description')<div class="fp-help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Stock Type --}}
        <div class="fp-row @error('stock_type') has-error @enderror">
          <div class="fp-label">Stock Type <span class="req">*</span></div>
          <div class="fp-ctrl fp-radios">
            <label class="fp-radio">
              <input type="radio" name="stock_type" value="production" {{ old('stock_type','production')==='production'?'checked':'' }}>
              <span>Production</span>
            </label>
            <label class="fp-radio">
              <input type="radio" name="stock_type" value="purchase" {{ old('stock_type')==='purchase'?'checked':'' }}>
              <span>Purchase</span>
            </label>
          </div>
          @error('stock_type')<div class="fp-help">{{ $message }}</div>@enderror
        </div>
      </div>
    </div>

    {{-- footer buttons --}}
    <div class="fp-actions">
      <button type="submit" class="btn-ico btn-green"><i class="fa fa-save"></i> Save</button>
      <button type="reset"  class="btn-ico btn-gray"><i class="fa fa-refresh"></i> Reset</button>
    </div>
  </form>
</div>

{{-- ====== STYLE ====== --}}
<style>
/* container card */
.fp-wrap{border:1px solid #dfe7f2;border-radius:4px;background:#fff}
.fp-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid #dfe7f2;background:#f3f7fd}
.fp-title{display:flex;gap:10px;align-items:center;color:#1f4b99}
.fp-title .fa{color:#2b79c4}
.fp-title span{font-size:22px;font-weight:600}
.fp-list{background:#4aa8ff;border:1px solid #3793eb;color:#fff;text-decoration:none;padding:6px 10px;border-radius:3px;display:inline-flex;gap:6px;align-items:center}

/* grid */
.fp-grid{display:grid;grid-template-columns:1fr 1fr;gap:12px;padding:12px}
.fp-col{display:flex;flex-direction:column;gap:10px}

/* row */
.fp-row{display:flex;align-items:stretch}
.fp-row.has-error .fp-ctrl .fp-input,
.fp-row.has-error .fp-ctrl .fp-select{border-color:#e86b6b}
.fp-label{width:170px;min-width:170px;background:#e7f0fe;color:#1f4b99;border:1px solid #d5e1f5;border-right:none;border-radius:3px 0 0 3px;display:flex;align-items:center;justify-content:flex-start;padding:8px 10px;font-weight:600}
.fp-label.mini{width:auto;min-width:150px;margin-left:8px;border-radius:3px;background:#e7f0fe;border:1px solid #d5e1f5}
.req{color:#e11d48;margin-left:4px}

/* control */
.fp-ctrl{flex:1;border:1px solid #d5e1f5;border-left:none;border-radius:0 3px 3px 0;padding:6px;background:#fff;display:flex;align-items:center}
.fp-ctrl.fp-inline{gap:8px}
.fp-input,.fp-select{width:100%;height:30px;border:1px solid #d5e1f5;border-radius:2px;padding:4px 6px}
.fp-input.is-bad{border-color:#e86b6b}
.fp-file{height:30px}
.fp-radios{gap:18px}
.fp-radio{display:flex;align-items:center;gap:6px}

/* help/error */
.fp-help{padding:4px 8px;color:#b42318;font-size:13px}

/* actions */
.fp-actions{display:flex;gap:8px;justify-content:flex-end;padding:12px;border-top:1px solid #dfe7f2;background:#f8fbff}
.btn-ico{border:1px solid transparent;padding:7px 12px;border-radius:3px;display:inline-flex;gap:6px;align-items:center;cursor:pointer}
.btn-green{background:#38b36b;border-color:#2e9a5b;color:#fff}
.btn-gray{background:#eef2f7;border-color:#d7dee9;color:#2d3748}
@media (max-width: 1024px){
  .fp-grid{grid-template-columns:1fr}
}
</style>
@endsection


