@extends('layouts.app')
@section('title','Finish Bag List')

@section('content')
<div class="fb-wrap">

  {{-- Title bar --}}
  <div class="fb-topbar">
    <div class="fb-title">
      <i class="fa fa-list-ul"></i>
      <span>Finish Bag List</span>
    </div>

    <a href="{{ route('products.finish-bags.create') }}" class="fb-add">
      <i class="fa fa-plus"></i> Add Finish Bag
    </a>
  </div>

  {{-- Card --}}
  <div class="fb-card">
    <div class="fb-card-head">
      <div></div>
      <label class="fb-search">
        <span>Search:</span>
        <input type="text" oninput="fbFilter(this.value)" placeholder="">
      </label>
    </div>

    <div class="fb-table-wrap">
      <table id="fbTable" class="fb-table">
        <thead>
          <tr>
            <th style="width:70px">SL</th>
            <th>Finish Bag Name</th>
            <th style="width:260px">Opening warehouse</th>
            <th style="width:170px">Opening Quantity</th>
            <th style="width:160px">Alert Quantity</th>
            <th style="width:130px">Price</th>
            <th style="width:120px">Status</th>
            <th style="width:160px">Action</th>
          </tr>
        </thead>

        <tbody>
          @forelse($bags as $bag)
            @php
              $sl = ($bags instanceof \Illuminate\Pagination\LengthAwarePaginator)
                    ? $bags->firstItem() + $loop->index
                    : $loop->iteration;
              $isActive = (string)($bag->status ?? 1) === '1' || strtolower((string)($bag->status)) === 'active';
            @endphp

            <tr>
              <td>{{ $sl }}</td>
              <td>{{ $bag->name }}</td>
              <td>{{ $bag->openingWarehouse->name ?? $bag->warehouse->name ?? '—' }}</td>
              <td>{{ number_format((float)($bag->opening_quantity ?? 0), 2) }}</td>
              <td>{{ number_format((float)($bag->alert_quantity ?? 0), 2) }}</td>
              <td>{{ number_format((float)($bag->price ?? 0), 2) }}</td>
              <td>
                <span class="fb-badge {{ $isActive ? 'fb-badge-green' : 'fb-badge-red' }}">
                  {{ $isActive ? 'Active' : 'Inactive' }}
                </span>
              </td>

              {{-- Actions: info, edit, delete --}}
              <td class="fb-actions">
                <button type="button" class="fb-btn fb-blue" title="Info">
                  <i class="fa fa-info"></i>
                </button>

                <a href="{{ route('products.finish-bags.edit', $bag->id) }}"
                   class="fb-btn fb-green" title="Edit">
                  <i class="fa fa-pen"></i>
                </a>

                <form action="{{ route('products.finish-bags.destroy', $bag->id) }}"
                      method="POST" style="display:inline">
                  @csrf @method('DELETE')
                  <button type="submit" class="fb-btn fb-red" title="Delete"
                          onclick="return confirm('Delete this finish bag?')">
                    <i class="fa fa-trash"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="8" class="fb-empty">No data available in table</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    @if($bags instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="fb-paginate">{{ $bags->links() }}</div>
    @endif
  </div>
</div>

{{-- ===== Styles (mirrors your screenshot) ===== --}}
<style>
.fb-wrap{margin-top:6px}

/* top bar */
.fb-topbar{
  display:flex;justify-content:space-between;align-items:center;
  background:#eef3f9;border:1px solid #e4ebf6;border-radius:4px 4px 0 0;
  padding:12px 14px;margin-bottom:0
}
.fb-title{display:flex;align-items:center;gap:10px;color:#2d5daa}
.fb-title .fa{color:#2b78c5;font-size:22px}
.fb-title span{font-size:28px;font-weight:600}

/* add button */
.fb-add{
  display:inline-flex;align-items:center;gap:6px;text-decoration:none;
  background:#4aa8ff;border:1px solid #3793eb;color:#fff;
  padding:8px 12px;border-radius:4px;font-weight:600
}

/* card */
.fb-card{border:1px solid #e4ebf6;border-top:0;background:#fff;border-radius:0 0 4px 4px}
.fb-card-head{
  display:flex;justify-content:space-between;align-items:center;
  padding:10px 12px;border-bottom:1px solid #e4ebf6;background:#f3f7fd
}

/* search */
.fb-search{display:flex;align-items:center;gap:8px;color:#3b4b5c}
.fb-search input{height:26px;width:190px;border:1px solid #cfd9e5;border-radius:3px;padding:0 6px}

/* table */
.fb-table{width:100%;border-collapse:collapse}
.fb-table thead th{
  padding:11px 10px;background:#d5e6ff;color:#1f4b99;font-weight:700;
  border:1px solid #d7e1f0;font-size:15px
}
.fb-table tbody td{padding:10px;border:1px solid #ebf0f7;font-size:15px;color:#0f172a}
.fb-table tbody tr:nth-child(odd){background:#fbfdff}

/* badges */
.fb-badge{display:inline-block;padding:4px 8px;border-radius:3px;font-weight:700;font-size:12px}
.fb-badge-green{background:#8be27d;color:#0e4b15;border:1px solid #7bd66c}
.fb-badge-red{background:#ff9c9c;color:#5b0b0b;border:1px solid #ea7c7c}

/* actions */
.fb-actions{display:flex;align-items:center;gap:6px}
.fb-btn{
  width:28px;height:28px;border-radius:4px;border:1px solid transparent;
  display:inline-flex;align-items:center;justify-content:center;color:#fff;cursor:pointer
}
.fb-blue{background:#2ea3f2;border-color:#248dd1}
.fb-green{background:#38b36b;border-color:#2e9a5b}
.fb-red{background:#e2554f;border-color:#c24741}
.fb-btn .fa{font-size:13px}

.fb-empty{color:#6b7280;text-align:center}
.fb-paginate{padding:10px 12px;border-top:1px solid #e4ebf6}
</style>

{{-- client-side search --}}
<script>
function fbFilter(q){
  const rows = document.querySelectorAll('#fbTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r=>{
    if(r.querySelector('td.fb-empty')){ r.style.display=''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}
</script>
@endsection
