@extends('layouts.app')
@section('title','Edit Finish Bag')

@section('content')
<div class="fbc-wrap">
  <div class="fbc-card">
    <div class="fbc-head">
      <div class="fbc-title">
        <i class="fa fa-cog"></i>
        <span>Edit Finish Bag</span>
      </div>
      {{-- FIXED route name --}}
      <a href="{{ route('products.finish-bags.index') }}" class="fbc-link">
        <i class="fa fa-list"></i> Finish Bag List
      </a>
    </div>

    {{-- FIXED route name --}}
    <form action="{{ route('products.finish-bags.update', $bag->id) }}" method="POST" autocomplete="off">
      @csrf @method('PUT')

      <div class="fbc-body">
        {{-- Finish Bag Name --}}
        <div class="fbc-row @error('name') has-error @enderror">
          <div class="fbc-label">Finish Bag Name</div>
          <div class="fbc-ctrl">
            <input type="text"
                   name="name"
                   class="fbc-input"
                   value="{{ old('name', $bag->name) }}">
            @error('name') <div class="fbc-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Warehouse --}}
        <div class="fbc-row @error('warehouse_id') has-error @enderror">
          <div class="fbc-label">Warehouse <span class="req">*</span></div>
          <div class="fbc-ctrl">
            <select name="warehouse_id" class="fbc-select">
              <option value="">-Select Warehouse-</option>
              @foreach(($warehouses ?? []) as $id => $name)
                <option value="{{ $id }}"
                        @selected(old('warehouse_id', (string)$bag->warehouse_id)==(string)$id)>
                  {{ $name }}
                </option>
              @endforeach
            </select>
            @error('warehouse_id') <div class="fbc-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Opening Qty (read-only like your UI) --}}
        <div class="fbc-row">
          <div class="fbc-label">Opening Qty</div>
          <div class="fbc-ctrl">
            <input type="number" step="0.01" class="fbc-input fbc-readonly"
                   value="{{ old('opening_qty', $bag->opening_qty) }}" readonly>
          </div>
        </div>

        {{-- Alert Quantity --}}
        <div class="fbc-row @error('alert_qty') has-error @enderror">
          <div class="fbc-label">Alert Quantity</div>
          <div class="fbc-ctrl">
            <input type="number" step="0.01" name="alert_qty" class="fbc-input"
                   placeholder="Enter Alert Quantity"
                   value="{{ old('alert_qty', $bag->alert_qty) }}">
            @error('alert_qty') <div class="fbc-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Bag Price --}}
        <div class="fbc-row @error('price') has-error @enderror">
          <div class="fbc-label">Bag Price</div>
          <div class="fbc-ctrl">
            <input type="number" step="0.01" name="price" class="fbc-input"
                   value="{{ old('price', $bag->price) }}">
            @error('price') <div class="fbc-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Status --}}
        <div class="fbc-row @error('status') has-error @enderror">
          <div class="fbc-label">Status</div>
          <div class="fbc-ctrl">
            @php $sv = (string)old('status', (string)$bag->status); @endphp
            <select name="status" class="fbc-select">
              <option value="1" @selected($sv==='1')>Active</option>
              <option value="0" @selected($sv==='0')>Inactive</option>
            </select>
            @error('status') <div class="fbc-help">{{ $message }}</div> @enderror
          </div>
        </div>

      </div>

      <div class="fbc-foot">
        <button type="submit" class="btn-ico btn-green"><i class="fa fa-save"></i> Update</button>
        <button type="reset" class="btn-ico btn-gray"><i class="fa fa-refresh"></i> Reset</button>
      </div>
    </form>
  </div>
</div>

{{-- ===== Styles (same look as your create page / screenshot) ===== --}}
<style>
.fbc-wrap{max-width:1060px;margin:0 auto}
.fbc-card{border:1px solid #e5eaf3;border-radius:4px;background:#fff}
.fbc-head{display:flex;justify-content:space-between;align-items:center;
  padding:10px 14px;border-bottom:1px solid #e5eaf3;background:#f6f9fd}
.fbc-title{display:flex;gap:10px;align-items:center;color:#3b5fa7}
.fbc-title .fa{color:#2b78c5}
.fbc-title span{font-size:20px;font-weight:600}
.fbc-link{background:#eaf2ff;border:1px solid #cfe0fb;color:#1f4b99;text-decoration:none;
  padding:6px 10px;border-radius:3px;display:inline-flex;gap:6px;align-items:center}

.fbc-body{padding:18px 14px}
.fbc-row{display:flex;gap:12px;align-items:center;margin-bottom:14px}
.fbc-label{width:180px;background:#f3f6fb;border:1px solid #e3e9f4;border-radius:3px;
  padding:10px;font-weight:600;color:#475569}
.req{color:#e11d48;margin-left:3px}
.fbc-ctrl{flex:1}
.fbc-input,.fbc-select{width:100%;height:40px;border:1px solid #cfd9e5;border-radius:3px;padding:0 10px}
.fbc-readonly{background:#e9ecef;color:#374151}
.fbc-help{color:#e11d48;font-size:13px;margin-top:6px}
.has-error .fbc-input,.has-error .fbc-select{border-color:#ef4444}

.fbc-foot{border-top:1px solid #e5eaf3;padding:10px 14px;display:flex;gap:10px;justify-content:flex-end;background:#f9fbfe}
.btn-ico{display:inline-flex;align-items:center;gap:6px;border:1px solid transparent;border-radius:3px;padding:7px 12px;cursor:pointer}
.btn-green{background:#38b36b;border-color:#2e9a5b;color:#fff}
.btn-gray{background:#eef2f6;border-color:#d7dde7;color:#334155}
</style>
@endsection

