@extends('layouts.app')
@section('title','Dayar List')

@section('content')
<div class="dyx">

  {{-- ===== Title row ===== --}}
  <div class="dyx-titlebar">
    <div class="dyx-title">
      <i class="fa fa-list-ul"></i>
      <span>Dayar List</span>
    </div>

    <div class="dyx-actions-head">
      <label class="dyx-search">
        <span>Search:</span>
        <input type="text" oninput="dyxFilter(this.value)" placeholder="">
      </label>

      <a href="{{ route('products.dayars.create') }}" class="dyx-add-btn">
        <i class="fa fa-plus"></i> Add Dayar
      </a>
    </div>
  </div>

  {{-- ===== Card/Table ===== --}}
  <div class="dyx-card">
    <table class="dyx-table" id="dyxTable">
      <thead>
        <tr>
          <th style="width:70px">SL</th>
          <th>Dayar Name</th>
          <th style="width:180px">Status</th>
          <th style="width:200px">Action</th>
        </tr>
      </thead>
      <tbody>
        @forelse($dayars as $dayar)
          @php
            $sl = ($dayars instanceof \Illuminate\Pagination\LengthAwarePaginator)
                ? $dayars->firstItem() + $loop->index
                : $loop->iteration;

            $active = (string)($dayar->status ?? '1') === '1';

            $createdBy = optional($dayar->createdBy)->name ?: ($dayar->created_by ? "User #{$dayar->created_by}" : '—');
            $updatedBy = optional($dayar->updatedBy)->name ?: ($dayar->updated_by ? "User #{$dayar->updated_by}" : '—');
            $createdAt = optional($dayar->created_at)->format('Y-m-d H:i:s') ?? '—';
            $updatedAt = optional($dayar->updated_at)->format('Y-m-d H:i:s') ?? '—';
          @endphp
          <tr>
            <td>{{ $sl }}</td>
            <td>{{ $dayar->name }}</td>
            <td>
              @if($active)
                <span class="dyx-badge dyx-badge-green">Active</span>
              @else
                <span class="dyx-badge">Inactive</span>
              @endif
            </td>
            <td class="dyx-row-actions">
              {{-- Info popover --}}
              <button type="button" class="dyx-btn dyx-btn-blue dyx-pop-trigger"
                      title="Details"
                      data-created-by="{{ $createdBy }}"
                      data-created-at="{{ $createdAt }}"
                      data-updated-by="{{ $updatedBy }}"
                      data-updated-at="{{ $updatedAt }}">
                <i class="fa fa-info"></i>
              </button>

              {{-- Edit --}}
              <a href="{{ route('products.dayars.edit', $dayar->id) }}" class="dyx-btn dyx-btn-green" title="Edit">
                <i class="fa fa-pen"></i>
              </a>

              {{-- Delete --}}
              <form action="{{ route('products.dayars.destroy', $dayar->id) }}"
                    method="POST" style="display:inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="dyx-btn dyx-btn-red" title="Delete"
                        onclick="return confirm('Delete this dayar?')">
                  <i class="fa fa-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="4" style="text-align:center;color:#6b7280;padding:18px">
              No data found.
            </td>
          </tr>
        @endforelse
      </tbody>
    </table>

    {{-- Pagination --}}
    @if($dayars instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="dyx-paginate">
        {{ $dayars->links() }}
      </div>
    @endif
  </div>
</div>

{{-- ===== Styles (scoped) ===== --}}
<style>
.dyx{margin-top:6px}
.dyx-titlebar{display:flex;align-items:center;justify-content:space-between;margin-bottom:10px}
.dyx-title{display:flex;align-items:center;gap:10px;color:#1f4b99}
.dyx-title .fa{color:#1f7bd8;font-size:22px}
.dyx-title span{font-size:26px;font-weight:600}

.dyx-actions-head{display:flex;align-items:center;gap:10px}
.dyx-add-btn{
  background:#1f7bd8;color:#fff;border:1px solid #1b6dbf;text-decoration:none;
  padding:7px 11px;border-radius:3px;font-size:14px;display:inline-flex;align-items:center;gap:6px
}
.dyx-add-btn:hover{background:#1866b5;border-color:#155b9f}
.dyx-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.dyx-search input{height:26px;width:180px;border:1px solid #cfd9e5;border-radius:2px;padding:0 6px;outline:none}
.dyx-search input:focus{border-color:#89b8ef;box-shadow:0 0 0 2px rgba(49,132,255,.15)}

.dyx-card{border:1px solid #dbe3ee;border-radius:3px;background:#fff}
.dyx-table{width:100%;border-collapse:collapse}
.dyx-table thead th{
  text-align:left;padding:10px;background:linear-gradient(180deg,#f5f7fb 0%,#e9edf3 100%);
  border:1px solid #e2e8f0;color:#1f4b99;font-weight:700;font-size:14px
}
.dyx-table tbody td{padding:10px;border:1px solid #e9eef5;font-size:14px;color:#111827}
.dyx-table tbody tr:nth-child(odd){background:#fafcfe}

.dyx-badge{display:inline-block;padding:3px 8px;border-radius:2px;font-size:12px;background:#e6e7eb;color:#374151;font-weight:700}
.dyx-badge-green{background:#8be27d;color:#0e4b15}

.dyx-row-actions{display:flex;align-items:center;gap:6px}
.dyx-btn{width:26px;height:26px;border-radius:2px;display:inline-flex;align-items:center;justify-content:center;color:#fff;border:1px solid transparent;text-decoration:none;cursor:pointer}
.dyx-btn .fa{font-size:13px}
.dyx-btn-blue{background:#2ea3f2;border-color:#248dd1}
.dyx-btn-green{background:#38b36b;border-color:#2e9a5b}
.dyx-btn-red{background:#e2554f;border-color:#c24741}
.dyx-btn:hover{filter:brightness(.97)}
.dyx-paginate{padding:10px 12px;border-top:1px solid #e9edf3}

/* Popover */
.dyx-pop{
  position:fixed; z-index:50; min-width:360px; max-width:380px;
  background:#fff; color:#111827; border:1px solid #d8e1ef; border-radius:3px;
  box-shadow:0 10px 24px rgba(0,0,0,.12); overflow:hidden;
}
.dyx-pop .hd{display:flex;align-items:center;gap:8px;padding:8px 10px;font-weight:700;color:#1f2937;background:#f2f6fc;border-bottom:1px solid #e1e8f5}
.dyx-pop .hd .fa{color:#2ca44f}
.dyx-pop .bd{padding:10px 12px;font-size:14px}
.dyx-pop .row{margin:6px 0}
.dyx-pop .lbl{color:#6b7280}
.dyx-pop .arrow{position:absolute;left:calc(50% - 8px);bottom:-8px;width:0;height:0;border-left:8px solid transparent;border-right:8px solid transparent;border-top:8px solid #d8e1ef}
.dyx-pop .arrow::after{content:"";position:absolute;left:-7px;top:-9px;width:0;height:0;border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid #fff}
</style>

{{-- ===== Scripts ===== --}}
<script>
function dyxFilter(q){
  const rows = document.querySelectorAll('#dyxTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => {
    if(r.querySelector('td[colspan]')) { r.style.display = ''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}

/* Hover popover like your screenshot */
(function(){
  let tip, hideTimer, showTimer;

  const makeTip = (btn) => {
    tip = document.createElement('div');
    tip.className = 'dyx-pop';
    tip.innerHTML =
      `<div class="hd"><i class="fa fa-info-circle"></i> <span>Log Information</span></div>
       <div class="bd">
         <div class="row"><span class="lbl">Created By:</span> ${btn.dataset.createdBy || 'N/A'}</div>
         <div class="row"><span class="lbl">Created At :</span> ${btn.dataset.createdAt || 'N/A'}</div>
         <div class="row" style="margin:8px 0;border-top:1px solid #eef2f7"></div>
         <div class="row"><span class="lbl">Updated By:</span> ${btn.dataset.updatedBy || 'N/A'}</div>
         <div class="row"><span class="lbl">Updated At :</span> ${btn.dataset.updatedAt || 'N/A'}</div>
       </div>
       <div class="arrow"></div>`;
    document.body.appendChild(tip);

    const r = btn.getBoundingClientRect();
    const gap = 10;
    const top = r.top + window.scrollY - tip.offsetHeight - gap;
    const left = Math.min(
      window.innerWidth - tip.offsetWidth - 10,
      Math.max(10, r.right - tip.offsetWidth)
    );
    tip.style.top  = (top > 10 ? top : 10) + 'px';
    tip.style.left = left + 'px';
  };

  const show = (btn) => {
    clearTimeout(hideTimer); clearTimeout(showTimer);
    showTimer = setTimeout(()=> { if(tip) tip.remove(); makeTip(btn); }, 120);
  };
  const hide = () => {
    clearTimeout(showTimer);
    hideTimer = setTimeout(()=>{ if(tip){ tip.remove(); tip=null; } }, 120);
  };

  document.addEventListener('mouseover', (e)=>{
    const btn = e.target.closest('.dyx-pop-trigger');
    if(btn) show(btn);
  });
  document.addEventListener('mouseout', (e)=>{
    if(e.target.closest('.dyx-pop-trigger')) hide();
  });
  window.addEventListener('scroll', hide, {passive:true});
  window.addEventListener('resize', hide);
})();
</script>
@endsection
