@extends('layouts.app')
@section('title','Edit Dayar')

@section('content')
<div class="dy-wrap">
  <div class="dy-panel">
    <div class="dy-head">
      <div class="dy-head-left">
        <i class="fa fa-cog"></i>
        <span>Edit Dayar</span>
      </div>
      <a href="{{ route('products.dayars.index') }}" class="dy-head-link">
        <i class="fa fa-list"></i> Dayar List
      </a>
    </div>

    <div class="dy-body">
      <form action="{{ route('products.dayars.update', $dayar->id) }}" method="POST" autocomplete="off">
        @csrf
        @method('PUT')

        {{-- Dayar Name --}}
        <div class="dy-row @error('name') has-error @enderror">
          <div class="dy-label">Dayar Name</div>
          <div class="dy-control">
            <input type="text" name="name" class="dy-input" value="{{ old('name', $dayar->name) }}" required>
            @error('name') <div class="dy-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Status --}}
        @php $sv = (string)old('status', (string)$dayar->status); @endphp
        <div class="dy-row @error('status') has-error @enderror">
          <div class="dy-label">Status</div>
          <div class="dy-control">
            <select name="status" class="dy-select">
              <option value="1" {{ $sv==='1' ? 'selected' : '' }}>Active</option>
              <option value="0" {{ $sv==='0' ? 'selected' : '' }}>Inactive</option>
            </select>
            @error('status') <div class="dy-help">{{ $message }}</div> @enderror
          </div>
        </div>

        <div class="dy-actions">
          <button type="submit" class="btn-ico btn-green">
            <i class="fa fa-floppy-o"></i> Update
          </button>
          <button type="reset" class="btn-ico btn-gray">
            <i class="fa fa-refresh"></i> Reset
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

{{-- Scoped styles to match your screenshot exactly --}}
<style>
.dy-wrap{padding:10px}
.dy-panel{border:1px solid #d9d9d9;border-radius:2px;background:#fff}
.dy-head{
  display:flex;justify-content:space-between;align-items:center;
  padding:10px 12px;border-bottom:1px solid #e6e6e6;
  background:linear-gradient(#f7f7f7,#ececec)
}
.dy-head-left{display:flex;gap:8px;align-items:center;color:#2b78c5;font-weight:600}
.dy-head-link{border:1px solid #c7d7ea;background:#f3f8ff;color:#2b78c5;padding:6px 10px;border-radius:2px;text-decoration:none}
.dy-head-link i{margin-right:6px}

.dy-body{padding:18px}
.dy-row{display:flex;align-items:center;margin-bottom:16px}
.dy-label{
  width:160px;min-width:160px;background:#f0f2f5;border:1px solid #d9d9d9;border-right:none;
  border-radius:3px 0 0 3px;padding:10px 14px;text-align:center;font-weight:600;color:#666
}
.dy-control{flex:1}
.dy-input,.dy-select{
  width:100%;height:36px;border:1px solid #d9d9d9;border-radius:0 3px 3px 0;padding:9px 12px;background:#fff;line-height:1.4
}

.dy-actions{text-align:right;margin-top:12px}
.btn-ico{display:inline-flex;align-items:center;gap:8px;padding:9px 14px;border-radius:3px;border:1px solid transparent;
  font-weight:600;cursor:pointer}
.btn-green{background:#7dbd71;border-color:#6fb064;color:#fff}
.btn-gray{background:#e7edf3;border-color:#d4dbe2;color:#3b4b5c}
.btn-ico i{font-size:14px}

.dy-help{margin-top:6px;color:#a94442}
.has-error .dy-input,.has-error .dy-select{border-color:#a94442}
</style>
@endsection
