@extends('layouts.app')
@section('title','Add Dayar')

@section('content')
<form class="dy-form" method="POST" action="{{ route('products.dayars.store') }}">
  @csrf
  <div class="dy-head">
    <div class="dy-title"><i class="fa fa-cog"></i> <span>Add Dayar</span></div>
    <a href="{{ route('products.dayars.index') }}" class="dy-link"><i class="fa fa-list"></i> Dayar List</a>
  </div>

  <div class="dy-body">
    <div class="dy-row @error('name') has-error @enderror">
      <div class="dy-label">Dayar Name <span class="req">*</span></div>
      <div class="dy-field">
        <input type="text" name="name" class="dy-input" value="{{ old('name') }}" required>
        @error('name') <div class="dy-error">{{ $message }}</div> @enderror
      </div>
    </div>

    <div class="dy-row @error('status') has-error @enderror">
      <div class="dy-label">Status</div>
      <div class="dy-field">
        <select name="status" class="dy-select">
          <option value="1" {{ old('status','1')=='1' ? 'selected':'' }}>Active</option>
          <option value="0" {{ old('status')==='0' ? 'selected':'' }}>Inactive</option>
        </select>
        @error('status') <div class="dy-error">{{ $message }}</div> @enderror
      </div>
    </div>

    <div class="dy-actions">
      <button type="submit" class="dy-btn dy-green"><i class="fa fa-save"></i> Save</button>
      <button type="reset" class="dy-btn dy-gray"><i class="fa fa-rotate"></i> Reset</button>
    </div>
  </div>
</form>

<style>
.dy-form{border:1px solid #e5e7eb;border-radius:6px;background:#fff;max-width:1120px;margin:0 auto}
.dy-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid #e9edf3;background:linear-gradient(#eef2f7,#e7edf7)}
.dy-title{display:flex;gap:8px;align-items:center;color:#2563eb;font-weight:700}
.dy-link{display:inline-flex;gap:6px;align-items:center;background:#f1f5f9;border:1px solid #dbe4ee;color:#2563eb;text-decoration:none;padding:6px 10px;border-radius:4px;font-weight:600}
.dy-body{padding:18px}
.dy-row{display:flex;align-items:center;margin-bottom:16px}
.dy-label{flex:0 0 220px;background:#eef1f5;border:1px solid #e3e7ee;border-right:0;border-radius:4px 0 0 4px;padding:10px 14px;color:#475569;font-weight:600;text-align:center}
.dy-field{flex:1}
.dy-input,.dy-select{width:100%;height:38px;border:1px solid #e3e7ee;border-left:0;border-radius:0 4px 4px 0;padding:0 12px;background:#fff}
.dy-actions{display:flex;gap:10px;justify-content:flex-end;padding-top:8px}
.dy-btn{display:inline-flex;gap:8px;align-items:center;border:0;border-radius:4px;padding:8px 12px;color:#fff;font-weight:700;cursor:pointer}
.dy-green{background:#6ab47c}.dy-gray{background:#9aa9b8}
.req{color:#ef4444}.dy-error{margin-top:6px;color:#b91c1c;font-size:13px}
.has-error .dy-input,.has-error .dy-select{border-color:#b91c1c}
</style>
@endsection
