@extends('layouts.app')
@section('title','Category List')

@section('content')
<div class="tbx">
  <!-- ===== Title row ===== -->
  <div class="tbx-titlebar">
    <div class="tbx-title">
      <i class="fa fa-list-ul"></i>
      <span>Category List</span>
    </div>

    <a href="{{ route('products.categories.create') }}" class="tbx-add-btn">
      <i class="fa fa-plus"></i> Add Category
    </a>
  </div>

  <!-- ===== Table card ===== -->
  <div class="tbx-card">
    <div class="tbx-card-head">
      <div></div>
      <label class="tbx-search">
        <span>Search:</span>
        <input type="text" oninput="tbxFilter(this.value)">
      </label>
    </div>

    <div class="tbx-table-wrap">
      <table class="tbx-table" id="tbxTable">
        <thead>
          <tr>
            <th style="width:70px">SL</th>
            <th>Category Name</th>
            <th style="width:220px">Code</th>
            <th style="width:160px">Status</th>
            <th style="width:200px">Action</th>
          </tr>
        </thead>
        <tbody>
        @forelse($categories as $cat)
          @php
            $active = (string)($cat->status ?? '1') === '1';
            $sl = ($categories instanceof \Illuminate\Pagination\LengthAwarePaginator)
                  ? $categories->firstItem() + $loop->index
                  : $loop->iteration;
            $createdAt = optional($cat->created_at)->format('Y-m-d H:i:s') ?? '';
            $updatedAt = optional($cat->updated_at)->format('Y-m-d H:i:s') ?? '';
          @endphp
          <tr>
            <td>{{ $sl }}</td>
            <td>{{ $cat->name }}</td>
            <td>{{ $cat->code }}</td>
            <td>
              @if($active)
                <span class="tbx-badge tbx-badge-green">Active</span>
              @else
                <span class="tbx-badge">Inactive</span>
              @endif
            </td>
            <td class="tbx-actions">
              <!-- Info (hover করলে Log Information দেখাবে) -->
              <button type="button"
                      class="tbx-btn tbx-btn-blue tbx-pop-trigger"
                      aria-label="Details"
                      data-created-by="{{ $cat->created_by_name }}"
                      data-created-at="{{ $createdAt }}"
                      data-updated-by="{{ $cat->updated_by_name }}"
                      data-updated-at="{{ $updatedAt }}">
                <i class="fa fa-info"></i>
              </button>
              <!-- Edit -->
              <a href="{{ route('products.categories.edit', $cat->id) }}"
                 class="tbx-btn tbx-btn-green" title="Edit">
                <i class="fa fa-pen"></i>
              </a>

              <!-- Delete -->
              <form action="{{ route('products.categories.destroy', $cat->id) }}"
                    method="POST" style="display:inline">
                @csrf @method('DELETE')
                <button type="submit" class="tbx-btn tbx-btn-red" title="Delete"
                        onclick="return confirm('Delete this category?')">
                  <i class="fa fa-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="5" style="text-align:center;color:#6b7280;padding:18px">No data found.</td>
          </tr>
        @endforelse
        </tbody>
      </table>
    </div>

    @if($categories instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="tbx-paginate">
        {{ $categories->links() }}
      </div>
    @endif
  </div>
</div>

{{-- ===================== STYLES ===================== --}}
<style>
/* Page title row */
.tbx{margin-top:4px}
.tbx-titlebar{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px}
.tbx-title{display:flex;align-items:center;gap:10px;color:#1f4b99}
.tbx-title .fa{color:#1f7bd8;font-size:22px}
.tbx-title span{font-size:28px;font-weight:600}

/* Add button (top-right) */
.tbx-add-btn{
  background:#1f7bd8;color:#fff;border:1px solid #1b6dbf;text-decoration:none;
  padding:7px 11px;border-radius:3px;font-size:14px;display:inline-flex;align-items:center;gap:6px
}
.tbx-add-btn:hover{background:#1866b5;border-color:#155b9f}

/* Card */
.tbx-card{border:1px solid #dbe3ee;border-radius:3px;background:#fff}
.tbx-card-head{
  display:flex;align-items:center;justify-content:space-between;
  padding:10px 12px;border-bottom:1px solid #dbe3ee;background:#eef3f9
}

/* Search (right) */
.tbx-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.tbx-search input{
  height:26px;width:180px;border:1px solid #cfd9e5;border-radius:2px;padding:0 6px;outline:none
}
.tbx-search input:focus{border-color:#89b8ef;box-shadow:0 0 0 2px rgba(49,132,255,.15)}

/* ====== TABLE (grid lines ON) ====== */
.tbx-table{
  width:100%;
  border-collapse:collapse;             /* ✅ উল্লম্ব বর্ডার চালু */
  table-layout:auto;
}
.tbx-table thead th{
  text-align:left;padding:10px;
  background:linear-gradient(180deg,#f5f7fb 0%,#e9edf3 100%);
  border:1px solid #e2e8f0;            /* ✅ কলাম বর্ডার */
  color:#1f4b99;font-weight:700;font-size:14px
}
.tbx-table tbody td{
  padding:10px;
  border:1px solid #e9eef5;            /* ✅ কলাম বর্ডার */
  font-size:14px;color:#111827
}
.tbx-table tbody tr:nth-child(odd){background:#fafcfe}

/* Status badge */
.tbx-badge{display:inline-block;padding:3px 8px;border-radius:2px;font-size:12px;background:#e6e7eb;color:#374151;font-weight:700}
.tbx-badge-green{background:#8be27d;color:#0e4b15}

/* Action buttons */
.tbx-actions{display:flex;align-items:center;gap:6px}
.tbx-btn{
  width:26px;height:26px;border-radius:2px;display:inline-flex;align-items:center;justify-content:center;
  color:#fff;border:1px solid transparent;text-decoration:none;cursor:pointer
}
.tbx-btn .fa{font-size:13px;line-height:1}
.tbx-btn-blue{background:#2ea3f2;border-color:#248dd1}
.tbx-btn-green{background:#38b36b;border-color:#2e9a5b}
.tbx-btn-red{background:#e2554f;border-color:#c24741}
.tbx-btn:hover{filter:brightness(.97)}

.tbx-paginate{padding:10px 12px;border-top:1px solid #e9edf3}

/* ===== Hover Popover (Log Information) ===== */
.tbx-pop{
  position:fixed; z-index:50; min-width:360px; max-width:380px;
  background:#fff; color:#111827; border:1px solid #d8e1ef; border-radius:3px;
  box-shadow:0 10px 24px rgba(0,0,0,.12); overflow:hidden;
}
.tbx-pop .hd{
  display:flex;align-items:center;gap:8px;
  padding:8px 10px;font-weight:700;color:#1f2937;background:#f2f6fc;border-bottom:1px solid #e1e8f5
}
.tbx-pop .hd .fa{color:#2ca44f}
.tbx-pop .bd{padding:10px 12px;font-size:14px}
.tbx-pop .row{margin:6px 0}
.tbx-pop .lbl{color:#6b7280}
.tbx-pop .arrow{
  position:absolute; left:calc(50% - 8px); bottom:-8px;
  width:0;height:0;border-left:8px solid transparent;border-right:8px solid transparent;border-top:8px solid #d8e1ef;
}
.tbx-pop .arrow::after{
  content:""; position:absolute; left:-7px; top:-9px; width:0;height:0;
  border-left:7px solid transparent;border-right:7px solid transparent;border-top:7px solid #fff;
}
</style>

{{-- ===================== SCRIPTS ===================== --}}
<script>
function tbxFilter(q){
  const rows = document.querySelectorAll('#tbxTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => {
    if(r.querySelector('td[colspan]')) { r.style.display = ''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}

/* ===== Hover popover (Log Information) ===== */
(function(){
  let tip, hideTimer, showTimer;

  const makeTip = (btn) => {
    tip = document.createElement('div');
    tip.className = 'tbx-pop';
    tip.innerHTML =
      `<div class="hd"><i class="fa fa-info-circle"></i> <span>Log Information</span></div>
       <div class="bd">
         <div class="row"><span class="lbl">Created By:</span> ${btn.dataset.createdBy || 'N/A'}</div>
         <div class="row"><span class="lbl">Created At :</span> ${btn.dataset.createdAt || 'N/A'}</div>
         <div class="row" style="margin:8px 0;border-top:1px solid #eef2f7"></div>
         <div class="row"><span class="lbl">Updated By:</span> ${btn.dataset.updatedBy || 'N/A'}</div>
         <div class="row"><span class="lbl">Updated At :</span> ${btn.dataset.updatedAt || 'N/A'}</div>
       </div>
       <div class="arrow"></div>`;
    document.body.appendChild(tip);

    const r = btn.getBoundingClientRect();
    const gap = 10;
    const top = r.top + window.scrollY - tip.offsetHeight - gap;
    const left = Math.min(
      window.innerWidth - tip.offsetWidth - 10,
      Math.max(10, r.right - tip.offsetWidth)
    );
    tip.style.top = (top > 10 ? top : 10) + 'px';
    tip.style.left = left + 'px';
  };

  const show = (btn) => {
    clearTimeout(hideTimer);
    clearTimeout(showTimer);
    showTimer = setTimeout(()=> {
      if(tip) tip.remove();
      makeTip(btn);
    }, 120);
  };

  const hide = () => {
    clearTimeout(showTimer);
    hideTimer = setTimeout(()=>{ if(tip){ tip.remove(); tip=null; } }, 120);
  };

  document.addEventListener('mouseover', (e)=>{
    const btn = e.target.closest('.tbx-pop-trigger');
    if(btn) show(btn);
  });
  document.addEventListener('mouseout', (e)=>{
    if(e.target.closest('.tbx-pop-trigger')) hide();
  });
  window.addEventListener('scroll', hide, {passive:true});
  window.addEventListener('resize', hide);
})();
</script>
@endsection
