@extends('layouts.app')
@section('title','Add New Category')

@section('content')
<form class="cform-card" method="POST" action="{{ route('products.categories.store') }}">
    @csrf

    <div class="cform-head">
        <div class="cform-title">
            <i class="fa fa-cog"></i>
            <span>Add New Category</span>
        </div>
        <a href="{{ route('products.categories.index') }}" class="cform-link">
            <i class="fa fa-list"></i> Category List
        </a>
    </div>

    <div class="cform-body">

        {{-- Category Name --}}
        <div class="cform-row">
            <div class="cform-label">
                Category Name <span class="cform-req">*</span>
            </div>
            <div class="cform-field">
                <input type="text" name="name" value="{{ old('name') }}"
                       class="cform-input" placeholder="Enter The Category Name" required>
                @error('name') <div class="cform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Code --}}
        <div class="cform-row">
            <div class="cform-label">Code Name</div>
            <div class="cform-field">
                <input type="text" name="code" value="{{ old('code') }}"
                       class="cform-input" placeholder="Enter The Code">
                @error('code') <div class="cform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Status --}}
        <div class="cform-row">
            <div class="cform-label">Status</div>
            <div class="cform-field">
                <select name="status" class="cform-select">
                    <option value="1" {{ old('status','1')=='1' ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ old('status')==='0' ? 'selected' : '' }}>Inactive</option>
                </select>
                @error('status') <div class="cform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        <div class="cform-actions">
            <button type="submit" class="cform-btn cform-btn-save">
                <i class="fa fa-save"></i> Save
            </button>
            <button type="reset" class="cform-btn cform-btn-reset">
                <i class="fa fa-rotate"></i> Reset
            </button>
        </div>
    </div>
</form>

<style>
/* ===== Scoped: Category Create Form (cform-) ===== */
.cform-card{border:1px solid #e5e7eb;border-radius:6px;background:#fff;max-width:1120px;margin:0 auto;box-shadow:0 1px 1px rgba(0,0,0,.02)}
.cform-head{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid #e9edf3;background:linear-gradient(180deg,#eef2f7 0%,#e7edf7 100%)}
.cform-title{display:flex;align-items:center;gap:8px;font-weight:700;color:#2563eb;font-size:18px}
.cform-title .fa{color:#3b82f6}
.cform-link{display:inline-flex;align-items:center;gap:6px;background:#f1f5f9;border:1px solid #dbe4ee;color:#2563eb;text-decoration:none;padding:6px 10px;border-radius:4px;font-weight:600}
.cform-link:hover{background:#e6eef8}

.cform-body{padding:18px}
.cform-row{display:flex;align-items:center;margin-bottom:16px}
.cform-label{flex:0 0 220px;background:#eef1f5;border:1px solid #e3e7ee;border-right:0;border-radius:4px 0 0 4px;padding:10px 14px;color:#475569;font-weight:600;text-align:center}
.cform-req{color:#ef4444}
.cform-field{flex:1}
.cform-input,.cform-select{
  width:100%;height:38px;border:1px solid #e3e7ee;border-left:0;border-radius:0 4px 4px 0;
  padding:0 12px;outline:none;color:#111827;background:#fff;
}
.cform-input:focus,.cform-select:focus{border-color:#fb923c;box-shadow:0 0 0 2px rgba(251,146,60,.25)}

.cform-error{margin-top:6px;color:#b91c1c;font-size:13px}

.cform-actions{display:flex;gap:10px;justify-content:flex-end;padding:12px 4px}
.cform-btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:4px;padding:8px 12px;color:#fff;font-weight:700;cursor:pointer}
.cform-btn-save{background:#6ab47c}
.cform-btn-save:hover{filter:brightness(.95)}
.cform-btn-reset{background:#9aa9b8}
.cform-btn-reset:hover{filter:brightness(.95)}
</style>
@endsection
