@extends('layouts.app')
@section('title','Bag Type List')

@section('content')
<div class="btlst-card">
  <div class="btlst-head">
    <div class="btlst-title">
      <i class="fa fa-list-ul"></i>
      <span>Bag Type List</span>
    </div>

    <div class="btlst-actions">
      <a href="{{ route('products.bag-types.create') }}" class="btlst-btn btlst-btn-primary">
        <i class="fa fa-plus"></i> Add Bag Type List
      </a>
    </div>
  </div>

  <div class="btlst-toolbar">
    <label class="btlst-search">
      <span>Search:</span>
      <input type="text" oninput="btlstFilter(this.value)">
    </label>
  </div>

  <div class="btlst-table-wrap">
    <table class="btlst-table" id="btlstTable">
      <thead>
        <tr>
          <th style="width:70px">SL</th>
          <th>Bag Type Name</th>
          <th style="width:220px">Bag Size</th>
          <th style="width:160px">Status</th>
          <th style="width:200px">Action</th>
        </tr>
      </thead>
      <tbody>
        @php $rows = $bagTypes ?? collect(); @endphp

        @forelse($rows as $bag)
          @php
            $sl = ($rows instanceof \Illuminate\Pagination\LengthAwarePaginator) ? $rows->firstItem() + $loop->index : $loop->iteration;

            $createdBy = $bag->creator->name
                          ?? $bag->createdBy->name
                          ?? $bag->created_by_name
                          ?? '—';
            $updatedBy = $bag->updater->name
                          ?? $bag->updatedBy->name
                          ?? $bag->updated_by_name
                          ?? '—';

            $createdAt = optional($bag->created_at)->format('Y-m-d H:i:s') ?? '—';
            $updatedAt = optional($bag->updated_at)->format('Y-m-d H:i:s') ?? '—';
          @endphp
          <tr>
            <td>{{ $sl }}</td>
            <td>{{ $bag->name }}</td>
            <td>{{ number_format((float)($bag->bag_size ?? 0), 2) }}</td>
            <td>
              @if((string)$bag->status === '1')
                <span class="btlst-badge btlst-badge-success">Active</span>
              @else
                <span class="btlst-badge">Inactive</span>
              @endif
            </td>
            <td class="btlst-actions-td">
              {{-- INFO (hover = log card) --}}
              <a href="javascript:void(0)"
                 class="btlst-icon btlst-info js-info"
                 title="Details"
                 data-cby="{{ $createdBy }}"
                 data-cat="{{ $createdAt }}"
                 data-uby="{{ $updatedBy }}"
                 data-uat="{{ $updatedAt }}">
                <i class="fa fa-info"></i>
              </a>

              <a href="{{ route('products.bag-types.edit', $bag->id) }}"
                 class="btlst-icon btlst-edit" title="Edit">
                <i class="fa fa-pen"></i>
              </a>

              <form action="{{ route('products.bag-types.destroy', $bag->id) }}"
                    method="POST" style="display:inline">
                @csrf @method('DELETE')
                <button type="submit" class="btlst-icon btlst-del" title="Delete"
                        onclick="return confirm('Delete this bag type?')">
                  <i class="fa fa-trash"></i>
                </button>
              </form>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="5" class="btlst-empty">No bag types found.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>

  @if(isset($bagTypes) && $bagTypes instanceof \Illuminate\Pagination\LengthAwarePaginator)
    <div class="btlst-pagination">
      {{ $bagTypes->links() }}
    </div>
  @endif
</div>

{{-- FLOATING LOG POPUP (single instance) --}}
<div id="btlstLogCard" class="btlst-pop" role="tooltip" aria-hidden="true">
  <div class="btlst-pop-head">
    <i class="fa fa-info-circle"></i> Log Information
  </div>
  <div class="btlst-pop-body">
    <div><span>Created By:</span> <b id="lg_cby">—</b></div>
    <div><span>Created At :</span> <b id="lg_cat">—</b></div>
    <hr>
    <div><span>Updated By:</span> <b id="lg_uby">—</b></div>
    <div><span>Updated At :</span> <b id="lg_uat">—</b></div>
  </div>
</div>

<style>
/* ===== Card & Table styles ===== */
.btlst-card{border:1px solid #e5e7eb;border-radius:6px;background:#fff;box-shadow:0 1px 1px rgba(0,0,0,.02)}
.btlst-head{display:flex;align-items:center;justify-content:space-between;padding:12px 14px;border-bottom:1px solid #e9edf3;background:linear-gradient(180deg,#eef5fd 0%,#e9f0fb 100%)}
.btlst-title{display:flex;align-items:center;gap:10px;color:#1f2937;font-weight:700;font-size:20px}
.btlst-title .fa{color:#3b82f6}
.btlst-actions{display:flex;gap:8px}
.btlst-btn{display:inline-flex;align-items:center;gap:8px;padding:8px 10px;border-radius:4px;font-size:14px;text-decoration:none;border:1px solid transparent}
.btlst-btn-primary{background:#3b82f6;color:#fff;border-color:#3b82f6}
.btlst-btn-primary:hover{background:#2563eb;border-color:#2563eb}
.btlst-toolbar{display:flex;justify-content:flex-end;padding:10px 14px;border-bottom:1px solid #e9edf3}
.btlst-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.btlst-search input{height:30px;border:1px solid #d1d5db;border-radius:3px;padding:0 8px;outline:none}
.btlst-search input:focus{border-color:#60a5fa;box-shadow:0 0 0 3px rgba(59,130,246,.15)}

.btlst-table-wrap{padding:0 0 10px}
.btlst-table{width:100%;border-collapse:collapse}
.btlst-table thead th{background:linear-gradient(180deg,#f7f9fc 0%,#eef2f7 100%);color:#1f4b99;font-weight:700;padding:10px;text-align:left;font-size:14px;border:1px solid #e5e7eb}
.btlst-table tbody td{padding:10px;font-size:14px;color:#111827;border:1px solid #edf1f5}
.btlst-table tbody tr:hover{background:#f5f9ff}

.btlst-badge{display:inline-block;padding:4px 8px;font-size:12px;border-radius:4px;font-weight:700;background:#e5e7eb;color:#374151}
.btlst-badge-success{background:#86efac;color:#14532d}

.btlst-actions-td{display:flex;align-items:center;gap:8px}
.btlst-icon{width:28px;height:28px;display:inline-flex;align-items:center;justify-content:center;border-radius:4px;color:#fff;text-decoration:none;border:0;cursor:pointer}
.btlst-info{background:#60a5fa}
.btlst-edit{background:#22c55e}
.btlst-del{background:#ef4444}
.btlst-icon:hover{filter:brightness(.95)}

.btlst-empty{padding:18px;text-align:center;color:#6b7280}
.btlst-pagination{padding:10px 14px;border-top:1px solid #eef2f7}

/* ===== Hover LOG POPUP (appears ABOVE the icon) ===== */
.btlst-pop{
  position:fixed; z-index:9999; display:none;
  width:280px; background:#fff; border:1px solid #e5e7eb; border-radius:6px;
  box-shadow:0 12px 28px rgba(0,0,0,.18);
}
.btlst-pop::after{ /* little arrow pointing downward (to the icon) */
  content:""; position:absolute; left:50%; transform:translateX(-50%);
  bottom:-8px; width:0; height:0;
  border-left:8px solid transparent; border-right:8px solid transparent;
  border-top:8px solid #fff;
  filter:drop-shadow(0 -1px 0 #e5e7eb);
}
.btlst-pop-head{
  padding:8px 10px; background:#f1f6ff; color:#0f3e8a; font-weight:700; border-bottom:1px solid #e5e7eb;
}
.btlst-pop-head .fa{color:#16a34a;margin-right:6px}
.btlst-pop-body{padding:10px; font-size:13px; color:#1f2937}
.btlst-pop-body hr{border:0;border-top:1px solid #eef2f7;margin:8px 0}
.btlst-pop-body span{color:#6b7280}
.btlst-pop-body b{color:#111827}
</style>

<script>
/* client search */
function btlstFilter(q){
  const rows = document.querySelectorAll('#btlstTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => {
    if (r.querySelector('.btlst-empty')) return;
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}

/* hover log card (TOP position) */
(function(){
  const card = document.getElementById('btlstLogCard');
  const set = (id, val) => document.getElementById(id).textContent = val || '—';

  function showCard(el){
    set('lg_cby', el.dataset.cby);
    set('lg_cat', el.dataset.cat);
    set('lg_uby', el.dataset.uby);
    set('lg_uat', el.dataset.uat);

    // first show to measure
    card.style.display = 'block';
    card.setAttribute('aria-hidden','false');

    const rect   = el.getBoundingClientRect();
    const topTry = rect.top + window.scrollY - card.offsetHeight - 10; // ABOVE
    const leftTry= rect.left + window.scrollX + rect.width/2 - card.offsetWidth/2; // centered

    // clamp horizontally
    const minLeft = 8, maxLeft = window.scrollX + document.documentElement.clientWidth - card.offsetWidth - 8;
    let left = Math.max(minLeft, Math.min(leftTry, maxLeft));

    // if not enough space above, fallback below
    let top = topTry;
    if (topTry < window.scrollY + 8){
      top = rect.bottom + window.scrollY + 10;           // place below
      card.style.transformOrigin = 'top center';
      card.style.setProperty('--arrow-dir','up');
      card.style.removeProperty('bottom');
      // flip arrow (pointing up) by rotating pseudo-element
      card.style.setProperty('--flip', '1');
      card.style.setProperty('--arrow-bottom', 'auto');
      card.style.setProperty('--arrow-top', '-8px');
      card.style.setProperty('--arrow-border-top', 'none');
    } else {
      // keep arrow at bottom (pointing down to icon)
      card.style.removeProperty('--flip');
      card.style.setProperty('--arrow-top', 'auto');
    }

    card.style.top  = top + 'px';
    card.style.left = left + 'px';
  }

  function hideCard(){
    card.style.display = 'none';
    card.setAttribute('aria-hidden','true');
  }

  document.addEventListener('mouseover', e=>{
    const info = e.target.closest('.js-info');
    if(info){ showCard(info); }
  });
  document.addEventListener('mouseout', e=>{
    if(!e.relatedTarget || (!e.relatedTarget.closest('#btlstLogCard') && !e.relatedTarget.closest('.js-info'))){
      hideCard();
    }
  });
  card.addEventListener('mouseleave', hideCard);
})();
</script>
@endsection
