@extends('layouts.app')
@section('title','Edit Bag Type')

@section('content')
<form class="btfrm-card"
      method="POST"
      action="{{ route('products.bag-types.update', $bagType->id) }}">
    @csrf
    @method('PUT')

    <div class="btfrm-head">
        <div class="btfrm-title">
            <i class="fa fa-cog"></i>
            <span>Edit Bag Type</span>
        </div>
        <a href="{{ route('products.bag-types.index') }}" class="btfrm-link">
            <i class="fa fa-list"></i> Bag Type List
        </a>
    </div>

    <div class="btfrm-body">
        {{-- Bag Type Name --}}
        <div class="btfrm-row">
            <div class="btfrm-label">
                Bag Type Name <span class="btfrm-req">*</span>
            </div>
            <div class="btfrm-field">
                <input type="text"
                       name="name"
                       value="{{ old('name', $bagType->name) }}"
                       class="btfrm-input"
                       placeholder="Enter The Bag Type Name"
                       required>
                @error('name') <div class="btfrm-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Bag Size --}}
        <div class="btfrm-row">
            <div class="btfrm-label">Bag Size <span class="btfrm-req">*</span></div>
            <div class="btfrm-field">
                <input type="number"
                       step="0.01"
                       min="0"
                       name="bag_size"
                       value="{{ old('bag_size', $bagType->bag_size) }}"
                       class="btfrm-input"
                       placeholder="Enter The Bag Size Quantity"
                       required>
                @error('bag_size') <div class="btfrm-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Status --}}
        <div class="btfrm-row">
            <div class="btfrm-label">Status</div>
            <div class="btfrm-field">
                @php $st = (string) old('status', $bagType->status ?? '1'); @endphp
                <select name="status" class="btfrm-select">
                    <option value="1" {{ $st==='1' ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ $st==='0' ? 'selected' : '' }}>Inactive</option>
                </select>
                @error('status') <div class="btfrm-error">{{ $message }}</div> @enderror
            </div>
        </div>

        <div class="btfrm-actions">
            <button type="submit" class="btfrm-btn btfrm-btn-save">
                <i class="fa fa-save"></i> Update
            </button>
            <button type="reset" class="btfrm-btn btfrm-btn-reset">
                <i class="fa fa-rotate"></i> Reset
            </button>
        </div>
    </div>
</form>

<style>
/* ===== Scoped styles: Bag Type Form (btfrm-) ===== */
.btfrm-card{border:1px solid #e5e7eb;border-radius:6px;background:#fff;max-width:1120px;margin:0 auto;box-shadow:0 1px 1px rgba(0,0,0,.02)}
.btfrm-head{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid #e9edf3;background:linear-gradient(180deg,#eef2f7 0%,#e7edf7 100%)}
.btfrm-title{display:flex;align-items:center;gap:8px;font-weight:700;color:#2563eb;font-size:18px}
.btfrm-title .fa{color:#3b82f6}
.btfrm-link{display:inline-flex;align-items:center;gap:6px;background:#f1f5f9;border:1px solid #dbe4ee;color:#2563eb;text-decoration:none;padding:6px 10px;border-radius:4px;font-weight:600}
.btfrm-link:hover{background:#e6eef8}

.btfrm-body{padding:18px}
.btfrm-row{display:flex;align-items:center;margin-bottom:16px}
.btfrm-label{flex:0 0 220px;background:#eef1f5;border:1px solid #e3e7ee;border-right:0;border-radius:4px 0 0 4px;padding:10px 14px;color:#475569;font-weight:600;text-align:center}
.btfrm-req{color:#ef4444}
.btfrm-field{flex:1}
.btfrm-input,.btfrm-select{
  width:100%;height:38px;border:1px solid #e3e7ee;border-left:0;border-radius:0 4px 4px 0;
  padding:0 12px;outline:none;color:#111827;background:#fff;
}
.btfrm-input:focus,.btfrm-select:focus{
  border-color:#fb923c; box-shadow:0 0 0 2px rgba(251,146,60,.25);
}
.btfrm-error{margin-top:6px;color:#b91c1c;font-size:13px}

.btfrm-actions{display:flex;gap:10px;justify-content:flex-start;padding:12px 4px}
.btfrm-btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:4px;padding:8px 12px;color:#fff;font-weight:700;cursor:pointer}
.btfrm-btn-save{background:#6ab47c}
.btfrm-btn-save:hover{filter:brightness(.95)}
.btfrm-btn-reset{background:#9aa9b8}
.btfrm-btn-reset:hover{filter:brightness(.95)}
</style>
@endsection
