{{-- resources/views/products/bag-types/create.blade.php --}}
@extends('layouts.app')
@section('title','Add New Bag Type')

@section('content')
<form class="btform-card" method="POST" action="{{ route('products.bag-types.store') }}">
    @csrf

    <div class="btform-head">
        <div class="btform-title">
            <i class="fa fa-cog"></i>
            <span>Add New Bag Type</span>
        </div>
        <a href="{{ route('products.bag-types.index') }}" class="btform-link">
            <i class="fa fa-list"></i> Bag Type List
        </a>
    </div>

    <div class="btform-body">

        {{-- Bag Type Name --}}
        <div class="btform-row">
            <div class="btform-label">
                Bag Type Name <span class="btform-req">*</span>
            </div>
            <div class="btform-field">
                <input type="text" name="name" value="{{ old('name') }}"
                       class="btform-input" placeholder="Enter The  Bag Type Name" required>
                @error('name') <div class="btform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Bag Size --}}
        <div class="btform-row">
            <div class="btform-label">
                Bag Size <span class="btform-req">*</span>
            </div>
            <div class="btform-field">
                <input type="number" step="0.01" min="0"
                       name="bag_size" value="{{ old('bag_size') }}"
                       class="btform-input" placeholder="Enter The Bag Size Quantity" required>
                @error('bag_size') <div class="btform-error">{{ $message }}</div> @enderror
            </div>
        </div>

        {{-- Status --}}
        <div class="btform-row">
            <div class="btform-label">Status</div>
            <div class="btform-field">
                <select name="status" class="btform-select">
                    <option value="1" {{ old('status','1')=='1' ? 'selected' : '' }}>Active</option>
                    <option value="0" {{ old('status')==='0' ? 'selected' : '' }}>Inactive</option>
                </select>
            </div>
        </div>

        <div class="btform-actions">
            <button type="submit" class="btform-btn btform-btn-save">
                <i class="fa fa-save"></i> Save
            </button>
            <button type="reset" class="btform-btn btform-btn-reset">
                <i class="fa fa-rotate"></i> Reset
            </button>
        </div>
    </div>
</form>

<style>
/* ===== Bag Type Create (scoped, prefix: btform-) ===== */
.btform-card{border:1px solid #e5e7eb;border-radius:6px;background:#fff;max-width:1120px;margin:0 auto;box-shadow:0 1px 1px rgba(0,0,0,.02)}
.btform-head{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid #e9edf3;background:linear-gradient(180deg,#eef2f7 0%,#e7edf7 100%)}
.btform-title{display:flex;align-items:center;gap:8px;font-weight:700;color:#2563eb;font-size:18px}
.btform-title .fa{color:#3b82f6}
.btform-link{display:inline-flex;align-items:center;gap:6px;background:#f1f5f9;border:1px solid #dbe4ee;color:#2563eb;text-decoration:none;padding:6px 10px;border-radius:4px;font-weight:600}
.btform-link:hover{background:#e6eef8}

.btform-body{padding:18px}
.btform-row{display:flex;align-items:center;margin-bottom:16px}
.btform-label{flex:0 0 220px;background:#eef1f5;border:1px solid #e3e7ee;border-right:0;border-radius:4px 0 0 4px;padding:10px 14px;color:#475569;font-weight:600;text-align:center}
.btform-req{color:#ef4444}
.btform-field{flex:1}
.btform-input,.btform-select{
    width:100%;height:38px;border:1px solid #e3e7ee;border-left:0;border-radius:0 4px 4px 0;
    padding:0 12px;outline:none;color:#111827;background:#fff;
}
.btform-input:focus,.btform-select:focus{
    border-color:#fb923c; box-shadow:0 0 0 2px rgba(251,146,60,.25);
}
.btform-error{margin-top:6px;color:#b91c1c;font-size:13px}

.btform-actions{display:flex;gap:10px;justify-content:flex-end;padding:12px 4px}
.btform-btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:4px;padding:8px 12px;color:#fff;font-weight:700;cursor:pointer}
.btform-btn-save{background:#6ab47c}
.btform-btn-save:hover{filter:brightness(.95)}
.btform-btn-reset{background:#9aa9b8}
.btform-btn-reset:hover{filter:brightness(.95)}
</style>
@endsection
