@extends('layouts.app')
@section('title','Area List')

@section('content')
<div class="arx">

  {{-- Title bar --}}
  <div class="arx-titlebar">
    <div class="arx-title">
      <i class="fa fa-list-ul"></i>
      <span>Area List</span>
    </div>

    <a href="{{ route('products.areas.create') }}" class="arx-add-btn">
      <i class="fa fa-plus"></i> Add Area
    </a>
  </div>

  {{-- Card + table --}}
  <div class="arx-card">
    <div class="arx-card-head">
      <div></div>
      <label class="arx-search">
        <span>Search:</span>
        <input type="text" oninput="arxFilter(this.value)" placeholder="">
      </label>
    </div>

    <div class="arx-table-wrap">
      <table class="arx-table" id="arxTable">
        <thead>
          <tr>
            <th style="width:70px">SL</th>
            <th>Area Name</th>
            <th style="width:160px">Status</th>
            <th style="width:200px">Action</th>
          </tr>
        </thead>
        <tbody>
          @forelse($areas as $area)
            @php
              $sl = ($areas instanceof \Illuminate\Pagination\LengthAwarePaginator)
                    ? $areas->firstItem() + $loop->index
                    : $loop->iteration;
              $active = (string)($area->status ?? '1') === '1';
            @endphp
            <tr>
              <td>{{ $sl }}</td>
              <td>{{ $area->name }}</td>
              <td>
                @if($active)
                  <span class="arx-badge arx-badge-green">Active</span>
                @else
                  <span class="arx-badge">Inactive</span>
                @endif
              </td>
              <td class="arx-actions">
                <a href="{{ route('products.areas.edit', $area->id) }}" class="arx-btn arx-btn-green" title="Edit">
                  <i class="fa fa-pen"></i>
                </a>

                <form action="{{ route('products.areas.destroy', $area->id) }}" method="POST" style="display:inline">
                  @csrf
                  @method('DELETE')
                  <button type="submit" class="arx-btn arx-btn-red" title="Delete"
                          onclick="return confirm('Delete this area?')">
                    <i class="fa fa-trash"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="4" style="color:#6b7280">No data available in table</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- Pagination --}}
    @if($areas instanceof \Illuminate\Pagination\LengthAwarePaginator)
      <div class="arx-paginate">{{ $areas->links() }}</div>
    @endif
  </div>
</div>

<style>
.arx{margin-top:6px}
.arx-titlebar{display:flex;align-items:center;justify-content:space-between;margin-bottom:10px}
.arx-title{display:flex;align-items:center;gap:10px;color:#1f4b99}
.arx-title .fa{color:#1f7bd8;font-size:22px}
.arx-title span{font-size:26px;font-weight:600}
.arx-add-btn{background:#7ab7e3;color:#fff;border:1px solid #6aa7d5;text-decoration:none;padding:7px 11px;border-radius:3px;font-size:14px;display:inline-flex;align-items:center;gap:6px}
.arx-add-btn:hover{filter:brightness(.97)}
.arx-card{border:1px solid #dbe3ee;border-radius:3px;background:#fff}
.arx-card-head{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid #dbe3ee;background:#eef3f9}
.arx-search{display:flex;align-items:center;gap:8px;font-size:14px;color:#374151}
.arx-search input{height:26px;width:180px;border:1px solid #cfd9e5;border-radius:2px;padding:0 6px;outline:none}
.arx-search input:focus{border-color:#89b8ef;box-shadow:0 0 0 2px rgba(49,132,255,.15)}
.arx-table{width:100%;border-collapse:collapse}
.arx-table thead th{padding:10px;text-align:left;background:linear-gradient(180deg,#f5f7fb 0%,#e9edf3 100%);border:1px solid #e2e8f0;color:#1f4b99;font-weight:700;font-size:14px}
.arx-table tbody td{padding:10px;border:1px solid #e9eef5;font-size:14px;color:#111827}
.arx-table tbody tr:nth-child(odd){background:#fafcfe}
.arx-badge{display:inline-block;padding:3px 8px;border-radius:2px;font-size:12px;background:#e6e7eb;color:#374151;font-weight:700}
.arx-badge-green{background:#8be27d;color:#0e4b15}
.arx-actions{display:flex;align-items:center;gap:6px}
.arx-btn{width:26px;height:26px;border-radius:2px;display:inline-flex;align-items:center;justify-content:center;color:#fff;border:1px solid transparent;text-decoration:none;cursor:pointer}
.arx-btn .fa{font-size:13px}
.arx-btn-green{background:#38b36b;border-color:#2e9a5b}
.arx-btn-red{background:#e2554f;border-color:#c24741}
.arx-paginate{padding:10px 12px;border-top:1px solid #e9edf3}
</style>

<script>
function arxFilter(q){
  const rows = document.querySelectorAll('#arxTable tbody tr');
  const term = (q||'').toLowerCase();
  rows.forEach(r => {
    if (r.querySelector('td[colspan]')) { r.style.display=''; return; }
    r.style.display = r.innerText.toLowerCase().includes(term) ? '' : 'none';
  });
}
</script>
@endsection
