@extends('layouts.app')
@section('title','Edit Area')

@section('content')
<div class="arw">
  <div class="arw-panel">
    <div class="arw-head">
      <div class="arw-left"><i class="fa fa-cog"></i><span>Edit Area</span></div>
      <a href="{{ route('products.areas.index') }}" class="arw-link"><i class="fa fa-list"></i> Area List</a>
    </div>

    <div class="arw-body">
      <form action="{{ route('products.areas.update', $area->id) }}" method="POST" autocomplete="off">
        @csrf
        @method('PUT')

        {{-- Area Name --}}
        <div class="arw-row @error('name') has-error @enderror">
          <div class="arw-label">Area Name <span class="req">*</span></div>
          <div class="arw-ctrl">
            <input type="text"
                   name="name"
                   class="arw-input"
                   value="{{ old('name', $area->name) }}"
                   required>
            @error('name') <div class="arw-help">{{ $message }}</div> @enderror
          </div>
        </div>

        {{-- Status --}}
        @php $sv = (string)old('status', (string)$area->status); @endphp
        <div class="arw-row @error('status') has-error @enderror">
          <div class="arw-label">Status</div>
          <div class="arw-ctrl">
            <select name="status" class="arw-select">
              <option value="1" {{ $sv==='1' ? 'selected' : '' }}>Active</option>
              <option value="0" {{ $sv==='0' ? 'selected' : '' }}>Inactive</option>
            </select>
            @error('status') <div class="arw-help">{{ $message }}</div> @enderror
          </div>
        </div>

        <div class="arw-actions">
          <button type="submit" class="btn-ico btn-green"><i class="fa fa-save"></i> Update</button>
          <button type="reset"  class="btn-ico btn-gray"><i class="fa fa-refresh"></i> Reset</button>
        </div>
      </form>
    </div>
  </div>
</div>

{{-- same scoped styles as create --}}
<style>
.arw{padding:10px}
.arw-panel{border:1px solid #d9d9d9;border-radius:2px;background:#fff}
.arw-head{display:flex;justify-content:space-between;align-items:center;padding:10px 12px;border-bottom:1px solid #e6e6e6;background:linear-gradient(#f7f7f7,#ececec)}
.arw-left{display:flex;gap:8px;align-items:center;color:#2b78c5;font-weight:600}
.arw-link{border:1px solid #c7d7ea;background:#f3f8ff;color:#2b78c5;padding:6px 10px;border-radius:2px;text-decoration:none}
.arw-body{padding:18px}
.arw-row{display:flex;align-items:center;margin-bottom:16px}
.arw-label{width:160px;min-width:160px;background:#f0f2f5;border:1px solid #d9d9d9;border-right:none;border-radius:3px 0 0 3px;padding:10px 14px;text-align:center;font-weight:600;color:#666}
.arw-ctrl{flex:1}
.arw-input,.arw-select{width:100%;height:36px;border:1px solid #d9d9d9;border-radius:0 3px 3px 0;padding:9px 12px;background:#fff}
.arw-actions{text-align:right;margin-top:12px}
.btn-ico{display:inline-flex;align-items:center;gap:8px;padding:9px 14px;border-radius:3px;border:1px solid transparent;font-weight:600;cursor:pointer}
.btn-green{background:#7dbd71;border-color:#6fb064;color:#fff}
.btn-gray{background:#e7edf3;border-color:#d4dbe2;color:#3b4b5c}
.req{color:#e23b3b}
.arw-help{margin-top:6px;color:#a94442}
.has-error .arw-input,.has-error .arw-select{border-color:#a94442}
</style>
@endsection
