@extends('layouts.app')
@section('title','Permissions')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111;--primary:#1d4ed8}
  .wrap{max-width:1100px;margin:0 auto}
  .card{background:var(--card);border:1px solid var(--border);border-radius:10px}
  .card-header{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
  .card-body{padding:16px}
  .title{font-size:18px;font-weight:800}
  .muted{color:var(--muted)}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:var(--primary);color:#fff}
  .btn-ghost{background:#f3f4f6}
  .input{border:1px solid var(--border);border-radius:8px;padding:8px 10px}
  table{width:100%;border-collapse:collapse}
  thead th{font-size:12px;text-transform:uppercase;color:var(--muted);text-align:left;border-bottom:1px solid var(--border);padding:10px}
  tbody td{padding:12px 10px;border-bottom:1px solid var(--border);vertical-align:middle}
  .badge{display:inline-block;border-radius:999px;font-size:12px;padding:4px 8px;background:#eef2ff;color:#1d4ed8}
  .dd{position:relative}
  .dd-btn{width:32px;height:32px;border-radius:8px;border:1px solid var(--border);background:#fff;display:flex;align-items:center;justify-content:center;cursor:pointer}
  .dd-menu{position:absolute;right:0;top:40px;background:#fff;border:1px solid var(--border);border-radius:10px;min-width:170px;box-shadow:0 8px 24px rgba(0,0,0,.08);display:none;z-index:30}
  .dd.open .dd-menu{display:block}
  .dd-menu a,.dd-menu form button{display:flex;gap:8px;align-items:center;width:100%;background:transparent;border:0;text-align:left;padding:10px 12px;color:var(--text);cursor:pointer}
  .dd-menu a:hover,.dd-menu form button:hover{background:#f7f7fb}
</style>
@endpush

@section('content')
<div class="wrap">
  <div class="card">
    <div class="card-header">
      <div class="title"><i class="fa-solid fa-lock"></i> Permissions</div>
      <div style="display:flex;gap:10px;align-items:center">
        <form method="GET" action="{{ route('permissions.index') }}" style="display:flex;gap:8px">
          <input type="text" name="q" value="{{ request('q') }}" class="input" placeholder="Search permission...">
          <button class="btn btn-ghost" type="submit"><i class="fa-solid fa-magnifying-glass"></i> Search</button>
        </form>
        @if(Route::has('permissions.create'))
        <a href="{{ route('permissions.create') }}" class="btn btn-primary">
          <i class="fa-solid fa-circle-plus"></i> Add Permission
        </a>
        @endif
      </div>
    </div>

    <div class="card-body">
      @if(session('status'))
        <div class="badge" style="margin-bottom:10px">{{ session('status') }}</div>
      @endif

      <div class="table-responsive">
        <table>
          <thead>
            <tr>
              <th style="width:60px">#</th>
              <th>Permission</th>
              <th style="width:140px">Guard</th>
              <th style="width:160px">Attached (roles)</th>
              <th style="width:70px">Actions</th>
            </tr>
          </thead>
          <tbody>
            @forelse($permissions as $i=>$perm)
              <tr>
                <td>{{ method_exists($permissions,'firstItem') ? $permissions->firstItem()+$i : $i+1 }}</td>
                <td style="font-weight:700">{{ $perm->name }}</td>
                <td class="muted">{{ $perm->guard_name ?? 'web' }}</td>
                <td>
                  @php $rc = $perm->roles_count ?? ($perm->roles->count() ?? 0); @endphp
                  <span class="badge">{{ $rc }} roles</span>
                </td>
                <td>
                  <div class="dd">
                    <button class="dd-btn" type="button" aria-label="Actions">
                      <i class="fa-solid fa-ellipsis-vertical"></i>
                    </button>
                    <div class="dd-menu">
                      @if(Route::has('permissions.edit'))
                        <a href="{{ route('permissions.edit', $perm->id) }}"><i class="fa-regular fa-pen-to-square"></i> Edit</a>
                      @endif
                      @if(Route::has('permissions.destroy'))
                        <form action="{{ route('permissions.destroy', $perm->id) }}" method="POST" onsubmit="return confirm('Delete this permission?')">
                          @csrf @method('DELETE')
                          <button type="submit" style="color:#b91c1c"><i class="fa-regular fa-trash-can"></i> Delete</button>
                        </form>
                      @endif
                    </div>
                  </div>
                </td>
              </tr>
            @empty
              <tr><td colspan="5" class="muted">No permissions found.</td></tr>
            @endforelse
          </tbody>
        </table>
      </div>

      @if(method_exists(($permissions ?? null),'links'))
        <div style="margin-top:12px">{{ $permissions->links() }}</div>
      @endif
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
  // actions dropdown
  document.querySelectorAll('.dd-btn').forEach(b=>{
    b.addEventListener('click', e=>{
      e.stopPropagation();
      document.querySelectorAll('.dd').forEach(d=>d.classList.remove('open'));
      b.closest('.dd').classList.toggle('open');
    });
  });
  document.addEventListener('click', ()=> document.querySelectorAll('.dd').forEach(d=>d.classList.remove('open')));
</script>
@endpush
